/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health.selftest;

import java.util.List;
import java.util.stream.Collectors;
import no.nav.common.health.HealthCheckResult;
import no.nav.common.health.HealthCheckUtils;
import no.nav.common.health.selftest.SelfTestCheck;
import no.nav.common.health.selftest.SelfTestStatus;
import no.nav.common.health.selftest.SelftTestCheckResult;

public class SelfTestUtils {
    public static List<SelftTestCheckResult> checkAll(List<SelfTestCheck> checks) {
        return checks.stream().map(SelfTestUtils::performSelftTestCheck).collect(Collectors.toList());
    }

    public static List<SelftTestCheckResult> checkAllParallel(List<SelfTestCheck> checks) {
        return checks.parallelStream().map(SelfTestUtils::performSelftTestCheck).collect(Collectors.toList());
    }

    public static SelfTestStatus toStatus(SelftTestCheckResult result) {
        boolean isHealthy = result.checkResult.isHealthy();
        boolean isCritical = result.selfTestCheck.isCritical();
        if (isHealthy) {
            return SelfTestStatus.OK;
        }
        return isCritical ? SelfTestStatus.ERROR : SelfTestStatus.WARNING;
    }

    public static int findHttpStatusCode(List<SelftTestCheckResult> checkResults) {
        return SelfTestUtils.findHttpStatusCode(checkResults, false);
    }

    public static int findHttpStatusCode(List<SelftTestCheckResult> checkResults, boolean failOnWarning) {
        SelfTestStatus status = SelfTestUtils.aggregateStatus(checkResults);
        if (failOnWarning && status == SelfTestStatus.WARNING || status == SelfTestStatus.ERROR) {
            return 500;
        }
        return 200;
    }

    public static SelfTestStatus aggregateStatus(List<SelftTestCheckResult> checkResults) {
        List statuses = checkResults.stream().map(SelfTestUtils::toStatus).collect(Collectors.toList());
        boolean hasError = statuses.stream().anyMatch(s -> s == SelfTestStatus.ERROR);
        boolean hasWarning = statuses.stream().anyMatch(s -> s == SelfTestStatus.WARNING);
        if (hasError) {
            return SelfTestStatus.ERROR;
        }
        if (hasWarning) {
            return SelfTestStatus.WARNING;
        }
        return SelfTestStatus.OK;
    }

    public static SelftTestCheckResult performSelftTestCheck(SelfTestCheck check) {
        long beforeCheck = System.currentTimeMillis();
        HealthCheckResult result = HealthCheckUtils.safeCheckHealth(check.getCheck());
        long timeUsed = System.currentTimeMillis() - beforeCheck;
        return new SelftTestCheckResult(check, result, timeUsed);
    }
}

