/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.health.selftest;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.common.health.selftest.SelfTestCheck;
import no.nav.common.health.selftest.SelfTestStatus;
import no.nav.common.health.selftest.SelfTestUtils;
import no.nav.common.health.selftest.SelftTestCheckResult;
import no.nav.common.health.selftest.SelftestHtmlGenerator;
import no.nav.common.utils.EnvironmentUtils;

public class SelftTestServlet
extends HttpServlet {
    private final List<SelfTestCheck> checks;

    public SelftTestServlet(List<SelfTestCheck> checks) {
        this.checks = checks;
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String host = EnvironmentUtils.resolveHostName();
        LocalDateTime now = LocalDateTime.now();
        List<SelftTestCheckResult> checkResults = SelfTestUtils.checkAll(this.checks);
        String html = SelftestHtmlGenerator.generate(checkResults, host, now);
        int status = SelfTestUtils.aggregateStatus(checkResults) == SelfTestStatus.ERROR ? 500 : 200;
        resp.setStatus(status);
        resp.setContentType("text/html");
        resp.getWriter().write(html);
    }
}

