/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.InputStream;
import java.util.List;
import no.nav.common.json.JsonMapper;

public class JsonUtils {
    private static final ObjectMapper objectMapper = JsonMapper.defaultObjectMapper();

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    public static String toJson(Object obj) {
        return obj != null ? objectMapper.writeValueAsString(obj) : null;
    }

    public static <T> T fromJson(String json, Class<T> valueClass) {
        return (T)objectMapper.readValue(json, valueClass);
    }

    public static <T> T fromJson(InputStream inputStream, Class<T> valueClass) {
        return (T)objectMapper.readValue(inputStream, valueClass);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return (T)objectMapper.readValue(json, type);
    }

    public static <T> T fromJson(InputStream inputStream, TypeReference<T> type) {
        return (T)objectMapper.readValue(inputStream, type);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> valueClass) {
        return (List)objectMapper.readValue(json, (JavaType)JsonUtils.listType(valueClass));
    }

    public static <T> List<T> fromJsonArray(InputStream inputStream, Class<T> valueClass) {
        return (List)objectMapper.readValue(inputStream, (JavaType)JsonUtils.listType(valueClass));
    }

    private static <T> CollectionType listType(Class<T> valueClass) {
        return objectMapper.getTypeFactory().constructCollectionType(List.class, valueClass);
    }
}

