/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import no.nav.metrics.MetricsConfig;
import no.nav.metrics.handlers.InfluxHandler;
import no.nav.metrics.handlers.SensuHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsClient {
    private static final Logger log = LoggerFactory.getLogger(MetricsClient.class);
    private static volatile boolean metricsReportEnabled;
    private static volatile SensuHandler sensuHandler;
    private static volatile MetricsConfig metricsConfig;

    public static void enableMetrics(MetricsConfig metricsConfig) {
        if (!metricsReportEnabled) {
            MetricsClient.metricsConfig = metricsConfig;
            sensuHandler = new SensuHandler(metricsConfig);
            metricsReportEnabled = true;
        }
    }

    public static void resetMetrics(MetricsConfig metricsConfig) {
        if (sensuHandler != null) {
            sensuHandler.shutdown();
        }
        metricsReportEnabled = false;
        MetricsClient.enableMetrics(metricsConfig);
    }

    void report(String metricName, Map<String, Object> fields, Map<String, String> tagsFromMetric, long timestampInMilliseconds) {
        if (metricsReportEnabled) {
            tagsFromMetric.putIfAbsent("application", metricsConfig.getApplication());
            tagsFromMetric.putIfAbsent("hostname", metricsConfig.getHostname());
            tagsFromMetric.putIfAbsent("environment", metricsConfig.getEnvironment());
            long timestamp = TimeUnit.MILLISECONDS.toNanos(timestampInMilliseconds);
            String output = InfluxHandler.createLineProtocolPayload(metricName, tagsFromMetric, fields, timestamp);
            sensuHandler.report(output);
        }
    }

    static {
        log.warn("metrics was not automatically enabled");
    }
}

