/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import no.nav.metrics.Metric;
import no.nav.metrics.MetricsClient;
import no.nav.metrics.Timing;

public class Timer
extends Metric<Timer> {
    private final Timing timing;
    private long measureTimestamp;
    private long startTime;
    private long stopTime;

    Timer(MetricsClient metricsClient, String name, Timing timing) {
        super(metricsClient, name + ".timer");
        this.timing = timing;
    }

    public Timer start() {
        this.measureTimestamp = this.timing.currentTimeMillis();
        this.startTime = this.timing.nanoTime();
        return this;
    }

    public Timer stop() {
        this.stopTime = this.timing.nanoTime();
        this.addFieldToReport("value", this.getElpasedTimeInMillis());
        return this;
    }

    long getElpasedTimeInMillis() {
        long elapsedTimeNanos = this.stopTime - this.startTime;
        return TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos);
    }

    @Override
    protected Timer self() {
        return this;
    }

    @Override
    public Timer report() {
        this.ensureTimerIsStopped();
        this.metricsClient.report(this.name, this.fields, this.tags, this.measureTimestamp);
        this.reset();
        return this;
    }

    private void ensureTimerIsStopped() {
        if (!this.fields.containsKey("value")) {
            throw new IllegalStateException("Must stop timer before reporting!");
        }
    }

    private void reset() {
        this.measureTimestamp = 0L;
        this.startTime = 0L;
        this.stopTime = 0L;
        this.fields = new HashMap();
    }
}

