/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics.aspects;

import no.nav.metrics.proxy.MetricProxy;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;

public class AspectUtil {
    public static String lagMetodeTimernavn(JoinPoint joinPoint, String sattNavn) {
        if (StringUtils.isBlank((CharSequence)sattNavn)) {
            return AspectUtil.getKlassenavn(joinPoint) + "." + AspectUtil.getMetodenavn(joinPoint);
        }
        return sattNavn;
    }

    public static String lagKlasseTimernavn(JoinPoint joinPoint, String sattNavn) {
        if (StringUtils.isBlank((CharSequence)sattNavn)) {
            return AspectUtil.getKlassenavn(joinPoint) + "." + AspectUtil.getMetodenavn(joinPoint);
        }
        return sattNavn + "." + AspectUtil.getMetodenavn(joinPoint);
    }

    public static String getKlassenavn(JoinPoint joinPoint) {
        return joinPoint.getSignature().getDeclaringType().getSimpleName();
    }

    public static String getMetodenavn(JoinPoint joinPoint) {
        return joinPoint.getSignature().getName();
    }

    public static boolean metodeSkalIgnoreres(String metodeNavn, String[] ignorerteMetoder) {
        for (String ignorert : ignorerteMetoder) {
            if (!metodeNavn.equals(ignorert)) continue;
            return true;
        }
        return MetricProxy.DO_NOT_MEASURE_METHOD_NAMES.contains(metodeNavn);
    }
}

