/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static final Logger log = LoggerFactory.getLogger(RestUtils.class);
    private static final Gson gson = new Gson();
    public static MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static void throwIfNotSuccessful(Response response) {
        if (!response.isSuccessful()) {
            String message = String.format("Uventet status %d ved kall mot mot %s", response.code(), response.request().url().toString());
            log.error(message);
            throw new RuntimeException(message);
        }
    }

    public static Optional<String> getBodyStr(ResponseBody body) throws IOException {
        if (body == null) {
            return Optional.empty();
        }
        return Optional.of(body.string());
    }

    public static <T> T parseJson(String json, Class<T> classOfT) {
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> T parseJson(String json, Type type) {
        return (T)gson.fromJson(json, type);
    }

    public static <T> Optional<T> parseJsonResponseBody(ResponseBody body, Class<T> classOfT) throws IOException {
        return RestUtils.getBodyStr(body).map(bodyStr -> gson.fromJson(bodyStr, classOfT));
    }

    public static <T> Optional<T> parseJsonResponseBody(ResponseBody body, Type type) throws IOException {
        return RestUtils.getBodyStr(body).map(bodyStr -> gson.fromJson(bodyStr, type));
    }

    public static <T> T parseJsonResponseBodyOrThrow(ResponseBody body, Class<T> classOfT) throws IOException {
        return RestUtils.parseJsonResponseBody(body, classOfT).orElseThrow(() -> new IllegalStateException("Unable to parse JSON from request body"));
    }

    public static <T> T parseJsonResponseBodyOrThrow(ResponseBody body, Type type) throws IOException {
        return RestUtils.parseJsonResponseBody(body, type).orElseThrow(() -> new IllegalStateException("Unable to parse JSON from request body"));
    }

    public static RequestBody toJsonRequestBody(Object toJson) {
        return RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)gson.toJson(toJson));
    }
}

