/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import no.nav.common.json.JsonUtils;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static final Logger log = LoggerFactory.getLogger(RestUtils.class);
    public static MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static String createBearerToken(String token) {
        return "Bearer " + token;
    }

    public static void throwIfNotSuccessful(Response response) {
        if (!response.isSuccessful()) {
            String message = String.format("Uventet status %d ved kall mot mot %s", response.code(), response.request().url().toString());
            log.error(message);
            throw new RuntimeException(message);
        }
    }

    public static Optional<String> getBodyStr(Response response) throws IOException {
        ResponseBody body = response.body();
        if (body == null) {
            return Optional.empty();
        }
        String bodyStr = body.string();
        return bodyStr.isBlank() ? Optional.empty() : Optional.of(bodyStr);
    }

    public static <T> Optional<T> parseJsonResponse(Response response, Class<T> classOfT) throws IOException {
        return RestUtils.getBodyStr(response).map(bodyStr -> JsonUtils.fromJson((String)bodyStr, (Class)classOfT));
    }

    public static <T> Optional<List<T>> parseJsonArrayResponse(Response response, Class<T> classOfT) throws IOException {
        return RestUtils.getBodyStr(response).map(bodyStr -> JsonUtils.fromJsonArray((String)bodyStr, (Class)classOfT));
    }

    public static <T> T parseJsonResponseOrThrow(Response response, Class<T> classOfT) throws IOException {
        return RestUtils.parseJsonResponse(response, classOfT).orElseThrow(() -> new IllegalStateException("Unable to parse JSON object from response body"));
    }

    public static <T> List<T> parseJsonResponseArrayOrThrow(Response response, Class<T> classOfT) throws IOException {
        return RestUtils.parseJsonArrayResponse(response, classOfT).orElseThrow(() -> new IllegalStateException("Unable to parse JSON array from response body"));
    }

    public static RequestBody toJsonRequestBody(Object obj) {
        return RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)JsonUtils.toJson((Object)obj));
    }
}

