/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.sts;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfiguration;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfigurationClient;
import no.nav.common.rest.client.RestClient;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.sts.SystemUserTokenProvider;
import no.nav.common.sts.SystemUserTokenUtils;
import no.nav.common.utils.AuthUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaisSystemUserTokenProvider
implements SystemUserTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(OidcDiscoveryConfigurationClient.class);
    private final OkHttpClient client;
    private final String tokenEndpoint;
    private final String srvUsername;
    private final String srvPassword;
    private JWT accessToken;

    public NaisSystemUserTokenProvider(String discoveryUrl, String srvUsername, String srvPassword) {
        OidcDiscoveryConfigurationClient client = new OidcDiscoveryConfigurationClient();
        OidcDiscoveryConfiguration configuration = client.fetchDiscoveryConfiguration(discoveryUrl);
        this.tokenEndpoint = configuration.tokenEndpoint;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = RestClient.baseClient();
    }

    public NaisSystemUserTokenProvider(String tokenEndpoint, String srvUsername, String srvPassword, OkHttpClient client) {
        this.tokenEndpoint = tokenEndpoint;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = client;
    }

    @Override
    public String getSystemUserToken() {
        if (SystemUserTokenUtils.tokenNeedsRefresh(this.accessToken)) {
            this.accessToken = this.fetchSystemUserToken();
        }
        return this.accessToken.getParsedString();
    }

    private JWT fetchSystemUserToken() {
        JWT jWT;
        block12: {
            String targetUrl = this.tokenEndpoint + "?grant_type=client_credentials&scope=openid";
            String basicAuth = AuthUtils.basicCredentials((String)this.srvUsername, (String)this.srvPassword);
            Request request = new Request.Builder().url(targetUrl).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", basicAuth).build();
            Response response = this.client.newCall(request).execute();
            try {
                if (response.code() >= 300) {
                    String responseStr = RestUtils.getBodyStr((Response)response).orElse("");
                    throw new RuntimeException(String.format("Received unexpected status %d when requesting access token for system user. Response: %s", response.code(), responseStr));
                }
                ClientCredentialsResponse credentialsResponse = (ClientCredentialsResponse)RestUtils.parseJsonResponseOrThrow((Response)response, ClientCredentialsResponse.class);
                jWT = JWTParser.parse((String)credentialsResponse.accessToken);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to fetch system user token from " + targetUrl, (Throwable)e);
                    throw e;
                }
            }
            response.close();
        }
        return jWT;
    }

    public static class ClientCredentialsResponse {
        @JsonAlias(value={"access_token"})
        public String accessToken;
    }
}

