/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.sts;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfiguration;
import no.nav.common.auth.oidc.discovery.OidcDiscoveryConfigurationClient;
import no.nav.common.rest.client.RestClient;
import no.nav.common.sts.OpenAmUtils;
import no.nav.common.sts.SystemUserTokenProvider;
import no.nav.common.sts.SystemUserTokenUtils;
import no.nav.common.utils.Credentials;
import okhttp3.OkHttpClient;

public class OpenAmSystemUserTokenProvider
implements SystemUserTokenProvider {
    private final OkHttpClient client;
    private final String redirectUrl;
    private final String authorizationUrl;
    private final String tokenUrl;
    private final Credentials issoRpCredentials;
    private final Credentials systemUserCredentials;
    private JWT accessToken;

    public OpenAmSystemUserTokenProvider(String discoveryUrl, String redirectUrl, Credentials issoRpCredentials, Credentials systemUserCredentials) {
        OidcDiscoveryConfigurationClient client = new OidcDiscoveryConfigurationClient();
        OidcDiscoveryConfiguration configuration = client.fetchDiscoveryConfiguration(discoveryUrl);
        this.redirectUrl = redirectUrl;
        this.authorizationUrl = configuration.authorizationEndpoint;
        this.tokenUrl = configuration.tokenEndpoint;
        this.issoRpCredentials = issoRpCredentials;
        this.systemUserCredentials = systemUserCredentials;
        this.client = RestClient.baseClient();
    }

    public OpenAmSystemUserTokenProvider(String tokenUrl, String authorizationUrl, String redirectUrl, Credentials issoRpCredentials, Credentials systemUserCredentials, OkHttpClient client) {
        this.tokenUrl = tokenUrl;
        this.authorizationUrl = authorizationUrl;
        this.redirectUrl = redirectUrl;
        this.issoRpCredentials = issoRpCredentials;
        this.systemUserCredentials = systemUserCredentials;
        this.client = client;
    }

    @Override
    public String getSystemUserToken() {
        if (SystemUserTokenUtils.tokenNeedsRefresh(this.accessToken)) {
            this.accessToken = this.fetchSystemUserToken();
        }
        return this.accessToken.getParsedString();
    }

    private JWT fetchSystemUserToken() {
        String openAmSessionToken = OpenAmUtils.getSessionToken(this.systemUserCredentials, this.authorizationUrl, this.client);
        String authorizationCode = OpenAmUtils.getAuthorizationCode(this.authorizationUrl, openAmSessionToken, this.issoRpCredentials.username, this.redirectUrl, this.client);
        String token = OpenAmUtils.exchangeCodeForToken(authorizationCode, this.tokenUrl, this.redirectUrl, this.issoRpCredentials, this.client);
        return JWTParser.parse((String)token);
    }
}

