/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.sts;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import no.nav.common.json.JsonUtils;
import no.nav.common.rest.client.RestUtils;
import no.nav.common.utils.AuthUtils;
import no.nav.common.utils.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenAmUtils {
    private static final String authenticateUri = "json/authenticate?authIndexType=service&authIndexValue=adminconsoleservice";

    private static String lagHentSessionTokenUrl(String authorizationUrl) {
        return authorizationUrl.replace("oauth2/authorize", authenticateUri);
    }

    public static String getSessionToken(Credentials systemUserCredentials, String authorizationUrl, OkHttpClient client) throws IOException {
        String sessionTokenUrl = OpenAmUtils.lagHentSessionTokenUrl(authorizationUrl);
        Request request = new Request.Builder().url(sessionTokenUrl).header("X-OpenAM-Username", systemUserCredentials.username).header("X-OpenAM-Password", systemUserCredentials.password).post(RequestBody.create((MediaType)RestUtils.MEDIA_TYPE_JSON, (String)"{}")).build();
        try (Response response = client.newCall(request).execute();){
            Optional jsonStr = RestUtils.getBodyStr((Response)response);
            if (!jsonStr.isPresent()) {
                throw new IllegalStateException("Body is missing from response");
            }
            JsonNode node = JsonUtils.getMapper().readTree((String)jsonStr.get());
            String string = Optional.ofNullable(node.get("tokenId").asText(null)).orElseThrow(() -> new IllegalStateException("Fant ikke 'tokenId' i responsen"));
            return string;
        }
    }

    public static String getAuthorizationCode(String openAmAuthorizeUrl, String sessionToken, String clientId, String redirectUri, OkHttpClient client) throws IOException {
        String cookie = "nav-isso=" + sessionToken;
        String encodedRedirectUri = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8);
        String fullUrl = openAmAuthorizeUrl + String.format("?response_type=code&scope=openid&client_id=%s&redirect_uri=%s", clientId, encodedRedirectUri);
        Request request = new Request.Builder().url(fullUrl).header("Cookie", cookie).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 302) {
                throw new RuntimeException("Feil ved henting av authorization code, fikk status: " + response.code() + " forventet 302");
            }
            String redirectLocation = response.header("Location");
            String queryParams = redirectLocation.substring(redirectLocation.indexOf("?") + 1);
            String string = Arrays.stream(queryParams.split("&")).filter(s -> s.contains("code=")).map(s -> s.replace("code=", "")).findFirst().orElseThrow(() -> new RuntimeException("Fant ikke authorization code i: " + redirectLocation));
            return string;
        }
    }

    public static String exchangeCodeForToken(String authorizationCode, String tokenUrl, String redirectUri, Credentials issoRpCredentials, OkHttpClient client) throws IOException {
        String urlEncodedRedirectUri = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8);
        String data = "grant_type=authorization_code&realm=/&redirect_uri=" + urlEncodedRedirectUri + "&code=" + authorizationCode;
        Request request = new Request.Builder().url(tokenUrl).header("Authorization", AuthUtils.basicCredentials((String)issoRpCredentials.username, (String)issoRpCredentials.password)).header("Cache-Control", "no-cache").post(RequestBody.create((MediaType)MediaType.get((String)"application/x-www-form-urlencoded"), (String)data)).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) {
                throw new RuntimeException("Feil ved utveksling av code mot token, fikk status: " + response.code() + " forventet 200");
            }
            Optional jsonStr = RestUtils.getBodyStr((Response)response);
            if (!jsonStr.isPresent()) {
                throw new IllegalStateException("Body is missing from response");
            }
            JsonNode node = JsonUtils.getMapper().readTree((String)jsonStr.get());
            String string = Optional.ofNullable(node.get("id_token").asText(null)).orElseThrow(() -> new IllegalStateException("Fant ikke 'id_token' i responsen"));
            return string;
        }
    }
}

