/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.nav.common.utils.Pair;

public class CollectionUtils {
    public static <T> List<List<T>> partition(List<T> list, int partitionSize) {
        ArrayList<List<T>> partitionedList = new ArrayList<List<T>>();
        int listSize = list.size();
        for (int i = 0; i < listSize; i += partitionSize) {
            int toIndex = i + partitionSize;
            if (toIndex > listSize) {
                toIndex = listSize;
            }
            List<T> sublist = list.subList(i, toIndex);
            partitionedList.add(sublist);
        }
        return partitionedList;
    }

    public static <T> List<T> listOf(T ... varargs) {
        return Arrays.asList(varargs);
    }

    public static <T> List<T> listOf(T singleton) {
        return Collections.singletonList(singleton);
    }

    public static <T> Set<T> setOf(T ... varargs) {
        List<T> list = Arrays.asList(varargs);
        return new HashSet<T>(list);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... varargs) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> vararg : varargs) {
            map.put(vararg.getFirst(), vararg.getSecond());
        }
        return map;
    }

    public static <T> List<T> toList(Set<T> set) {
        if (set == null) {
            return null;
        }
        return new ArrayList<T>(set);
    }
}

