/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.util;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.sbl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentUtils.class);
    public static final String APP_NAME_PROPERTY_NAME = "NAIS_APP_NAME";
    public static final String NAIS_NAMESPACE_PROPERTY_NAME = "NAIS_NAMESPACE";
    public static final String NAIS_CLUSTER_NAME_PROPERTY_NAME = "NAIS_CLUSTER_NAME";
    public static final String FASIT_ENVIRONMENT_NAME_PROPERTY_NAME = "FASIT_ENVIRONMENT_NAME";
    public static final String APP_ENVIRONMENT_NAME_PROPERTY_NAME = "APP_ENVIRONMENT_NAME";
    public static final String APP_VERSION_PROPERTY_NAME = "APP_VERSION";

    public static void setProperty(String name, String value, Type type) {
        LOGGER.info("{}={}", (Object)name, (Object)type.format(value));
        System.setProperty(name, value);
    }

    public static String getRequiredProperty(String propertyName, String ... otherPropertyNames) {
        return EnvironmentUtils.getOptionalProperty(propertyName, otherPropertyNames).orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(propertyName, otherPropertyNames)));
    }

    public static Optional<String> getOptionalProperty(String propertyName, String ... otherPropertyNames) {
        String propertyValue = EnvironmentUtils.getProperty(propertyName);
        if (StringUtils.nullOrEmpty(propertyValue) && otherPropertyNames != null) {
            propertyValue = Arrays.stream(otherPropertyNames).map(EnvironmentUtils::getProperty).filter(StringUtils::notNullOrEmpty).findFirst().orElse(null);
        }
        return StringUtils.of(propertyValue);
    }

    public static boolean getPropertyAsBooleanOrElseFalse(String propertyName) {
        return EnvironmentUtils.getOptionalProperty(propertyName, new String[0]).map(Boolean::parseBoolean).orElse(false);
    }

    public static EnviromentClass getEnvironmentClass() {
        return EnvironmentUtils.getEnvironmentName().map(e -> Character.toString(e.charAt(0)).toUpperCase()).map(EnviromentClass::valueOf).orElse(EnviromentClass.UNKNOWN);
    }

    public static boolean isEnvironmentClass(EnviromentClass enviromentClass) {
        return EnvironmentUtils.getEnvironmentClass().equals((Object)enviromentClass);
    }

    public static Optional<String> getApplicationName() {
        return EnvironmentUtils.getOptionalProperty(APP_NAME_PROPERTY_NAME, new String[0]);
    }

    public static String requireApplicationName() {
        return EnvironmentUtils.getApplicationName().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(APP_NAME_PROPERTY_NAME, new String[0])));
    }

    public static Optional<String> getEnvironmentName() {
        return EnvironmentUtils.getOptionalProperty(APP_ENVIRONMENT_NAME_PROPERTY_NAME, FASIT_ENVIRONMENT_NAME_PROPERTY_NAME);
    }

    public static String requireEnvironmentName() {
        return EnvironmentUtils.getEnvironmentName().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(APP_ENVIRONMENT_NAME_PROPERTY_NAME, FASIT_ENVIRONMENT_NAME_PROPERTY_NAME)));
    }

    public static Optional<String> getApplicationVersion() {
        return EnvironmentUtils.getOptionalProperty(APP_VERSION_PROPERTY_NAME, new String[0]);
    }

    public static Optional<String> getNamespace() {
        return EnvironmentUtils.getOptionalProperty(NAIS_NAMESPACE_PROPERTY_NAME, new String[0]);
    }

    public static Optional<String> getClusterName() {
        return EnvironmentUtils.getOptionalProperty(NAIS_CLUSTER_NAME_PROPERTY_NAME, new String[0]);
    }

    public static String requireNamespace() {
        return EnvironmentUtils.getNamespace().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(NAIS_NAMESPACE_PROPERTY_NAME, new String[0])));
    }

    public static String resolveHostName() {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private static String createErrorMessage(String propertyName, String ... otherPropertyNames) {
        if (otherPropertyNames == null) {
            return "mangler property: " + propertyName;
        }
        String properties = Stream.concat(Stream.of(propertyName), Stream.of(otherPropertyNames)).collect(Collectors.joining(", "));
        return "fant ingen av propertyene: " + properties;
    }

    private static String getProperty(String propertyName) {
        return System.getProperty(propertyName, System.getenv(propertyName));
    }

    public static String resolveSrvUserPropertyName() {
        return EnvironmentUtils.asNaisProperty("SRV" + EnvironmentUtils.resolveApplicationName() + "_USERNAME");
    }

    public static String resolverSrvPasswordPropertyName() {
        return EnvironmentUtils.asNaisProperty("SRV" + EnvironmentUtils.resolveApplicationName() + "_PASSWORD");
    }

    private static String resolveApplicationName() {
        return EnvironmentUtils.requireApplicationName().toUpperCase();
    }

    private static String asNaisProperty(String value) {
        return value.replaceAll("\\W", "_");
    }

    public static enum Type {
        SECRET,
        PUBLIC;


        public String format(String value) {
            if (this == PUBLIC) {
                return value;
            }
            return "*******";
        }
    }

    public static enum EnviromentClass {
        UNKNOWN,
        T,
        Q,
        P,
        M;

    }
}

