/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLCalendarUtils {
    private static final DatatypeFactory datatypeFactory = XMLCalendarUtils.getDatatypeFactory();

    private static DatatypeFactory getDatatypeFactory() {
        return DatatypeFactory.newInstance();
    }

    public static XMLGregorianCalendar fromDate(Date date) {
        return Optional.ofNullable(date).map(d -> {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return datatypeFactory.newXMLGregorianCalendar(cal);
        }).orElse(null);
    }

    public static Date toDate(XMLGregorianCalendar xmlGregorianCalendar) {
        return Optional.ofNullable(xmlGregorianCalendar).map(XMLGregorianCalendar::toGregorianCalendar).map(Calendar::getTime).orElse(null);
    }

    public static Timestamp toTimestamp(XMLGregorianCalendar xmlGregorianCalendar) {
        return Optional.ofNullable(xmlGregorianCalendar).map(XMLCalendarUtils::toDate).map(date -> new Timestamp(date.getTime())).orElse(null);
    }
}

