/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.utils;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentUtils.class);
    public static final String NAIS_APP_NAME_PROPERTY_NAME = "NAIS_APP_NAME";
    public static final String NAIS_NAMESPACE_PROPERTY_NAME = "NAIS_NAMESPACE";
    public static final String NAIS_CLUSTER_NAME_PROPERTY_NAME = "NAIS_CLUSTER_NAME";
    public static final List<String> DEV_CLUSTERS = List.of("dev-fss", "dev-sbs", "dev-gcp");
    public static final List<String> PROD_CLUSTERS = List.of("prod-fss", "prod-sbs", "prod-gcp");

    public static void setProperty(String name, String value, Type type) {
        LOGGER.info("{}={}", (Object)name, (Object)type.format(value));
        System.setProperty(name, value);
    }

    public static String getRequiredProperty(String propertyName, String ... otherPropertyNames) {
        return EnvironmentUtils.getOptionalProperty(propertyName, otherPropertyNames).orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(propertyName, otherPropertyNames)));
    }

    public static Optional<String> getOptionalProperty(String propertyName, String ... otherPropertyNames) {
        String propertyValue = EnvironmentUtils.getProperty(propertyName);
        if (StringUtils.nullOrEmpty(propertyValue) && otherPropertyNames != null) {
            propertyValue = Arrays.stream(otherPropertyNames).map(EnvironmentUtils::getProperty).filter(StringUtils::notNullOrEmpty).findFirst().orElse(null);
        }
        return StringUtils.of(propertyValue);
    }

    public static Optional<Boolean> isProduction() {
        return EnvironmentUtils.getClusterName().map(PROD_CLUSTERS::contains);
    }

    public static Optional<Boolean> isDevelopment() {
        return EnvironmentUtils.getClusterName().map(DEV_CLUSTERS::contains);
    }

    public static Optional<String> getApplicationName() {
        return EnvironmentUtils.getOptionalProperty(NAIS_APP_NAME_PROPERTY_NAME, new String[0]);
    }

    public static Optional<String> getNamespace() {
        return EnvironmentUtils.getOptionalProperty(NAIS_NAMESPACE_PROPERTY_NAME, new String[0]);
    }

    public static Optional<String> getClusterName() {
        return EnvironmentUtils.getOptionalProperty(NAIS_CLUSTER_NAME_PROPERTY_NAME, new String[0]);
    }

    public static String requireApplicationName() {
        return EnvironmentUtils.getApplicationName().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(NAIS_APP_NAME_PROPERTY_NAME, new String[0])));
    }

    public static String requireNamespace() {
        return EnvironmentUtils.getNamespace().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(NAIS_NAMESPACE_PROPERTY_NAME, new String[0])));
    }

    public static String requireClusterName() {
        return EnvironmentUtils.getClusterName().orElseThrow(() -> new IllegalStateException(EnvironmentUtils.createErrorMessage(NAIS_CLUSTER_NAME_PROPERTY_NAME, new String[0])));
    }

    public static String resolveHostName() {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private static String createErrorMessage(String propertyName, String ... otherPropertyNames) {
        if (otherPropertyNames == null) {
            return "mangler property: " + propertyName;
        }
        String properties = Stream.concat(Stream.of(propertyName), Stream.of(otherPropertyNames)).collect(Collectors.joining(", "));
        return "fant ingen av propertyene: " + properties;
    }

    private static String getProperty(String propertyName) {
        return System.getProperty(propertyName, System.getenv(propertyName));
    }

    public static enum Type {
        SECRET,
        PUBLIC;


        public String format(String value) {
            if (this == PUBLIC) {
                return value;
            }
            return "*******";
        }
    }
}

