/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.utils;

import lombok.NonNull;
import no.nav.common.utils.EnvironmentUtils;

public class UrlUtils {
    public static String createServiceUrl(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return UrlUtils.createServiceUrl(appName, false);
    }

    public static String createServiceUrl(@NonNull String appName, boolean withAppContextPath) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return UrlUtils.createServiceUrl(appName, EnvironmentUtils.requireNamespace(), withAppContextPath);
    }

    public static String createServiceUrl(@NonNull String appName, @NonNull String namespace, boolean withAppContextPath) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        Object contextPath = withAppContextPath ? "/" + appName : "";
        return String.format("http://%s.%s.svc.nais.local%s", appName, namespace, contextPath);
    }

    public static String createAppAdeoPreprodIngressUrl(@NonNull String appName, @NonNull String environment) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return String.format("https://app-%s.adeo.no/%s", environment, appName);
    }

    public static String createAppAdeoProdIngressUrl(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return String.format("https://app.adeo.no/%s", appName);
    }

    public static String createNaisAdeoIngressUrl(@NonNull String appName, boolean withAppContextPath) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        Object contextPath = withAppContextPath ? "/" + appName : "";
        return String.format("https://%s.nais.adeo.no%s", appName, contextPath);
    }

    public static String createDevAdeoIngressUrl(@NonNull String appName, boolean withAppContextPath) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        Object contextPath = withAppContextPath ? "/" + appName : "";
        return String.format("https://%s.dev.adeo.no%s", appName, contextPath);
    }

    public static String createNaisPreprodIngressUrl(@NonNull String appName, @NonNull String environment, boolean withAppContextPath) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        Object contextPath = withAppContextPath ? "/" + appName : "";
        return String.format("https://%s-%s.nais.preprod.local%s", appName, environment, contextPath);
    }

    public static String sluttMedSlash(String path) {
        if (path == null) {
            return "/";
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public static String startMedSlash(String path) {
        if (path == null) {
            return "/";
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public static String joinPaths(String ... paths) {
        if (paths == null) {
            return "/";
        }
        boolean lastEndsWithSlash = false;
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (path == null || path.isEmpty() || "/".equals(path)) continue;
            sb.append(lastEndsWithSlash ? (path.startsWith("/") ? path.substring(1) : path) : (path.contains("://") ? path : UrlUtils.startMedSlash(path)));
            lastEndsWithSlash = path.endsWith("/");
        }
        return sb.length() == 0 ? "/" : sb.toString();
    }
}

