/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import no.nav.common.JAASContextKt;
import no.nav.common.JAASCredential;
import no.nav.common.JAASCustomUsers;
import no.nav.common.embeddedkafka.KBServer;
import no.nav.common.embeddedschemaregistry.SRServer;
import no.nav.common.embeddedutils.FunctionsKt;
import no.nav.common.embeddedutils.ServerBase;
import no.nav.common.embeddedzookeeper.ZKServer;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005;<=>?Bg\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\u0002022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J\u0006\u00104\u001a\u000202J\b\u00105\u001a\u000202H\u0002J\u0006\u00106\u001a\u000202J\u000e\u00107\u001a\u0004\u0018\u00010\u0013*\u000208H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005*\u000208H\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u000208H\u0002J\u000e\u00109\u001a\u0004\u0018\u00010\u0017*\u00020:H\u0002J\f\u00104\u001a\u000202*\u000208H\u0002J\f\u00104\u001a\u000202*\u00020:H\u0002J\f\u00105\u001a\u000202*\u000208H\u0002J\f\u00105\u001a\u000202*\u00020:H\u0002R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lno/nav/common/KafkaEnvironment;", "Ljava/lang/AutoCloseable;", "noOfBrokers", "", "topicNames", "", "", "topicInfos", "Lno/nav/common/KafkaEnvironment$TopicInfo;", "withSchemaRegistry", "", "withSecurity", "users", "Lno/nav/common/JAASCredential;", "autoStart", "brokerConfigOverrides", "Ljava/util/Properties;", "(ILjava/util/List;Ljava/util/List;ZZLjava/util/List;ZLjava/util/Properties;)V", "adminClient", "Lorg/apache/kafka/clients/admin/AdminClient;", "getAdminClient", "()Lorg/apache/kafka/clients/admin/AdminClient;", "brokers", "Lno/nav/common/embeddedutils/ServerBase;", "getBrokers", "()Ljava/util/List;", "brokersURL", "getBrokersURL", "()Ljava/lang/String;", "kafkaBrokerDataBaseDir", "Ljava/nio/file/Path;", "reqNoOfBrokers", "schemaRegistry", "getSchemaRegistry", "()Lno/nav/common/embeddedutils/ServerBase;", "<set-?>", "Lno/nav/common/KafkaEnvironment$ServerPark;", "serverPark", "getServerPark", "()Lno/nav/common/KafkaEnvironment$ServerPark;", "topics", "topicsCreated", "getWithSecurity", "()Z", "zookeeper", "Lno/nav/common/embeddedzookeeper/ZKServer;", "getZookeeper", "()Lno/nav/common/embeddedzookeeper/ZKServer;", "zookeeperDataBaseDir", "close", "", "createTopics", "start", "stop", "tearDown", "createAdminClient", "Lno/nav/common/KafkaEnvironment$BrokerStatus;", "getSchemaReg", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "BrokerStatus", "SchemaRegistryStatus", "ServerPark", "ServerParkStatus", "TopicInfo", "kafka-embedded-env"})
@SourceDebugExtension(value={"SMAP\nKafkaEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaEnvironment.kt\nno/nav/common/KafkaEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n1549#2:325\n1620#2,3:326\n1549#2:329\n1620#2,3:330\n1549#2:333\n1620#2,3:334\n1819#2,8:337\n1855#2,2:345\n1855#2,2:347\n1549#2:349\n1620#2,3:350\n*S KotlinDebug\n*F\n+ 1 KafkaEnvironment.kt\nno/nav/common/KafkaEnvironment\n*L\n58#1:325\n58#1:326,3\n191#1:329\n191#1:330,3\n203#1:333\n203#1:334,3\n203#1:337,8\n71#1:345,2\n79#1:347,2\n313#1:349\n313#1:350,3\n*E\n"})
public final class KafkaEnvironment
implements AutoCloseable {
    private final boolean withSecurity;
    @NotNull
    private final List<TopicInfo> topics;
    private final int reqNoOfBrokers;
    private boolean topicsCreated;
    @NotNull
    private final Path zookeeperDataBaseDir;
    @NotNull
    private final Path kafkaBrokerDataBaseDir;
    @NotNull
    private ServerPark serverPark;

    /*
     * WARNING - void declaration
     */
    public KafkaEnvironment(int noOfBrokers, @NotNull List<String> topicNames, @NotNull List<TopicInfo> topicInfos, boolean withSchemaRegistry, boolean withSecurity, @NotNull List<JAASCredential> users, boolean autoStart, @NotNull Properties brokerConfigOverrides) {
        void $this$foldRight$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Iterator name;
        Collection<TopicInfo> collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(topicNames, (String)"topicNames");
        Intrinsics.checkNotNullParameter(topicInfos, (String)"topicInfos");
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Intrinsics.checkNotNullParameter((Object)brokerConfigOverrides, (String)"brokerConfigOverrides");
        this.withSecurity = withSecurity;
        Iterable iterable = topicNames;
        Collection collection2 = topicInfos;
        Object object = this;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TopicInfo((String)((Object)name), 0, null, 6, null));
        }
        collection = (List)destination$iv$iv;
        ((KafkaEnvironment)object).topics = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        this.reqNoOfBrokers = noOfBrokers < 1 && (withSchemaRegistry || !((Collection)this.topics).isEmpty()) ? 1 : (noOfBrokers < 1 ? 0 : (noOfBrokers > 2 ? 2 : noOfBrokers));
        this.zookeeperDataBaseDir = FunctionsKt.appDirFor("inmemoryzookeeper");
        this.kafkaBrokerDataBaseDir = FunctionsKt.appDirFor("inmemorykafkabroker");
        if (this.withSecurity) {
            JAASCustomUsers.INSTANCE.addUsers(users);
            JAASContextKt.setUpJAASContext();
        }
        ZKServer zk = new ZKServer(FunctionsKt.getAvailablePort(), FunctionsKt.dataDirFor(this.zookeeperDataBaseDir), this.withSecurity);
        Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)this.reqNoOfBrokers);
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        name = $this$mapTo$iv$iv2.iterator();
        while (name.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)name).nextInt();
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new KBServer(FunctionsKt.getAvailablePort(), (int)it, this.reqNoOfBrokers, FunctionsKt.dataDirFor(this.kafkaBrokerDataBaseDir), zk.getUrl(), this.withSecurity, brokerConfigOverrides));
        }
        List kBrokers = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = kBrokers;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KBServer bl = (KBServer)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl2 = false;
            object.add(it.getUrl());
        }
        $this$map$iv3 = (List)destination$iv$iv3;
        String initial$iv = "";
        boolean $i$f$foldRight = false;
        String accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                String item$iv$iv = accumulator$iv;
                String u = (String)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = ((CharSequence)acc).length() == 0 ? u : u + "," + (String)acc;
            }
        }
        String brokersURL = accumulator$iv;
        this.serverPark = new ServerPark(zk, this.reqNoOfBrokers == 0 ? (BrokerStatus)BrokerStatus.NotAvailable.INSTANCE : (BrokerStatus)new BrokerStatus.Available(kBrokers, brokersURL), !withSchemaRegistry ? (SchemaRegistryStatus)SchemaRegistryStatus.NotAvailable.INSTANCE : (SchemaRegistryStatus)new SchemaRegistryStatus.Available(new SRServer(FunctionsKt.getAvailablePort(), brokersURL, this.withSecurity)), ServerParkStatus.Initialized.INSTANCE);
        if (autoStart) {
            this.start();
        }
    }

    public /* synthetic */ KafkaEnvironment(int n, List list, List list2, boolean bl, boolean bl2, List list3, boolean bl3, Properties properties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x80) != 0) {
            properties = new Properties();
        }
        this(n, list, list2, bl, bl2, list3, bl3, properties);
    }

    public final boolean getWithSecurity() {
        return this.withSecurity;
    }

    private final void start(BrokerStatus $this$start) {
        if ($this$start instanceof BrokerStatus.Available) {
            Iterable $this$forEach$iv = ((BrokerStatus.Available)$this$start).getBrokers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerBase it = (ServerBase)element$iv;
                boolean bl = false;
                it.start();
            }
        }
    }

    private final void stop(BrokerStatus $this$stop) {
        if ($this$stop instanceof BrokerStatus.Available) {
            Iterable $this$forEach$iv = ((BrokerStatus.Available)$this$stop).getBrokers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerBase it = (ServerBase)element$iv;
                boolean bl = false;
                it.stop();
            }
        }
    }

    private final List<ServerBase> getBrokers(BrokerStatus $this$getBrokers) {
        return $this$getBrokers instanceof BrokerStatus.Available ? ((BrokerStatus.Available)$this$getBrokers).getBrokers() : CollectionsKt.emptyList();
    }

    private final String getBrokersURL(BrokerStatus $this$getBrokersURL) {
        return $this$getBrokersURL instanceof BrokerStatus.Available ? ((BrokerStatus.Available)$this$getBrokersURL).getBrokersURL() : "";
    }

    private final AdminClient createAdminClient(BrokerStatus $this$createAdminClient) {
        AdminClient adminClient;
        if ($this$createAdminClient instanceof BrokerStatus.Available) {
            if (this.serverPark.getStatus() instanceof ServerParkStatus.Started) {
                Properties properties;
                Properties $this$createAdminClient_u24lambda_u243 = properties = new Properties();
                boolean bl = false;
                ((Map)$this$createAdminClient_u24lambda_u243).put("bootstrap.servers", ((BrokerStatus.Available)$this$createAdminClient).getBrokersURL());
                ((Map)$this$createAdminClient_u24lambda_u243).put("client.id", "embkafka-adminclient");
                if (this.withSecurity) {
                    ((Map)$this$createAdminClient_u24lambda_u243).put("security.protocol", "SASL_PLAINTEXT");
                    ((Map)$this$createAdminClient_u24lambda_u243).put("sasl.mechanism", "PLAIN");
                    ((Map)$this$createAdminClient_u24lambda_u243).put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + JAASContextKt.getKafkaClient().getUsername() + "\" password=\"" + JAASContextKt.getKafkaClient().getPassword() + "\";");
                }
                adminClient = AdminClient.create((Properties)properties);
            } else {
                adminClient = null;
            }
        } else {
            adminClient = null;
        }
        return adminClient;
    }

    private final void start(SchemaRegistryStatus $this$start) {
        if ($this$start instanceof SchemaRegistryStatus.Available) {
            ((SchemaRegistryStatus.Available)$this$start).getSchemaRegistry().start();
        }
    }

    private final void stop(SchemaRegistryStatus $this$stop) {
        if ($this$stop instanceof SchemaRegistryStatus.Available) {
            ((SchemaRegistryStatus.Available)$this$stop).getSchemaRegistry().stop();
        }
    }

    private final ServerBase getSchemaReg(SchemaRegistryStatus $this$getSchemaReg) {
        return $this$getSchemaReg instanceof SchemaRegistryStatus.Available ? ((SchemaRegistryStatus.Available)$this$getSchemaReg).getSchemaRegistry() : null;
    }

    @NotNull
    public final ServerPark getServerPark() {
        return this.serverPark;
    }

    @NotNull
    public final ZKServer getZookeeper() {
        ServerBase serverBase = this.serverPark.getZookeeper();
        Intrinsics.checkNotNull((Object)serverBase, (String)"null cannot be cast to non-null type no.nav.common.embeddedzookeeper.ZKServer");
        return (ZKServer)serverBase;
    }

    @NotNull
    public final List<ServerBase> getBrokers() {
        return this.getBrokers(this.serverPark.getBrokerStatus());
    }

    @NotNull
    public final String getBrokersURL() {
        return this.getBrokersURL(this.serverPark.getBrokerStatus());
    }

    @Nullable
    public final AdminClient getAdminClient() {
        return this.createAdminClient(this.serverPark.getBrokerStatus());
    }

    @Nullable
    public final ServerBase getSchemaRegistry() {
        return this.getSchemaReg(this.serverPark.getSchemaRegStatus());
    }

    public final void start() {
        if (this.serverPark.getStatus() instanceof ServerParkStatus.Started || this.serverPark.getStatus() instanceof ServerParkStatus.TearDownCompleted) {
            return;
        }
        ServerPark sp = this.serverPark;
        KafkaEnvironment kafkaEnvironment = this;
        boolean bl = false;
        sp.getZookeeper().start();
        this.start(sp.getBrokerStatus());
        this.start(sp.getSchemaRegStatus());
        kafkaEnvironment.serverPark = new ServerPark(sp.getZookeeper(), sp.getBrokerStatus(), sp.getSchemaRegStatus(), ServerParkStatus.Started.INSTANCE);
        if (this.serverPark.getBrokerStatus() instanceof BrokerStatus.Available && !((Collection)this.topics).isEmpty() && !this.topicsCreated) {
            this.createTopics(this.topics);
        }
    }

    private final void stop() {
        if (this.serverPark.getStatus() instanceof ServerParkStatus.Stopped || this.serverPark.getStatus() instanceof ServerParkStatus.TearDownCompleted) {
            return;
        }
        ServerPark sp = this.serverPark;
        KafkaEnvironment kafkaEnvironment = this;
        boolean bl = false;
        this.stop(sp.getSchemaRegStatus());
        this.stop(sp.getBrokerStatus());
        sp.getZookeeper().stop();
        kafkaEnvironment.serverPark = new ServerPark(sp.getZookeeper(), sp.getBrokerStatus(), sp.getSchemaRegStatus(), ServerParkStatus.Stopped.INSTANCE);
    }

    public final void tearDown() {
        if (this.serverPark.getStatus() instanceof ServerParkStatus.TearDownCompleted) {
            return;
        }
        if (this.serverPark.getStatus() instanceof ServerParkStatus.Started) {
            this.stop();
        }
        FunctionsKt.deleteDir(this.zookeeperDataBaseDir);
        FunctionsKt.deleteDir(this.kafkaBrokerDataBaseDir);
        this.serverPark = new ServerPark(this.serverPark.getZookeeper(), BrokerStatus.NotAvailable.INSTANCE, SchemaRegistryStatus.NotAvailable.INSTANCE, ServerParkStatus.TearDownCompleted.INSTANCE);
    }

    @Override
    public void close() {
        this.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createTopics(List<TopicInfo> topics) {
        int replFactor = this.getBrokers().size();
        AdminClient adminClient = this.getAdminClient();
        if (adminClient != null) {
            AutoCloseable autoCloseable = (AutoCloseable)adminClient;
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                AdminClient ac = (AdminClient)autoCloseable;
                boolean bl = false;
                Iterable iterable = topics;
                AdminClient adminClient2 = ac;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void topic;
                    TopicInfo topicInfo = (TopicInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new NewTopic(topic.getName(), topic.getPartitions(), (short)replFactor).configs(topic.getConfig()));
                }
                CreateTopicsResult createTopicsResult = adminClient2.createTopics((Collection)((List)destination$iv$iv));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        this.topicsCreated = true;
    }

    public KafkaEnvironment() {
        this(0, null, null, false, false, null, false, null, 255, null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lno/nav/common/KafkaEnvironment$BrokerStatus;", "", "()V", "Available", "NotAvailable", "Lno/nav/common/KafkaEnvironment$BrokerStatus$Available;", "Lno/nav/common/KafkaEnvironment$BrokerStatus$NotAvailable;", "kafka-embedded-env"})
    public static abstract class BrokerStatus {
        private BrokerStatus() {
        }

        public /* synthetic */ BrokerStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lno/nav/common/KafkaEnvironment$BrokerStatus$Available;", "Lno/nav/common/KafkaEnvironment$BrokerStatus;", "brokers", "", "Lno/nav/common/embeddedutils/ServerBase;", "brokersURL", "", "(Ljava/util/List;Ljava/lang/String;)V", "getBrokers", "()Ljava/util/List;", "getBrokersURL", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kafka-embedded-env"})
        public static final class Available
        extends BrokerStatus {
            @NotNull
            private final List<ServerBase> brokers;
            @NotNull
            private final String brokersURL;

            public Available(@NotNull List<? extends ServerBase> brokers, @NotNull String brokersURL) {
                Intrinsics.checkNotNullParameter(brokers, (String)"brokers");
                Intrinsics.checkNotNullParameter((Object)brokersURL, (String)"brokersURL");
                super(null);
                this.brokers = brokers;
                this.brokersURL = brokersURL;
            }

            @NotNull
            public final List<ServerBase> getBrokers() {
                return this.brokers;
            }

            @NotNull
            public final String getBrokersURL() {
                return this.brokersURL;
            }

            @NotNull
            public final List<ServerBase> component1() {
                return this.brokers;
            }

            @NotNull
            public final String component2() {
                return this.brokersURL;
            }

            @NotNull
            public final Available copy(@NotNull List<? extends ServerBase> brokers, @NotNull String brokersURL) {
                Intrinsics.checkNotNullParameter(brokers, (String)"brokers");
                Intrinsics.checkNotNullParameter((Object)brokersURL, (String)"brokersURL");
                return new Available(brokers, brokersURL);
            }

            public static /* synthetic */ Available copy$default(Available available, List list, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    list = available.brokers;
                }
                if ((n & 2) != 0) {
                    string = available.brokersURL;
                }
                return available.copy(list, string);
            }

            @NotNull
            public String toString() {
                return "Available(brokers=" + this.brokers + ", brokersURL=" + this.brokersURL + ")";
            }

            public int hashCode() {
                int result = ((Object)this.brokers).hashCode();
                result = result * 31 + this.brokersURL.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Available)) {
                    return false;
                }
                Available available = (Available)other;
                if (!Intrinsics.areEqual(this.brokers, available.brokers)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.brokersURL, (Object)available.brokersURL);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$BrokerStatus$NotAvailable;", "Lno/nav/common/KafkaEnvironment$BrokerStatus;", "()V", "kafka-embedded-env"})
        public static final class NotAvailable
        extends BrokerStatus {
            @NotNull
            public static final NotAvailable INSTANCE = new NotAvailable();

            private NotAvailable() {
                super(null);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "", "()V", "Available", "NotAvailable", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus$Available;", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus$NotAvailable;", "kafka-embedded-env"})
    public static abstract class SchemaRegistryStatus {
        private SchemaRegistryStatus() {
        }

        public /* synthetic */ SchemaRegistryStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus$Available;", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "schemaRegistry", "Lno/nav/common/embeddedutils/ServerBase;", "(Lno/nav/common/embeddedutils/ServerBase;)V", "getSchemaRegistry", "()Lno/nav/common/embeddedutils/ServerBase;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kafka-embedded-env"})
        public static final class Available
        extends SchemaRegistryStatus {
            @NotNull
            private final ServerBase schemaRegistry;

            public Available(@NotNull ServerBase schemaRegistry) {
                Intrinsics.checkNotNullParameter((Object)schemaRegistry, (String)"schemaRegistry");
                super(null);
                this.schemaRegistry = schemaRegistry;
            }

            @NotNull
            public final ServerBase getSchemaRegistry() {
                return this.schemaRegistry;
            }

            @NotNull
            public final ServerBase component1() {
                return this.schemaRegistry;
            }

            @NotNull
            public final Available copy(@NotNull ServerBase schemaRegistry) {
                Intrinsics.checkNotNullParameter((Object)schemaRegistry, (String)"schemaRegistry");
                return new Available(schemaRegistry);
            }

            public static /* synthetic */ Available copy$default(Available available, ServerBase serverBase, int n, Object object) {
                if ((n & 1) != 0) {
                    serverBase = available.schemaRegistry;
                }
                return available.copy(serverBase);
            }

            @NotNull
            public String toString() {
                return "Available(schemaRegistry=" + this.schemaRegistry + ")";
            }

            public int hashCode() {
                return this.schemaRegistry.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Available)) {
                    return false;
                }
                Available available = (Available)other;
                return Intrinsics.areEqual((Object)this.schemaRegistry, (Object)available.schemaRegistry);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus$NotAvailable;", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "()V", "kafka-embedded-env"})
        public static final class NotAvailable
        extends SchemaRegistryStatus {
            @NotNull
            public static final NotAvailable INSTANCE = new NotAvailable();

            private NotAvailable() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lno/nav/common/KafkaEnvironment$ServerPark;", "", "zookeeper", "Lno/nav/common/embeddedutils/ServerBase;", "brokerStatus", "Lno/nav/common/KafkaEnvironment$BrokerStatus;", "schemaRegStatus", "Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "status", "Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "(Lno/nav/common/embeddedutils/ServerBase;Lno/nav/common/KafkaEnvironment$BrokerStatus;Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;Lno/nav/common/KafkaEnvironment$ServerParkStatus;)V", "getBrokerStatus", "()Lno/nav/common/KafkaEnvironment$BrokerStatus;", "getSchemaRegStatus", "()Lno/nav/common/KafkaEnvironment$SchemaRegistryStatus;", "getStatus", "()Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "getZookeeper", "()Lno/nav/common/embeddedutils/ServerBase;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kafka-embedded-env"})
    public static final class ServerPark {
        @NotNull
        private final ServerBase zookeeper;
        @NotNull
        private final BrokerStatus brokerStatus;
        @NotNull
        private final SchemaRegistryStatus schemaRegStatus;
        @NotNull
        private final ServerParkStatus status;

        public ServerPark(@NotNull ServerBase zookeeper, @NotNull BrokerStatus brokerStatus, @NotNull SchemaRegistryStatus schemaRegStatus, @NotNull ServerParkStatus status) {
            Intrinsics.checkNotNullParameter((Object)zookeeper, (String)"zookeeper");
            Intrinsics.checkNotNullParameter((Object)brokerStatus, (String)"brokerStatus");
            Intrinsics.checkNotNullParameter((Object)schemaRegStatus, (String)"schemaRegStatus");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.zookeeper = zookeeper;
            this.brokerStatus = brokerStatus;
            this.schemaRegStatus = schemaRegStatus;
            this.status = status;
        }

        @NotNull
        public final ServerBase getZookeeper() {
            return this.zookeeper;
        }

        @NotNull
        public final BrokerStatus getBrokerStatus() {
            return this.brokerStatus;
        }

        @NotNull
        public final SchemaRegistryStatus getSchemaRegStatus() {
            return this.schemaRegStatus;
        }

        @NotNull
        public final ServerParkStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final ServerBase component1() {
            return this.zookeeper;
        }

        @NotNull
        public final BrokerStatus component2() {
            return this.brokerStatus;
        }

        @NotNull
        public final SchemaRegistryStatus component3() {
            return this.schemaRegStatus;
        }

        @NotNull
        public final ServerParkStatus component4() {
            return this.status;
        }

        @NotNull
        public final ServerPark copy(@NotNull ServerBase zookeeper, @NotNull BrokerStatus brokerStatus, @NotNull SchemaRegistryStatus schemaRegStatus, @NotNull ServerParkStatus status) {
            Intrinsics.checkNotNullParameter((Object)zookeeper, (String)"zookeeper");
            Intrinsics.checkNotNullParameter((Object)brokerStatus, (String)"brokerStatus");
            Intrinsics.checkNotNullParameter((Object)schemaRegStatus, (String)"schemaRegStatus");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new ServerPark(zookeeper, brokerStatus, schemaRegStatus, status);
        }

        public static /* synthetic */ ServerPark copy$default(ServerPark serverPark, ServerBase serverBase, BrokerStatus brokerStatus, SchemaRegistryStatus schemaRegistryStatus, ServerParkStatus serverParkStatus, int n, Object object) {
            if ((n & 1) != 0) {
                serverBase = serverPark.zookeeper;
            }
            if ((n & 2) != 0) {
                brokerStatus = serverPark.brokerStatus;
            }
            if ((n & 4) != 0) {
                schemaRegistryStatus = serverPark.schemaRegStatus;
            }
            if ((n & 8) != 0) {
                serverParkStatus = serverPark.status;
            }
            return serverPark.copy(serverBase, brokerStatus, schemaRegistryStatus, serverParkStatus);
        }

        @NotNull
        public String toString() {
            return "ServerPark(zookeeper=" + this.zookeeper + ", brokerStatus=" + this.brokerStatus + ", schemaRegStatus=" + this.schemaRegStatus + ", status=" + this.status + ")";
        }

        public int hashCode() {
            int result = this.zookeeper.hashCode();
            result = result * 31 + this.brokerStatus.hashCode();
            result = result * 31 + this.schemaRegStatus.hashCode();
            result = result * 31 + this.status.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerPark)) {
                return false;
            }
            ServerPark serverPark = (ServerPark)other;
            if (!Intrinsics.areEqual((Object)this.zookeeper, (Object)serverPark.zookeeper)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.brokerStatus, (Object)serverPark.brokerStatus)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemaRegStatus, (Object)serverPark.schemaRegStatus)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.status, (Object)serverPark.status);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "", "()V", "Initialized", "Started", "Stopped", "TearDownCompleted", "Lno/nav/common/KafkaEnvironment$ServerParkStatus$Initialized;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus$Started;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus$Stopped;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus$TearDownCompleted;", "kafka-embedded-env"})
    public static abstract class ServerParkStatus {
        private ServerParkStatus() {
        }

        public /* synthetic */ ServerParkStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$ServerParkStatus$Initialized;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "()V", "kafka-embedded-env"})
        public static final class Initialized
        extends ServerParkStatus {
            @NotNull
            public static final Initialized INSTANCE = new Initialized();

            private Initialized() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$ServerParkStatus$Started;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "()V", "kafka-embedded-env"})
        public static final class Started
        extends ServerParkStatus {
            @NotNull
            public static final Started INSTANCE = new Started();

            private Started() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$ServerParkStatus$Stopped;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "()V", "kafka-embedded-env"})
        public static final class Stopped
        extends ServerParkStatus {
            @NotNull
            public static final Stopped INSTANCE = new Stopped();

            private Stopped() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lno/nav/common/KafkaEnvironment$ServerParkStatus$TearDownCompleted;", "Lno/nav/common/KafkaEnvironment$ServerParkStatus;", "()V", "kafka-embedded-env"})
        public static final class TearDownCompleted
        extends ServerParkStatus {
            @NotNull
            public static final TearDownCompleted INSTANCE = new TearDownCompleted();

            private TearDownCompleted() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lno/nav/common/KafkaEnvironment$TopicInfo;", "", "name", "", "partitions", "", "config", "", "(Ljava/lang/String;ILjava/util/Map;)V", "getConfig", "()Ljava/util/Map;", "getName", "()Ljava/lang/String;", "getPartitions", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "kafka-embedded-env"})
    public static final class TopicInfo {
        @NotNull
        private final String name;
        private final int partitions;
        @Nullable
        private final Map<String, String> config;

        public TopicInfo(@NotNull String name, int partitions, @Nullable Map<String, String> config2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.partitions = partitions;
            this.config = config2;
        }

        public /* synthetic */ TopicInfo(String string, int n, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 2;
            }
            if ((n2 & 4) != 0) {
                map = null;
            }
            this(string, n, map);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getPartitions() {
            return this.partitions;
        }

        @Nullable
        public final Map<String, String> getConfig() {
            return this.config;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.partitions;
        }

        @Nullable
        public final Map<String, String> component3() {
            return this.config;
        }

        @NotNull
        public final TopicInfo copy(@NotNull String name, int partitions, @Nullable Map<String, String> config2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TopicInfo(name, partitions, config2);
        }

        public static /* synthetic */ TopicInfo copy$default(TopicInfo topicInfo, String string, int n, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = topicInfo.name;
            }
            if ((n2 & 2) != 0) {
                n = topicInfo.partitions;
            }
            if ((n2 & 4) != 0) {
                map = topicInfo.config;
            }
            return topicInfo.copy(string, n, map);
        }

        @NotNull
        public String toString() {
            return "TopicInfo(name=" + this.name + ", partitions=" + this.partitions + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.partitions);
            result = result * 31 + (this.config == null ? 0 : ((Object)this.config).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TopicInfo)) {
                return false;
            }
            TopicInfo topicInfo = (TopicInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)topicInfo.name)) {
                return false;
            }
            if (this.partitions != topicInfo.partitions) {
                return false;
            }
            return Intrinsics.areEqual(this.config, topicInfo.config);
        }
    }
}

