/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.embeddedkafka;

import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.common.JAASContextKt;
import no.nav.common.embeddedutils.ServerBase;
import no.nav.common.embeddedutils.ServerStatus;
import org.apache.kafka.common.utils.Time;
import org.jetbrains.annotations.NotNull;
import scala.Option;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ@\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lno/nav/common/embeddedkafka/KBServer;", "Lno/nav/common/embeddedutils/ServerBase;", "port", "", "id", "noPartitions", "dataDir", "Ljava/nio/file/Path;", "zkURL", "", "withSecurity", "", "configOverrides", "Ljava/util/Properties;", "(IIILjava/nio/file/Path;Ljava/lang/String;ZLjava/util/Properties;)V", "broker", "Lkafka/server/KafkaServer;", "kafkaProperties", "getPort", "()I", "url", "getUrl", "()Ljava/lang/String;", "getDefaultProps", "logDir", "logDirs", "stateDir", "start", "", "stop", "kafka-embedded-env"})
public final class KBServer
extends ServerBase {
    private final int port;
    @NotNull
    private final Properties configOverrides;
    @NotNull
    private final String url;
    @NotNull
    private final Properties kafkaProperties;
    @NotNull
    private final KafkaServer broker;

    public KBServer(int port, int id, int noPartitions, @NotNull Path dataDir, @NotNull String zkURL, boolean withSecurity, @NotNull Properties configOverrides) {
        Intrinsics.checkNotNullParameter((Object)dataDir, (String)"dataDir");
        Intrinsics.checkNotNullParameter((Object)zkURL, (String)"zkURL");
        Intrinsics.checkNotNullParameter((Object)configOverrides, (String)"configOverrides");
        this.port = port;
        this.configOverrides = configOverrides;
        this.url = withSecurity ? "SASL_PLAINTEXT://" + this.getHost() + ":" + this.getPort() : "PLAINTEXT://" + this.getHost() + ":" + this.getPort();
        Path path = dataDir.resolve("log");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = dataDir.resolve("logs");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = dataDir.resolve("streams");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        this.kafkaProperties = this.getDefaultProps(id, zkURL, noPartitions, path, path2, path3, withSecurity);
        this.broker = new KafkaServer(new KafkaConfig((Map)this.kafkaProperties), Time.SYSTEM, Option.apply((Object)""), false);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    public void start() {
        if (this.getStatus() instanceof ServerStatus.NotRunning) {
            this.broker.startup();
            this.setStatus(ServerStatus.Running.INSTANCE);
        }
    }

    @Override
    public void stop() {
        if (this.getStatus() instanceof ServerStatus.Running) {
            this.broker.shutdown();
            this.broker.awaitShutdown();
            this.setStatus(ServerStatus.NotRunning.INSTANCE);
        }
    }

    private final Properties getDefaultProps(int id, String zkURL, int noPartitions, Path logDir, Path logDirs, Path stateDir, boolean withSecurity) {
        Properties properties;
        Properties $this$getDefaultProps_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        if (withSecurity) {
            ((Map)$this$getDefaultProps_u24lambda_u240).put("security.inter.broker.protocol", "SASL_PLAINTEXT");
            ((Map)$this$getDefaultProps_u24lambda_u240).put("sasl.mechanism.inter.broker.protocol", "PLAIN");
            ((Map)$this$getDefaultProps_u24lambda_u240).put("sasl.enabled.mechanisms", "PLAIN");
            ((Map)$this$getDefaultProps_u24lambda_u240).put("authorizer.class.name", "kafka.security.authorizer.AclAuthorizer");
            ((Map)$this$getDefaultProps_u24lambda_u240).put("super.users", "User:" + JAASContextKt.getKafkaAdmin().getUsername() + ";User:" + JAASContextKt.getKafkaClient().getUsername());
            ((Map)$this$getDefaultProps_u24lambda_u240).put("zookeeper.set.acl", "true");
        }
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.AutoCreateTopicsEnableProp(), String.valueOf(!withSecurity));
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ZkConnectProp(), zkURL);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ZkConnectionTimeoutMsProp(), 10000);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ZkSessionTimeoutMsProp(), 30000);
        Integer n = id;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.BrokerIdProp(), n);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ListenersProp(), this.getUrl());
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.NumNetworkThreadsProp(), 3);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.NumIoThreadsProp(), 8);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.BackgroundThreadsProp(), 10);
        n = noPartitions;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.NumPartitionsProp(), n);
        n = noPartitions;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.DefaultReplicationFactorProp(), n);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.MinInSyncReplicasProp(), 1);
        n = noPartitions;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.OffsetsTopicPartitionsProp(), n);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.OffsetsTopicReplicationFactorProp(), (short)noPartitions);
        n = noPartitions;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.TransactionsTopicPartitionsProp(), n);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.TransactionsTopicReplicationFactorProp(), (short)noPartitions);
        n = noPartitions;
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.TransactionsTopicMinISRProp(), n);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.LeaderImbalanceCheckIntervalSecondsProp(), 10);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.LogDirProp(), ((Object)logDir.toAbsolutePath()).toString());
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.LogDirsProp(), ((Object)logDirs.toAbsolutePath()).toString());
        ((Map)$this$getDefaultProps_u24lambda_u240).put("state.dir", ((Object)stateDir.toAbsolutePath()).toString());
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.NumRecoveryThreadsPerDataDirProp(), 1);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ControlledShutdownMaxRetriesProp(), 1);
        ((Map)$this$getDefaultProps_u24lambda_u240).put(KafkaConfig.ControlledShutdownRetryBackoffMsProp(), 500);
        $this$getDefaultProps_u24lambda_u240.putAll((Map<?, ?>)this.configOverrides);
        return properties;
    }
}

