/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.embeddedschemaregistry;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryRestApplication;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.common.embeddedschemaregistry.SRServer;
import no.nav.common.embeddedutils.ServerBase;
import no.nav.common.embeddedutils.ServerStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lno/nav/common/embeddedschemaregistry/SRServer;", "Lno/nav/common/embeddedutils/ServerBase;", "port", "", "kbURL", "", "withSecurity", "", "(ILjava/lang/String;Z)V", "getPort", "()I", "sr", "", "Lno/nav/common/embeddedschemaregistry/SRServer$SRS;", "url", "getUrl", "()Ljava/lang/String;", "start", "", "stop", "SRS", "kafka-embedded-env"})
public final class SRServer
extends ServerBase {
    private final int port;
    @NotNull
    private final String kbURL;
    private final boolean withSecurity;
    @NotNull
    private final String url;
    @NotNull
    private final List<SRS> sr;

    public SRServer(int port, @NotNull String kbURL, boolean withSecurity) {
        Intrinsics.checkNotNullParameter((Object)kbURL, (String)"kbURL");
        this.port = port;
        this.kbURL = kbURL;
        this.withSecurity = withSecurity;
        this.url = "http://" + this.getHost() + ":" + this.getPort();
        this.sr = new ArrayList();
    }

    public /* synthetic */ SRServer(int n, String string, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, string, bl);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    public void start() {
        if (Intrinsics.areEqual((Object)this.getStatus(), (Object)ServerStatus.NotRunning.INSTANCE)) {
            SRS sRS;
            SRS $this$start_u24lambda_u240 = sRS = new SRS(this.getUrl(), this.kbURL, this.withSecurity);
            boolean bl = false;
            this.sr.add($this$start_u24lambda_u240);
            $this$start_u24lambda_u240.getScServer().start();
            this.setStatus(ServerStatus.Running.INSTANCE);
        }
    }

    @Override
    public void stop() {
        if (Intrinsics.areEqual((Object)this.getStatus(), (Object)ServerStatus.Running.INSTANCE)) {
            Object object = CollectionsKt.first(this.sr);
            SRS $this$stop_u24lambda_u241 = (SRS)object;
            boolean bl = false;
            $this$stop_u24lambda_u241.getScServer().stop();
            $this$stop_u24lambda_u241.getScServer().join();
            CollectionsKt.removeAll(this.sr, (Function1)stop.2.INSTANCE);
            this.setStatus(ServerStatus.NotRunning.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lno/nav/common/embeddedschemaregistry/SRServer$SRS;", "", "url", "", "kbURL", "withSecurity", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "scServer", "Lio/confluent/kafka/schemaregistry/rest/SchemaRegistryRestApplication;", "getScServer", "()Lio/confluent/kafka/schemaregistry/rest/SchemaRegistryRestApplication;", "kafka-embedded-env"})
    private static final class SRS {
        @NotNull
        private final SchemaRegistryRestApplication scServer;

        /*
         * WARNING - void declaration
         */
        public SRS(@NotNull String url, @NotNull String kbURL, boolean withSecurity) {
            void $this$scServer_u24lambda_u240;
            Properties properties;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)kbURL, (String)"kbURL");
            Properties properties2 = properties = new Properties();
            SRS sRS = this;
            boolean bl = false;
            if (withSecurity) {
                ((Map)$this$scServer_u24lambda_u240).put("kafkastore.security.protocol", "SASL_PLAINTEXT");
                ((Map)$this$scServer_u24lambda_u240).put("kafkastore.sasl.mechanism", "PLAIN");
            }
            ((Map)$this$scServer_u24lambda_u240).put("listeners", url);
            ((Map)$this$scServer_u24lambda_u240).put("kafkastore.bootstrap.servers", kbURL);
            ((Map)$this$scServer_u24lambda_u240).put("kafkastore.topic", "_schemas");
            Properties properties3 = properties;
            SchemaRegistryConfig schemaRegistryConfig = new SchemaRegistryConfig(properties3);
            sRS.scServer = new SchemaRegistryRestApplication(schemaRegistryConfig);
        }

        @NotNull
        public final SchemaRegistryRestApplication getScServer() {
            return this.scServer;
        }
    }
}

