/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.embeddedutils;

import java.net.ServerSocket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import no.nav.common.embeddedutils.FunctionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u0006\u0010\u000b\u001a\u00020\f\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"tmpDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "appDirFor", "appName", "", "dataDirFor", "path", "deleteDir", "", "dir", "getAvailablePort", "", "kafka-embedded-env"})
public final class FunctionsKt {
    private static final Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);

    public static final int getAvailablePort() {
        ServerSocket $this$getAvailablePort_u24lambda_u240 = new ServerSocket(0);
        boolean bl = false;
        $this$getAvailablePort_u24lambda_u240.setReuseAddress(true);
        $this$getAvailablePort_u24lambda_u240.close();
        return $this$getAvailablePort_u24lambda_u240.getLocalPort();
    }

    public static final void deleteDir(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(arg_0 -> FunctionsKt.deleteDir$lambda$1(deleteDir.1.INSTANCE, arg_0));
        }
    }

    @NotNull
    public static final Path appDirFor(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Path path = tmpDir.resolve(appName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public static final Path dataDirFor(@NotNull Path path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path $this$dataDirFor_u24lambda_u242 = path2 = path.resolve(UUID.randomUUID().toString());
        boolean bl = false;
        Files.createDirectories($this$dataDirFor_u24lambda_u242, new FileAttribute[0]);
        Path path3 = path2;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"apply(...)");
        return path3;
    }

    private static final void deleteDir$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

