/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.embeddedzookeeper;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import no.nav.common.embeddedutils.ServerBase;
import no.nav.common.embeddedutils.ServerStatus;
import no.nav.common.embeddedzookeeper.ZKServer;
import no.nav.common.embeddedzookeeper.ZookeeperCMDRSP;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lno/nav/common/embeddedzookeeper/ZKServer;", "Lno/nav/common/embeddedutils/ServerBase;", "port", "", "dataDir", "Ljava/nio/file/Path;", "withSecurity", "", "(ILjava/nio/file/Path;Z)V", "getPort", "()I", "url", "", "getUrl", "()Ljava/lang/String;", "zk", "", "Lno/nav/common/embeddedzookeeper/ZKServer$ZKS;", "send4LCommand", "cmd", "timeout", "start", "", "stop", "waitForZookeeperOk", "ZKS", "kafka-embedded-env"})
@SourceDebugExtension(value={"SMAP\nZKServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZKServer.kt\nno/nav/common/embeddedzookeeper/ZKServer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1247#2,2:148\n1#3:150\n*S KotlinDebug\n*F\n+ 1 ZKServer.kt\nno/nav/common/embeddedzookeeper/ZKServer\n*L\n73#1:148,2\n*E\n"})
public final class ZKServer
extends ServerBase {
    private final int port;
    @NotNull
    private final Path dataDir;
    private final boolean withSecurity;
    @NotNull
    private final String url;
    @NotNull
    private final List<ZKS> zk;

    public ZKServer(int port, @NotNull Path dataDir, boolean withSecurity) {
        Intrinsics.checkNotNullParameter((Object)dataDir, (String)"dataDir");
        this.port = port;
        this.dataDir = dataDir;
        this.withSecurity = withSecurity;
        this.url = this.getHost() + ":" + this.getPort();
        this.zk = new ArrayList();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    private final boolean waitForZookeeperOk() {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(1, 2000))), (Function1)((Function1)new Function1<Integer, String>(this){
                final /* synthetic */ ZKServer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(int it) {
                    Thread.sleep(50L);
                    return ZKServer.send4LCommand$default(this.this$0, ZookeeperCMDRSP.RUOK.getCmd(), 0, 2, null);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)ZookeeperCMDRSP.RUOK.getRsp())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void start() {
        if (Intrinsics.areEqual((Object)this.getStatus(), (Object)ServerStatus.NotRunning.INSTANCE)) {
            this.zk.add(new ZKS(this.getPort(), this.dataDir, this.withSecurity));
            this.waitForZookeeperOk();
            this.setStatus(ServerStatus.Running.INSTANCE);
        }
    }

    @Override
    public void stop() {
        if (Intrinsics.areEqual((Object)this.getStatus(), (Object)ServerStatus.Running.INSTANCE)) {
            Object object;
            Object $this$stop_u24lambda_u241;
            ZKS zks = (ZKS)((Object)CollectionsKt.first(this.zk));
            Object object2 = this;
            try {
                $this$stop_u24lambda_u241 = object2;
                boolean bl = false;
                zks.getZkThread().interrupt();
                $this$stop_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$stop_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$stop_u24lambda_u241;
            if (Result.isFailure-impl((Object)object2)) {
                // empty if block
            }
            object2 = this;
            try {
                ZKServer $this$stop_u24lambda_u242 = (ZKServer)object2;
                boolean bl = false;
                zks.getZkThread().join();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            if (Result.isFailure-impl((Object)object2)) {
                // empty if block
            }
            CollectionsKt.removeAll(this.zk, (Function1)stop.3.INSTANCE);
            this.setStatus(ServerStatus.NotRunning.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String send4LCommand(@NotNull String cmd, int timeout) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Closeable closeable = new Socket();
        Socket $this$send4LCommand_u24lambda_u243 = closeable;
        boolean bl = false;
        $this$send4LCommand_u24lambda_u243.setSoTimeout(timeout);
        closeable = closeable;
        Throwable throwable = null;
        try {
            String string2;
            Object $this$send4LCommand_u24lambda_u245_u24lambda_u244;
            Closeable socket = closeable;
            boolean bl2 = false;
            Object object = this;
            try {
                $this$send4LCommand_u24lambda_u245_u24lambda_u244 = object;
                boolean bl3 = false;
                ((Socket)socket).connect(new InetSocketAddress(((ServerBase)$this$send4LCommand_u24lambda_u245_u24lambda_u244).getHost(), ((ZKServer)$this$send4LCommand_u24lambda_u245_u24lambda_u244).getPort()), timeout);
                $this$send4LCommand_u24lambda_u245_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                $this$send4LCommand_u24lambda_u245_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object = $this$send4LCommand_u24lambda_u245_u24lambda_u244;
            if (Result.isFailure-impl((Object)object)) {
                // empty if block
            }
            if (!((Socket)socket).isConnected()) {
                string2 = "4LEXCEPTION";
            } else {
                Function0 sndCmd2 = (Function0)new Function0<Boolean>((Socket)socket, cmd){
                    final /* synthetic */ Socket $socket;
                    final /* synthetic */ String $cmd;
                    {
                        this.$socket = $socket;
                        this.$cmd = $cmd;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        boolean bl;
                        try {
                            OutputStream outputStream = this.$socket.getOutputStream();
                            String string = this.$cmd;
                            Socket socket = this.$socket;
                            OutputStream os = outputStream;
                            boolean bl2 = false;
                            byte[] byArray = string.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            os.write(byArray);
                            os.flush();
                            socket.shutdownOutput();
                            bl = true;
                        }
                        catch (Exception e) {
                            bl = false;
                        }
                        return bl;
                    }
                };
                Function0 rcvRsp2 = (Function0)new Function0<String>((Socket)socket){
                    final /* synthetic */ Socket $socket;
                    {
                        this.$socket = $socket;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke() {
                        Object object;
                        try {
                            void $this$fold$iv;
                            object = new BufferedReader(new InputStreamReader(this.$socket.getInputStream()));
                            Throwable throwable = null;
                            try {
                                Object br = (BufferedReader)object;
                                boolean bl = false;
                                br = TextStreamsKt.readLines((Reader)((Reader)br));
                            }
                            catch (Throwable br) {
                                throwable = br;
                                throw br;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            }
                            object = (Iterable)br;
                            String initial$iv = "";
                            boolean $i$f$fold = false;
                            Object accumulator$iv = initial$iv;
                            for (T element$iv : $this$fold$iv) {
                                void str;
                                String string = (String)element$iv;
                                String res = accumulator$iv;
                                boolean bl = false;
                                accumulator$iv = res + (String)str + "\n";
                            }
                            object = accumulator$iv;
                        }
                        catch (Exception e) {
                            object = "4LEXCEPTION";
                        }
                        return object;
                    }
                };
                string2 = ((Boolean)sndCmd2.invoke()).booleanValue() ? (String)rcvRsp2.invoke() : "4LEXCEPTION";
            }
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static /* synthetic */ String send4LCommand$default(ZKServer zKServer, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return zKServer.send4LCommand(string, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lno/nav/common/embeddedzookeeper/ZKServer$ZKS;", "Lorg/apache/zookeeper/server/ZooKeeperServerMain;", "port", "", "dataDir", "Ljava/nio/file/Path;", "withSecurity", "", "(ILjava/nio/file/Path;Z)V", "propFile", "", "propsBasic", "Ljava/util/Properties;", "zkThread", "Ljava/lang/Thread;", "getZkThread", "()Ljava/lang/Thread;", "start", "", "kafka-embedded-env"})
    private static final class ZKS
    extends ZooKeeperServerMain {
        @NotNull
        private final Properties propsBasic;
        @NotNull
        private final String propFile;
        @NotNull
        private final Thread zkThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ZKS(int port, @NotNull Path dataDir, boolean withSecurity) {
            Object $this$propsBasic_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)dataDir, (String)"dataDir");
            Object object = new Properties();
            Properties properties = object;
            ZKS zKS = this;
            boolean bl = false;
            ((Map)$this$propsBasic_u24lambda_u240).put("dataDir", ((Object)dataDir.toAbsolutePath()).toString());
            ((Map)$this$propsBasic_u24lambda_u240).put("clientPort", String.valueOf(port));
            ((Map)$this$propsBasic_u24lambda_u240).put("maxClientCnxns", "0");
            ((Map)$this$propsBasic_u24lambda_u240).put("4lw.commands.whitelist", "reqs,ruok");
            ((Map)$this$propsBasic_u24lambda_u240).put("admin.enableServer", "false");
            if (withSecurity) {
                ((Map)$this$propsBasic_u24lambda_u240).put("authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
                ((Map)$this$propsBasic_u24lambda_u240).put("requireClientAuthScheme", "sasl");
                ((Map)$this$propsBasic_u24lambda_u240).put("jaasLoginRenew", "3600000");
            }
            zKS.propsBasic = object;
            $this$propsBasic_u24lambda_u240 = object = dataDir + "/embeddedzk.properties";
            zKS = this;
            boolean bl2 = false;
            try {
                void fName;
                Files.createDirectories(dataDir, new FileAttribute[0]);
                Closeable closeable = Files.newOutputStream(dataDir.resolve((String)fName), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    OutputStream out = (OutputStream)closeable;
                    boolean bl3 = false;
                    this.propsBasic.store(out, "");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception exception) {
            }
            zKS.propFile = object;
            this.zkThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ZKS this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ZKS.access$start(this.this$0);
                }
            }), (int)31, null);
        }

        private final void start() {
            String[] stringArray = new String[]{this.propFile};
            this.initializeAndRun(stringArray);
            this.shutdown();
        }

        @NotNull
        public final Thread getZkThread() {
            return this.zkThread;
        }

        public static final /* synthetic */ void access$start(ZKS $this) {
            $this.start();
        }
    }
}

