/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import no.nav.security.mock.oauth2.MockOAuth2ServerKt;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.MockWebServerWrapper;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequestHandler;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouter;
import no.nav.security.mock.oauth2.http.OAuth2HttpRouterKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\bJ.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007JH\u0010&\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010'\u001a\u00020\u00172\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u00172\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u00162\b\b\u0002\u0010\u0018\u001a\u00020)H\u0007J\u001e\u0010&\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020!J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010-\u001a\u00020#J\u0016\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0012\u0010.\u001a\u00020#2\b\b\u0002\u00101\u001a\u000202H\u0007J\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0017J\u000e\u00108\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lno/nav/security/mock/oauth2/MockOAuth2Server;", "", "additionalRoutes", "", "Lno/nav/security/mock/oauth2/http/Route;", "([Lno/nav/security/mock/oauth2/http/Route;)V", "config", "Lno/nav/security/mock/oauth2/OAuth2Config;", "(Lno/nav/security/mock/oauth2/OAuth2Config;[Lno/nav/security/mock/oauth2/http/Route;)V", "getConfig", "()Lno/nav/security/mock/oauth2/OAuth2Config;", "defaultRequestHandler", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequestHandler;", "httpServer", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "router", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRouter;", "anyToken", "Lcom/nimbusds/jwt/SignedJWT;", "issuerUrl", "Lokhttp3/HttpUrl;", "claims", "", "", "expiry", "Ljava/time/Duration;", "authorizationEndpointUrl", "issuerId", "baseUrl", "endSessionEndpointUrl", "enqueueCallback", "", "oAuth2TokenCallback", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "enqueueResponse", "", "response", "Lokhttp3/mockwebserver/MockResponse;", "issueToken", "subject", "audience", "", "clientId", "tokenCallback", "jwksUrl", "shutdown", "start", "inetAddress", "Ljava/net/InetAddress;", "port", "", "takeRequest", "Lokhttp3/mockwebserver/RecordedRequest;", "tokenEndpointUrl", "url", "path", "wellKnownUrl", "mock-oauth2-server"})
public class MockOAuth2Server {
    private final OAuth2HttpServer httpServer;
    private final OAuth2HttpRequestHandler defaultRequestHandler;
    private final OAuth2HttpRouter router;
    @NotNull
    private final OAuth2Config config;

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByName(\"localhost\")");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockOAuth2Server mockOAuth2Server, int n, int n2, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockOAuth2Server.start(n);
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockOAuth2Server.start$default(this, 0, 1, null);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        MockOAuth2ServerKt.access$getLog$p().debug("attempt to start server on port=" + port);
        this.httpServer.start(inetAddress, port, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)this.router));
    }

    public final void shutdown() throws IOException {
        this.httpServer.stop();
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.httpServer.url(path);
    }

    @Deprecated(message="Use MockWebServer method/function instead", replaceWith=@ReplaceWith(imports={}, expression="MockWebServer.enqueue()"))
    public final void enqueueResponse(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        throw (Throwable)new UnsupportedOperationException("cannot enqueue MockResponse, please use the MockWebServer directly with QueueDispatcher");
    }

    public final boolean enqueueCallback(@NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        return this.defaultRequestHandler.enqueueTokenCallback(oAuth2TokenCallback);
    }

    @NotNull
    public final RecordedRequest takeRequest() {
        MockWebServerWrapper mockWebServerWrapper;
        OAuth2HttpServer oAuth2HttpServer = this.httpServer;
        if (!(oAuth2HttpServer instanceof MockWebServerWrapper)) {
            oAuth2HttpServer = null;
        }
        if ((mockWebServerWrapper = (MockWebServerWrapper)oAuth2HttpServer) == null || (mockWebServerWrapper = mockWebServerWrapper.getMockWebServer()) == null || (mockWebServerWrapper = mockWebServerWrapper.takeRequest()) == null) {
            throw (Throwable)new UnsupportedOperationException("can only takeRequest when httpServer is of type MockWebServer");
        }
        return mockWebServerWrapper;
    }

    @NotNull
    public final HttpUrl wellKnownUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toWellKnownUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl tokenEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toTokenEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl jwksUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toJwksUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl issuerUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return this.url(issuerId);
    }

    @NotNull
    public final HttpUrl authorizationEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toAuthorizationEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl endSessionEndpointUrl(@NotNull String issuerId) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        return HttpUrlExtensionsKt.toEndSessionEndpointUrl(this.url(issuerId));
    }

    @NotNull
    public final HttpUrl baseUrl() {
        return this.url("");
    }

    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String clientId, @NotNull OAuth2TokenCallback tokenCallback) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)tokenCallback, (String)"tokenCallback");
        HttpUrl uri = this.tokenEndpointUrl(issuerId);
        HttpUrl issuerUrl = this.issuerUrl(issuerId);
        TokenRequest tokenRequest = new TokenRequest(uri.uri(), (ClientAuthentication)new ClientSecretBasic(new ClientID(clientId), new Secret("secret")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("123"), URI.create("http://localhost")));
        return this.config.getTokenProvider().accessToken(tokenRequest, issuerUrl, tokenCallback, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims, long expiry) {
        List list;
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        MockOAuth2Server mockOAuth2Server = this;
        String string = issuerId;
        String string2 = "default";
        String string3 = issuerId;
        String string4 = subject;
        String string5 = audience;
        if (string5 != null) {
            void it;
            String string6 = string5;
            boolean bl = false;
            boolean bl2 = false;
            String string7 = string6;
            String string8 = string4;
            String string9 = string3;
            String string10 = string2;
            String string11 = string;
            MockOAuth2Server mockOAuth2Server2 = mockOAuth2Server;
            boolean bl3 = false;
            List list2 = CollectionsKt.listOf((Object)it);
            mockOAuth2Server = mockOAuth2Server2;
            string = string11;
            string2 = string10;
            string3 = string9;
            string4 = string8;
            list = list2;
        } else {
            list = null;
        }
        long l = expiry;
        Map<String, ? extends Object> map = claims;
        List list3 = list;
        String string12 = string4;
        String string13 = string3;
        return mockOAuth2Server.issueToken(string, string2, new DefaultOAuth2TokenCallback(string13, string12, list3, map, l));
    }

    public static /* synthetic */ SignedJWT issueToken$default(MockOAuth2Server mockOAuth2Server, String string, String string2, String string3, Map map, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: issueToken");
        }
        if ((n & 1) != 0) {
            string = "default";
        }
        if ((n & 2) != 0) {
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"UUID.randomUUID().toString()");
            string2 = string4;
        }
        if ((n & 4) != 0) {
            string3 = "default";
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            l = 3600L;
        }
        return mockOAuth2Server.issueToken(string, string2, string3, map, l);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience, @NotNull Map<String, ? extends Object> claims) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, claims, 0L, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject, @Nullable String audience) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, audience, null, 0L, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId, @NotNull String subject) {
        return MockOAuth2Server.issueToken$default(this, issuerId, subject, null, null, 0L, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken(@NotNull String issuerId) {
        return MockOAuth2Server.issueToken$default(this, issuerId, null, null, null, 0L, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT issueToken() {
        return MockOAuth2Server.issueToken$default(this, null, null, null, null, 0L, 31, null);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT anyToken(@NotNull HttpUrl issuerUrl, @NotNull Map<String, ? extends Object> claims, @NotNull Duration expiry) {
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        JWTClaimsSet jwtClaimsSet = MockOAuth2ServerKt.toJwtClaimsSet(claims);
        AuthorizationGrant mockGrant2 = new AuthorizationGrant(new GrantType("MockGrant")){

            @NotNull
            public Map<String, List<String>> toParameters() {
                boolean bl = false;
                return new LinkedHashMap<K, V>();
            }
        };
        return this.config.getTokenProvider().exchangeAccessToken(new TokenRequest(URI.create("http://mockgrant"), mockGrant2), issuerUrl, jwtClaimsSet, new DefaultOAuth2TokenCallback(null, null, jwtClaimsSet.getAudience(), null, expiry.toMillis(), 11, null));
    }

    public static /* synthetic */ SignedJWT anyToken$default(MockOAuth2Server mockOAuth2Server, HttpUrl httpUrl, Map map, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: anyToken");
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofHours(1)");
            duration = duration2;
        }
        return mockOAuth2Server.anyToken(httpUrl, map, duration);
    }

    @JvmOverloads
    @NotNull
    public final SignedJWT anyToken(@NotNull HttpUrl issuerUrl, @NotNull Map<String, ? extends Object> claims) {
        return MockOAuth2Server.anyToken$default(this, issuerUrl, claims, null, 4, null);
    }

    @NotNull
    public final OAuth2Config getConfig() {
        return this.config;
    }

    public MockOAuth2Server(@NotNull OAuth2Config config, Route ... additionalRoutes) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)additionalRoutes, (String)"additionalRoutes");
        this.config = config;
        this.httpServer = this.config.getHttpServer();
        this.defaultRequestHandler = new OAuth2HttpRequestHandler(this.config);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)additionalRoutes);
        spreadBuilder.add((Object)OAuth2HttpRouterKt.route$default("", null, (Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(this){
            final /* synthetic */ MockOAuth2Server this$0;

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MockOAuth2Server.access$getDefaultRequestHandler$p(this.this$0).handleRequest(it);
            }
            {
                this.this$0 = mockOAuth2Server;
                super(1);
            }
        }, 2, null));
        this.router = OAuth2HttpRouter.Companion.routes((Route[])spreadBuilder.toArray((Object[])new Route[spreadBuilder.size()]));
    }

    public /* synthetic */ MockOAuth2Server(OAuth2Config oAuth2Config, Route[] routeArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuth2Config = new OAuth2Config(false, null, null, null, 15, null);
        }
        this(oAuth2Config, routeArray);
    }

    public MockOAuth2Server(Route ... additionalRoutes) {
        Intrinsics.checkNotNullParameter((Object)additionalRoutes, (String)"additionalRoutes");
        this(new OAuth2Config(false, null, null, null, 15, null), Arrays.copyOf(additionalRoutes, additionalRoutes.length));
    }

    public static final /* synthetic */ OAuth2HttpRequestHandler access$getDefaultRequestHandler$p(MockOAuth2Server $this) {
        return $this.defaultRequestHandler;
    }
}

