/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import no.nav.security.mock.oauth2.http.NettyWrapper;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpServer;
import no.nav.security.mock.oauth2.http.OAuth2HttpServerKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J0\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\n2\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lno/nav/security/mock/oauth2/http/NettyWrapper;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpServer;", "()V", "address", "Ljava/net/InetSocketAddress;", "closeFuture", "Lio/netty/channel/ChannelFuture;", "masterGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "<set-?>", "", "port", "getPort", "()I", "setPort", "(I)V", "port$delegate", "Lkotlin/properties/ReadWriteProperty;", "workerGroup", "start", "inetAddress", "Ljava/net/InetAddress;", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "stop", "url", "Lokhttp3/HttpUrl;", "path", "", "RouterChannelHandler", "mock-oauth2-server"})
public final class NettyWrapper
implements OAuth2HttpServer {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final NioEventLoopGroup masterGroup = new NioEventLoopGroup();
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup();
    private ChannelFuture closeFuture;
    private InetSocketAddress address;
    private final ReadWriteProperty port$delegate = Delegates.INSTANCE.notNull();

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(NettyWrapper.class, "port", "getPort()I", 0))};
    }

    private final int getPort() {
        return ((Number)this.port$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setPort(int n) {
        this.port$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull InetAddress inetAddress, int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        NettyWrapper nettyWrapper = this;
        boolean bl = false;
        boolean bl2 = false;
        NettyWrapper $this$apply = nettyWrapper;
        boolean bl3 = false;
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)$this$apply.masterGroup, (EventLoopGroup)$this$apply.workerGroup).channelFactory((ChannelFactory)start.1.1.INSTANCE)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(requestHandler, inetAddress, port){
            final /* synthetic */ Function1 $requestHandler$inlined;
            final /* synthetic */ InetAddress $inetAddress$inlined;
            final /* synthetic */ int $port$inlined;
            {
                this.$requestHandler$inlined = function1;
                this.$inetAddress$inlined = inetAddress;
                this.$port$inlined = n;
            }

            public void initChannel(@NotNull SocketChannel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ch.pipeline().addLast("codec", (ChannelHandler)new HttpServerCodec());
                ch.pipeline().addLast("keepAlive", (ChannelHandler)new HttpServerKeepAliveHandler());
                ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
                ch.pipeline().addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
                ch.pipeline().addLast("routes", (ChannelHandler)new RouterChannelHandler((Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)this.$requestHandler$inlined));
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)1000)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        Channel channel = bootstrap.bind(inetAddress, port).sync().channel();
        SocketAddress socketAddress = channel.localAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        $this$apply.address = (InetSocketAddress)socketAddress;
        $this$apply.setPort(port);
        $this$apply.closeFuture = channel.closeFuture();
        KLogger kLogger = OAuth2HttpServerKt.access$getLog$p();
        StringBuilder stringBuilder = new StringBuilder().append("started server on address=");
        InetSocketAddress inetSocketAddress = $this$apply.address;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"address");
        }
        kLogger.debug(stringBuilder.append(inetSocketAddress).append(" and port=").append(port).toString());
        return nettyWrapper;
    }

    @Override
    @NotNull
    public NettyWrapper stop() {
        NettyWrapper nettyWrapper = this;
        boolean bl = false;
        boolean bl2 = false;
        NettyWrapper $this$apply = nettyWrapper;
        boolean bl3 = false;
        ChannelFuture channelFuture = $this$apply.closeFuture;
        if (channelFuture != null) {
            channelFuture.cancel(false);
        }
        $this$apply.workerGroup.shutdownGracefully();
        $this$apply.masterGroup.shutdownGracefully();
        return nettyWrapper;
    }

    @Override
    public int port() {
        int n;
        if (this.getPort() > 0) {
            n = this.getPort();
        } else {
            InetSocketAddress inetSocketAddress = this.address;
            if (inetSocketAddress == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"address");
            }
            n = inetSocketAddress.getPort();
        }
        return n;
    }

    @Override
    @NotNull
    public HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme("http");
        InetSocketAddress inetSocketAddress = this.address;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"address");
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address.address");
        String string = inetAddress.getCanonicalHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.address.canonicalHostName");
        HttpUrl httpUrl = builder.host(string).port(this.port()).build().resolve(path);
        Intrinsics.checkNotNull((Object)httpUrl);
        return httpUrl;
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpServer.DefaultImpls.start(this, requestHandler);
    }

    @Override
    @NotNull
    public OAuth2HttpServer start(int port, @NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
        Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
        return OAuth2HttpServer.DefaultImpls.start(this, port, requestHandler);
    }

    @Override
    public void close() {
        OAuth2HttpServer.DefaultImpls.close(this);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0018\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011*\u00020\u0006H\u0002J$\u0010\u0014\u001a\u00020\u0005*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0011*\u00020\u0002H\u0002J$\u0010\u001c\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lno/nav/security/mock/oauth2/http/NettyWrapper$RouterChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/FullHttpRequest;", "requestHandler", "Lkotlin/Function1;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "Lno/nav/security/mock/oauth2/http/RequestHandler;", "(Lkotlin/jvm/functions/Function1;)V", "getRequestHandler", "()Lkotlin/jvm/functions/Function1;", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "request", "asNettyResponse", "Lkotlin/Pair;", "Lio/netty/handler/codec/http/DefaultHttpResponse;", "Lio/netty/handler/stream/ChunkedStream;", "asOAuth2HttpRequest", "scheme", "", "address", "Ljava/net/InetSocketAddress;", "port", "", "hostAndPortFromHostHeader", "requestUrl", "Lokhttp3/HttpUrl;", "toOkHttpHeaders", "Lokhttp3/Headers;", "Lio/netty/handler/codec/http/HttpHeaders;", "mock-oauth2-server"})
    public static final class RouterChannelHandler
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        @NotNull
        private final Function1<OAuth2HttpRequest, OAuth2HttpResponse> requestHandler;

        /*
         * WARNING - void declaration
         */
        protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull FullHttpRequest request) {
            void response;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            if (socketAddress == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
            }
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            SocketAddress socketAddress2 = ctx.channel().localAddress();
            if (socketAddress2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
            }
            int port = ((InetSocketAddress)socketAddress2).getPort();
            String scheme = ctx.pipeline().get(SslHandler.class) == null ? "http" : "https";
            Pair<DefaultHttpResponse, ChunkedStream> pair = this.asNettyResponse((OAuth2HttpResponse)this.requestHandler.invoke((Object)this.asOAuth2HttpRequest(request, scheme, address, port)));
            DefaultHttpResponse defaultHttpResponse = (DefaultHttpResponse)pair.component1();
            ChunkedStream stream = (ChunkedStream)pair.component2();
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.write((Object)response);
            ctx.write((Object)stream);
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<DefaultHttpResponse, ChunkedStream> asNettyResponse(OAuth2HttpResponse $this$asNettyResponse) {
            ByteArrayInputStream byteArrayInputStream;
            boolean bl;
            Object object;
            Object object2 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus($this$asNettyResponse.getStatus(), ""));
            boolean bl2 = false;
            boolean bl3 = false;
            DefaultHttpResponse $this$apply = object2;
            boolean bl4 = false;
            Iterable $this$forEach$iv = (Iterable)$this$asNettyResponse.getHeaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void key;
                Pair $dstr$key$values = (Pair)element$iv;
                boolean bl5 = false;
                String string = (String)$dstr$key$values.component1();
                String values = (String)$dstr$key$values.component2();
                $this$apply.headers().set((String)key, (Object)values);
            }
            DefaultHttpResponse defaultHttpResponse = object2;
            String string = $this$asNettyResponse.getBody();
            if (string != null) {
                object2 = string;
                Charset charset = Charsets.UTF_8;
                bl3 = false;
                object = object2;
                bl = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object3).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            } else {
                object2 = "";
                Charset charset = Charsets.UTF_8;
                bl3 = false;
                object = object2;
                bl = false;
                byte[] byArray = ((String)object).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byteArrayInputStream = new ByteArrayInputStream(byArray);
            }
            return TuplesKt.to((Object)defaultHttpResponse, (Object)new ChunkedStream((InputStream)byteArrayInputStream));
        }

        private final OAuth2HttpRequest asOAuth2HttpRequest(FullHttpRequest $this$asOAuth2HttpRequest, String scheme, InetSocketAddress address, int port) {
            HttpHeaders httpHeaders = $this$asOAuth2HttpRequest.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"this.headers()");
            Headers headers = this.toOkHttpHeaders(httpHeaders);
            String string = $this$asOAuth2HttpRequest.method().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.method().name()");
            return new OAuth2HttpRequest(headers, string, this.requestUrl($this$asOAuth2HttpRequest, scheme, address, port), $this$asOAuth2HttpRequest.content().toString(CharsetUtil.UTF_8));
        }

        private final HttpUrl requestUrl(FullHttpRequest $this$requestUrl, String scheme, InetSocketAddress address, int port) {
            Object object;
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(scheme);
            Object object2 = this.hostAndPortFromHostHeader($this$requestUrl);
            if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
                object2 = address.getHostName();
            }
            Intrinsics.checkNotNullExpressionValue(object2, (String)"hostAndPortFromHostHeade\u2026first ?: address.hostName");
            HttpUrl httpUrl = builder.host(object2).port((object = this.hostAndPortFromHostHeader($this$requestUrl)) != null && (object = (Integer)object.getSecond()) != null ? (Integer)object : port).build();
            String string = $this$requestUrl.uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.uri()");
            HttpUrl httpUrl2 = httpUrl.resolve(string);
            Intrinsics.checkNotNull((Object)httpUrl2);
            return httpUrl2;
        }

        private final Pair<String, Integer> hostAndPortFromHostHeader(FullHttpRequest $this$hostAndPortFromHostHeader) {
            Pair pair;
            String string = $this$hostAndPortFromHostHeader.headers().get("Host");
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (StringsKt.toIntOrNull((String)StringsKt.substringAfter$default((String)it, (String)":", null, (int)2, null)) != null) {
                    String string3 = StringsKt.substringAfter$default((String)it, (String)":", null, (int)2, null);
                    boolean bl4 = false;
                    pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (String)":", null, (int)2, null), (Object)Integer.parseInt(string3));
                } else {
                    pair = null;
                }
            } else {
                pair = null;
            }
            return pair;
        }

        private final Headers toOkHttpHeaders(HttpHeaders $this$toOkHttpHeaders) {
            Headers.Builder headers = Headers.Companion.of(new String[0]).newBuilder();
            Iterable $this$forEach$iv = (Iterable)$this$toOkHttpHeaders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                String string = (String)k;
                Object v = it.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                headers.add(string, (String)v);
            }
            return headers.build();
        }

        @NotNull
        public final Function1<OAuth2HttpRequest, OAuth2HttpResponse> getRequestHandler() {
            return this.requestHandler;
        }

        public RouterChannelHandler(@NotNull Function1<? super OAuth2HttpRequest, OAuth2HttpResponse> requestHandler) {
            Intrinsics.checkNotNullParameter(requestHandler, (String)"requestHandler");
            this.requestHandler = requestHandler;
        }
    }
}

