/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import freemarker.template.Configuration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.templates.TemplateMapper;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0006\u0010\u0012\u001a\u00020\t\u001a\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u0019\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "templateMapper", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "getTemplateMapper", "()Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "authenticationSuccess", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "authenticationSuccessResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "html", "content", "", "json", "anyObject", "", "notFound", "oauth2Error", "error", "Lcom/nimbusds/oauth2/sdk/ErrorObject;", "redirect", "location", "headers", "Lokhttp3/Headers;", "mock-oauth2-server"})
public final class OAuth2HttpResponseKt {
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private static final TemplateMapper templateMapper = TemplateMapper.Companion.create((Function1<? super Configuration, Unit>)((Function1)templateMapper.1.INSTANCE));

    @NotNull
    public static final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @NotNull
    public static final TemplateMapper getTemplateMapper() {
        return templateMapper;
    }

    @NotNull
    public static final OAuth2HttpResponse json(@NotNull Object anyObject) {
        Intrinsics.checkNotNullParameter((Object)anyObject, (String)"anyObject");
        Object object = anyObject;
        return new OAuth2HttpResponse(Headers.Companion.of(new String[]{"Content-Type", "application/json;charset=UTF-8"}), 200, object instanceof String ? (String)anyObject : objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(anyObject));
    }

    @NotNull
    public static final OAuth2HttpResponse html(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new OAuth2HttpResponse(Headers.Companion.of(new String[]{"Content-Type", "text/html;charset=UTF-8"}), 200, content);
    }

    @NotNull
    public static final OAuth2HttpResponse redirect(@NotNull String location, @NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return new OAuth2HttpResponse(Headers.Companion.of(new String[]{"Location", location}).newBuilder().addAll(headers).build(), 302, null, 4, null);
    }

    public static /* synthetic */ OAuth2HttpResponse redirect$default(String string, Headers headers, int n, Object object) {
        if ((n & 2) != 0) {
            headers = Headers.Companion.of(new String[0]);
        }
        return OAuth2HttpResponseKt.redirect(string, headers);
    }

    @NotNull
    public static final OAuth2HttpResponse notFound() {
        return new OAuth2HttpResponse(null, 404, null, 5, null);
    }

    @NotNull
    public static final OAuth2HttpResponse authenticationSuccess(@NotNull AuthenticationSuccessResponse authenticationSuccessResponse) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkNotNullParameter((Object)authenticationSuccessResponse, (String)"authenticationSuccessResponse");
        ResponseMode responseMode = authenticationSuccessResponse.getResponseMode();
        if (Intrinsics.areEqual((Object)responseMode, (Object)ResponseMode.FORM_POST)) {
            String string = authenticationSuccessResponse.getRedirectionURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authenticationSuccessRes\u2026redirectionURI.toString()");
            AuthorizationCode authorizationCode = authenticationSuccessResponse.getAuthorizationCode();
            Intrinsics.checkNotNullExpressionValue((Object)authorizationCode, (String)"authenticationSuccessResponse.authorizationCode");
            String string2 = authorizationCode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authenticationSuccessRes\u2026e.authorizationCode.value");
            State state = authenticationSuccessResponse.getState();
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"authenticationSuccessResponse.state");
            String string3 = state.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"authenticationSuccessResponse.state.value");
            oAuth2HttpResponse = new OAuth2HttpResponse(null, 200, templateMapper.authorizationCodeResponseHtml(string, string2, string3), 1, null);
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = "Location";
            String string = authenticationSuccessResponse.toURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authenticationSuccessResponse.toURI().toString()");
            stringArray[1] = string;
            oAuth2HttpResponse = new OAuth2HttpResponse(Headers.Companion.of(stringArray), 302, null, 4, null);
        }
        return oAuth2HttpResponse;
    }

    @NotNull
    public static final OAuth2HttpResponse oauth2Error(@NotNull ErrorObject error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Object object = error.getHTTPStatusCode();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)object).intValue();
        boolean bl3 = false;
        Object object2 = !(it == 302) ? object : null;
        int responseCode = object2 != null ? (Integer)object2 : 400;
        Headers headers = Headers.Companion.of(new String[]{"Content-Type", "application/json;charset=UTF-8"});
        String string = objectMapper.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)error.toJSONObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper\n           \u2026ing(error.toJSONObject())");
        object = string;
        bl = false;
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object3).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return new OAuth2HttpResponse(headers, responseCode, string2);
    }
}

