/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.templates;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.StringWriter;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.templates.HtmlContent;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "", "config", "Lfreemarker/template/Configuration;", "(Lfreemarker/template/Configuration;)V", "asString", "", "htmlContent", "Lno/nav/security/mock/oauth2/templates/HtmlContent;", "authorizationCodeResponseHtml", "redirectUri", "code", "state", "debuggerCallbackHtml", "tokenRequest", "tokenResponse", "debuggerFormHtml", "oAuth2HttpRequest", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "clientAuthMethod", "loginHtml", "Companion", "mock-oauth2-server"})
public final class TemplateMapper {
    private final Configuration config;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String loginHtml(@NotNull OAuth2HttpRequest oAuth2HttpRequest) {
        Intrinsics.checkNotNullParameter((Object)oAuth2HttpRequest, (String)"oAuth2HttpRequest");
        return this.asString(new HtmlContent("login.ftl", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"request_url", (Object)oAuth2HttpRequest.getUrl().newBuilder().query(null).build().toString()), TuplesKt.to((Object)"query", new OAuth2HttpRequest.Parameters(oAuth2HttpRequest.getUrl().query()).getMap())})));
    }

    @NotNull
    public final String debuggerCallbackHtml(@NotNull String tokenRequest, @NotNull String tokenResponse) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        return this.asString(new HtmlContent("debugger_callback.ftl", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"token_request", (Object)tokenRequest), TuplesKt.to((Object)"token_response", (Object)tokenResponse)})));
    }

    @NotNull
    public final String debuggerFormHtml(@NotNull OAuth2HttpRequest oAuth2HttpRequest, @NotNull String clientAuthMethod) {
        Intrinsics.checkNotNullParameter((Object)oAuth2HttpRequest, (String)"oAuth2HttpRequest");
        Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
        HttpUrl.Builder urlWithoutQuery = oAuth2HttpRequest.getUrl().newBuilder().query(null);
        return this.asString(new HtmlContent("debugger.ftl", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"url", (Object)urlWithoutQuery), TuplesKt.to((Object)"token_url", (Object)HttpUrlExtensionsKt.toTokenEndpointUrl(oAuth2HttpRequest.getUrl())), TuplesKt.to((Object)"query", new OAuth2HttpRequest.Parameters(oAuth2HttpRequest.getUrl().query()).getMap()), TuplesKt.to((Object)"client_auth_method", (Object)clientAuthMethod)})));
    }

    @NotNull
    public final String authorizationCodeResponseHtml(@NotNull String redirectUri, @NotNull String code, @NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.asString(new HtmlContent("authorization_code_response.ftl", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"redirect_uri", (Object)redirectUri), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"state", (Object)state)})));
    }

    private final String asString(HtmlContent htmlContent) {
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        boolean bl2 = false;
        StringWriter $this$apply = stringWriter;
        boolean bl3 = false;
        this.config.getTemplate(htmlContent.getTemplate()).process(htmlContent.getModel(), (Writer)$this$apply);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter().apply {\n \u2026his)\n        }.toString()");
        return string;
    }

    public TemplateMapper(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/templates/TemplateMapper$Companion;", "", "()V", "create", "Lno/nav/security/mock/oauth2/templates/TemplateMapper;", "configure", "Lkotlin/Function1;", "Lfreemarker/template/Configuration;", "", "Lkotlin/ExtensionFunctionType;", "mock-oauth2-server"})
    public static final class Companion {
        @NotNull
        public final TemplateMapper create(@NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            boolean bl = false;
            boolean bl2 = false;
            Configuration $this$apply = configuration;
            boolean bl3 = false;
            $this$apply.setTemplateLoader((TemplateLoader)new ClassTemplateLoader($this$apply.getClass().getClassLoader(), "templates"));
            bl = false;
            bl2 = false;
            configure.invoke((Object)configuration);
            Configuration config = configuration;
            return new TemplateMapper(config);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

