/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.userinfo;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponseKt;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import no.nav.security.mock.oauth2.userinfo.UserInfoKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"log", "Lmu/KLogger;", "invalidToken", "Lno/nav/security/mock/oauth2/OAuth2Exception;", "msg", "", "bearerToken", "Lokhttp3/Headers;", "userInfo", "Lno/nav/security/mock/oauth2/http/Route$Builder;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "verifyBearerToken", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "mock-oauth2-server"})
public final class UserInfoKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    @NotNull
    public static final Route.Builder userInfo(@NotNull Route.Builder $this$userInfo, @NotNull OAuth2TokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$userInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        String[] stringArray = new String[]{"/userinfo"};
        return $this$userInfo.get(stringArray, (Function1<? super OAuth2HttpRequest, OAuth2HttpResponse>)((Function1)new Function1<OAuth2HttpRequest, OAuth2HttpResponse>(tokenProvider){
            final /* synthetic */ OAuth2TokenProvider $tokenProvider;
            {
                this.$tokenProvider = $tokenProvider;
                super(1);
            }

            @NotNull
            public final OAuth2HttpResponse invoke(@NotNull OAuth2HttpRequest it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                UserInfoKt.access$getLog$p().debug("received request to userinfo endpoint, returning claims from token");
                Map claims = UserInfoKt.access$verifyBearerToken(it, this.$tokenProvider).getClaims();
                Intrinsics.checkNotNullExpressionValue((Object)claims, (String)"claims");
                return OAuth2HttpResponseKt.json(claims);
            }
        }));
    }

    private static final JWTClaimsSet verifyBearerToken(OAuth2HttpRequest $this$verifyBearerToken, OAuth2TokenProvider tokenProvider) {
        SignedJWT signedJWT;
        String tokenString = UserInfoKt.bearerToken($this$verifyBearerToken.getHeaders());
        HttpUrl issuer = HttpUrlExtensionsKt.toIssuerUrl($this$verifyBearerToken.getUrl());
        JWKSet jwkSet = tokenProvider.publicJwkSet(HttpUrlExtensionsKt.issuerId(issuer));
        try {
            signedJWT = SignedJWT.parse((String)tokenString);
            Intrinsics.checkNotNullExpressionValue((Object)signedJWT, (String)"parse(tokenString)");
            signedJWT = NimbusExtensionsKt.verifySignatureAndIssuer$default(signedJWT, new Issuer(issuer.toString()), jwkSet, null, 4, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "could not verify bearer token";
            }
            throw UserInfoKt.invalidToken(string);
        }
        return signedJWT;
    }

    private static final String bearerToken(Headers $this$bearerToken) {
        String string;
        String string2;
        String string3 = $this$bearerToken.get("Authorization");
        if (string3 == null) {
            string2 = null;
        } else {
            Object object = new String[]{"Bearer "};
            List list = StringsKt.split$default((CharSequence)string3, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list == null) {
                string2 = null;
            } else {
                List list2;
                List it = list2 = list;
                boolean bl = false;
                object = it.size() == 2 ? list2 : null;
                string2 = string = object == null ? null : (String)CollectionsKt.last((List)object);
            }
        }
        if (string == null) {
            throw UserInfoKt.invalidToken("missing bearer token");
        }
        return string;
    }

    private static final OAuth2Exception invalidToken(String msg) {
        return new OAuth2Exception(new ErrorObject("invalid_token", msg, 401), msg);
    }

    public static final /* synthetic */ KLogger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ JWTClaimsSet access$verifyBearerToken(OAuth2HttpRequest $receiver, OAuth2TokenProvider tokenProvider) {
        return UserInfoKt.verifyBearerToken($receiver, tokenProvider);
    }
}

