/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.extensions;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.HttpUrlExtensionsKt;
import no.nav.security.mock.oauth2.extensions.OAuth2Endpoints;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a!\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\f\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\r\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u0010\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\u0011\u001a\u00020\b*\u00020\u0006\u001a\u0016\u0010\u0012\u001a\u00020\u0006*\u00020\u00062\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0006\u001a#\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0019\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001a\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001b\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001c\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001d\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001e\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010 \u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010!\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\"\u001a\u00020\u0006*\u00020\u0006\u001a\f\u0010#\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006$"}, d2={"joinPaths", "", "path", "", "([Ljava/lang/String;)Ljava/lang/String;", "baseUrl", "Lokhttp3/HttpUrl;", "endsWith", "", "isAuthorizationEndpointUrl", "isDebuggerCallbackUrl", "isDebuggerUrl", "isEndSessionEndpointUrl", "isIntrospectUrl", "isJwksUrl", "isTokenEndpointUrl", "isUserInfoUrl", "isWellKnownUrl", "issuer", "issuerId", "removeAllEncodedQueryParams", "Lokhttp3/HttpUrl$Builder;", "params", "(Lokhttp3/HttpUrl$Builder;[Ljava/lang/String;)Lokhttp3/HttpUrl$Builder;", "toAuthorizationEndpointUrl", "toDebuggerCallbackUrl", "toDebuggerUrl", "toEndSessionEndpointUrl", "toIntrospectUrl", "toIssuerUrl", "toJwksUrl", "toOAuth2AuthorizationServerMetadataUrl", "toTokenEndpointUrl", "toUserInfoUrl", "toWellKnownUrl", "trimPath", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nHttpUrlExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUrlExtensions.kt\nno/nav/security/mock/oauth2/extensions/HttpUrlExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n1855#2,2:98\n1#3:100\n13579#4,2:101\n3792#4:103\n4307#4,2:104\n*S KotlinDebug\n*F\n+ 1 HttpUrlExtensions.kt\nno/nav/security/mock/oauth2/extensions/HttpUrlExtensionsKt\n*L\n67#1:98,2\n76#1:101,2\n89#1:103\n89#1:104,2\n*E\n"})
public final class HttpUrlExtensionsKt {
    public static final boolean isWellKnownUrl(@NotNull HttpUrl $this$isWellKnownUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWellKnownUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isWellKnownUrl, "/.well-known/oauth-authorization-server") || HttpUrlExtensionsKt.endsWith($this$isWellKnownUrl, "/.well-known/openid-configuration");
    }

    public static final boolean isAuthorizationEndpointUrl(@NotNull HttpUrl $this$isAuthorizationEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isAuthorizationEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isAuthorizationEndpointUrl, "/authorize");
    }

    public static final boolean isTokenEndpointUrl(@NotNull HttpUrl $this$isTokenEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isTokenEndpointUrl, "/token");
    }

    public static final boolean isEndSessionEndpointUrl(@NotNull HttpUrl $this$isEndSessionEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isEndSessionEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isEndSessionEndpointUrl, "/endsession");
    }

    public static final boolean isJwksUrl(@NotNull HttpUrl $this$isJwksUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isJwksUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isJwksUrl, "/jwks");
    }

    public static final boolean isUserInfoUrl(@NotNull HttpUrl $this$isUserInfoUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isUserInfoUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isUserInfoUrl, "/userinfo");
    }

    public static final boolean isIntrospectUrl(@NotNull HttpUrl $this$isIntrospectUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntrospectUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isIntrospectUrl, "/introspect");
    }

    public static final boolean isDebuggerUrl(@NotNull HttpUrl $this$isDebuggerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggerUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isDebuggerUrl, "/debugger");
    }

    public static final boolean isDebuggerCallbackUrl(@NotNull HttpUrl $this$isDebuggerCallbackUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebuggerCallbackUrl, (String)"<this>");
        return HttpUrlExtensionsKt.endsWith($this$isDebuggerCallbackUrl, "/debugger/callback");
    }

    @NotNull
    public static final HttpUrl toOAuth2AuthorizationServerMetadataUrl(@NotNull HttpUrl $this$toOAuth2AuthorizationServerMetadataUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toOAuth2AuthorizationServerMetadataUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toOAuth2AuthorizationServerMetadataUrl, "/.well-known/oauth-authorization-server");
    }

    @NotNull
    public static final HttpUrl toWellKnownUrl(@NotNull HttpUrl $this$toWellKnownUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toWellKnownUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toWellKnownUrl, "/.well-known/openid-configuration");
    }

    @NotNull
    public static final HttpUrl toAuthorizationEndpointUrl(@NotNull HttpUrl $this$toAuthorizationEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toAuthorizationEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toAuthorizationEndpointUrl, "/authorize");
    }

    @NotNull
    public static final HttpUrl toEndSessionEndpointUrl(@NotNull HttpUrl $this$toEndSessionEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toEndSessionEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toEndSessionEndpointUrl, "/endsession");
    }

    @NotNull
    public static final HttpUrl toTokenEndpointUrl(@NotNull HttpUrl $this$toTokenEndpointUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toTokenEndpointUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toTokenEndpointUrl, "/token");
    }

    @NotNull
    public static final HttpUrl toJwksUrl(@NotNull HttpUrl $this$toJwksUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toJwksUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toJwksUrl, "/jwks");
    }

    @NotNull
    public static final HttpUrl toIssuerUrl(@NotNull HttpUrl $this$toIssuerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toIssuerUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer$default($this$toIssuerUrl, null, 1, null);
    }

    @NotNull
    public static final HttpUrl toUserInfoUrl(@NotNull HttpUrl $this$toUserInfoUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toUserInfoUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toUserInfoUrl, "/userinfo");
    }

    @NotNull
    public static final HttpUrl toIntrospectUrl(@NotNull HttpUrl $this$toIntrospectUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntrospectUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toIntrospectUrl, "/introspect");
    }

    @NotNull
    public static final HttpUrl toDebuggerUrl(@NotNull HttpUrl $this$toDebuggerUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toDebuggerUrl, "/debugger");
    }

    @NotNull
    public static final HttpUrl toDebuggerCallbackUrl(@NotNull HttpUrl $this$toDebuggerCallbackUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebuggerCallbackUrl, (String)"<this>");
        return HttpUrlExtensionsKt.issuer($this$toDebuggerCallbackUrl, "/debugger/callback");
    }

    @NotNull
    public static final String issuerId(@NotNull HttpUrl $this$issuerId) {
        Intrinsics.checkNotNullParameter((Object)$this$issuerId, (String)"<this>");
        String path = HttpUrlExtensionsKt.trimPath(CollectionsKt.joinToString$default((Iterable)$this$issuerId.pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        Iterable $this$forEach$iv = OAuth2Endpoints.INSTANCE.getAll();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
            return StringsKt.substringBefore$default((String)path, (String)it, null, (int)2, null);
        }
        return path;
    }

    @NotNull
    public static final HttpUrl.Builder removeAllEncodedQueryParams(@NotNull HttpUrl.Builder $this$removeAllEncodedQueryParams, String ... params) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$removeAllEncodedQueryParams, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        HttpUrl.Builder $this$removeAllEncodedQueryParams_u24lambda_u242 = builder = $this$removeAllEncodedQueryParams;
        boolean bl = false;
        String[] $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            $this$removeAllEncodedQueryParams_u24lambda_u242.removeAllEncodedQueryParameters(it);
        }
        return builder;
    }

    public static final boolean endsWith(@NotNull HttpUrl $this$endsWith, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$endsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.endsWith$default((String)CollectionsKt.joinToString$default((Iterable)$this$endsWith.pathSegments(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), (String)HttpUrlExtensionsKt.trimPath(path), (boolean)false, (int)2, null);
    }

    private static final String trimPath(String $this$trimPath) {
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$this$trimPath, (CharSequence)"/"), (CharSequence)"/");
    }

    private static final HttpUrl issuer(HttpUrl $this$issuer, String path) {
        HttpUrl it = HttpUrlExtensionsKt.baseUrl($this$issuer);
        boolean bl = false;
        String[] stringArray = new String[]{HttpUrlExtensionsKt.issuerId($this$issuer), path};
        HttpUrl httpUrl = it.resolve(HttpUrlExtensionsKt.joinPaths(stringArray));
        if (httpUrl == null) {
            throw new OAuth2Exception(OAuth2Error.INVALID_REQUEST, "cannot resolve path " + path);
        }
        return httpUrl;
    }

    static /* synthetic */ HttpUrl issuer$default(HttpUrl httpUrl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return HttpUrlExtensionsKt.issuer(httpUrl, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final String joinPaths(String ... path) {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = path;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, (Function1)joinPaths.2.INSTANCE, (int)30, null);
    }

    private static final HttpUrl baseUrl(HttpUrl $this$baseUrl) {
        return new HttpUrl.Builder().scheme($this$baseUrl.scheme()).host($this$baseUrl.host()).port($this$baseUrl.port()).build();
    }

    public static final /* synthetic */ String access$trimPath(String $receiver) {
        return HttpUrlExtensionsKt.trimPath($receiver);
    }
}

