/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.http;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.mock.oauth2.http.CorsInterceptorKt;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2HttpResponse;
import no.nav.security.mock.oauth2.http.ResponseInterceptor;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lno/nav/security/mock/oauth2/http/CorsInterceptor;", "Lno/nav/security/mock/oauth2/http/ResponseInterceptor;", "allowedMethods", "", "", "(Ljava/util/List;)V", "intercept", "Lno/nav/security/mock/oauth2/http/OAuth2HttpResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "response", "HeaderNames", "mock-oauth2-server"})
public final class CorsInterceptor
implements ResponseInterceptor {
    @NotNull
    public static final HeaderNames HeaderNames = new HeaderNames(null);
    @NotNull
    private final List<String> allowedMethods;
    @NotNull
    public static final String ORIGIN = "origin";
    @NotNull
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "access-control-allow-credentials";
    @NotNull
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "access-control-request-headers";
    @NotNull
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "access-control-allow-headers";
    @NotNull
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "access-control-allow-methods";
    @NotNull
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "access-control-allow-origin";

    public CorsInterceptor(@NotNull List<String> allowedMethods) {
        Intrinsics.checkNotNullParameter(allowedMethods, (String)"allowedMethods");
        this.allowedMethods = allowedMethods;
    }

    public /* synthetic */ CorsInterceptor(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object[] objectArray = new String[]{"POST", "GET", "OPTIONS"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this(list);
    }

    @Override
    @NotNull
    public OAuth2HttpResponse intercept(@NotNull OAuth2HttpRequest request, @NotNull OAuth2HttpResponse response) {
        OAuth2HttpResponse oAuth2HttpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String origin = request.getHeaders().get(ORIGIN);
        CorsInterceptorKt.access$getLog$p().debug("intercept response if request origin header is set: " + origin);
        if (origin != null) {
            Headers.Builder headers = response.getHeaders().newBuilder();
            if (Intrinsics.areEqual((Object)request.getMethod(), (Object)"OPTIONS")) {
                String reqHeader = request.getHeaders().get(ACCESS_CONTROL_REQUEST_HEADERS);
                if (reqHeader != null) {
                    headers.set(ACCESS_CONTROL_ALLOW_HEADERS, reqHeader);
                }
                headers.set(ACCESS_CONTROL_ALLOW_METHODS, CollectionsKt.joinToString$default((Iterable)this.allowedMethods, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            headers.set(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            headers.set(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            CorsInterceptorKt.access$getLog$p().debug("adding CORS response headers");
            oAuth2HttpResponse = OAuth2HttpResponse.copy$default(response, headers.build(), 0, null, 6, null);
        } else {
            oAuth2HttpResponse = response;
        }
        return oAuth2HttpResponse;
    }

    public CorsInterceptor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lno/nav/security/mock/oauth2/http/CorsInterceptor$HeaderNames;", "", "()V", "ACCESS_CONTROL_ALLOW_CREDENTIALS", "", "ACCESS_CONTROL_ALLOW_HEADERS", "ACCESS_CONTROL_ALLOW_METHODS", "ACCESS_CONTROL_ALLOW_ORIGIN", "ACCESS_CONTROL_REQUEST_HEADERS", "ORIGIN", "mock-oauth2-server"})
    public static final class HeaderNames {
        private HeaderNames() {
        }

        public /* synthetic */ HeaderNames(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

