/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.RequestMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J-\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J$\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010%\u001a\u0004\u0018\u0001H&\"\u0006\b\u0000\u0010&\u0018\u0001*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010(J&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010*\u001a\n +*\u0004\u0018\u00010\u00030\u0003*\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lno/nav/security/mock/oauth2/token/RequestMappingTokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "issuerId", "", "requestMappings", "", "Lno/nav/security/mock/oauth2/token/RequestMapping;", "tokenExpiry", "", "(Ljava/lang/String;Ljava/util/List;J)V", "getIssuerId", "()Ljava/lang/String;", "getRequestMappings", "()Ljava/util/List;", "getTokenExpiry", "()J", "addClaims", "", "", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "audience", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "replaceVariables", "input", "replacements", "subject", "toString", "typeHeader", "getClaimOrNull", "T", "key", "(Ljava/util/List;Lcom/nimbusds/oauth2/sdk/TokenRequest;Ljava/lang/String;)Ljava/lang/Object;", "getClaims", "getTypeHeader", "kotlin.jvm.PlatformType", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2TokenCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMappingTokenCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n120#1:149\n120#1:150\n288#2,2:151\n1238#2,4:155\n1238#2,2:161\n1549#2:163\n1620#2,3:164\n1241#2:167\n288#2,2:168\n453#3:153\n403#3:154\n453#3:159\n403#3:160\n*S KotlinDebug\n*F\n+ 1 OAuth2TokenCallback.kt\nno/nav/security/mock/oauth2/token/RequestMappingTokenCallback\n*L\n82#1:149\n86#1:150\n93#1:151,2\n94#1:155,4\n101#1:161,2\n105#1:163\n105#1:164,3\n101#1:167\n122#1:168,2\n94#1:153\n94#1:154\n101#1:159\n101#1:160\n*E\n"})
public final class RequestMappingTokenCallback
implements OAuth2TokenCallback {
    @NotNull
    private final String issuerId;
    @NotNull
    private final List<RequestMapping> requestMappings;
    private final long tokenExpiry;

    public RequestMappingTokenCallback(@NotNull String issuerId, @NotNull List<RequestMapping> requestMappings, long tokenExpiry) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter(requestMappings, (String)"requestMappings");
        this.issuerId = issuerId;
        this.requestMappings = requestMappings;
        this.tokenExpiry = tokenExpiry;
    }

    public /* synthetic */ RequestMappingTokenCallback(String string, List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = Duration.ofHours(1L).toSeconds();
        }
        this(string, list, l);
    }

    @NotNull
    public final String getIssuerId() {
        return this.issuerId;
    }

    @NotNull
    public final List<RequestMapping> getRequestMappings() {
        return this.requestMappings;
    }

    public final long getTokenExpiry() {
        return this.tokenExpiry;
    }

    @Override
    @NotNull
    public String issuerId() {
        return this.issuerId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String subject(@NotNull TokenRequest tokenRequest) {
        void $this$getClaimOrNull$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        RequestMappingTokenCallback requestMappingTokenCallback = this;
        List<RequestMapping> list = this.requestMappings;
        String key$iv = "sub";
        boolean $i$f$getClaimOrNull = false;
        Object object = super.getClaims((List<RequestMapping>)$this$getClaimOrNull$iv, tokenRequest).get(key$iv);
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    @Override
    @NotNull
    public String typeHeader(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        String string = this.getTypeHeader(this.requestMappings, tokenRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeHeader(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> audience(@NotNull TokenRequest tokenRequest) {
        List list;
        void $this$getClaimOrNull$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        RequestMappingTokenCallback requestMappingTokenCallback = this;
        List<RequestMapping> list2 = this.requestMappings;
        String key$iv = "aud";
        boolean $i$f$getClaimOrNull = false;
        Object object = super.getClaims((List<RequestMapping>)$this$getClaimOrNull$iv, tokenRequest).get(key$iv);
        if (!(object instanceof List)) {
            object = null;
        }
        if ((list = (List)object) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        return this.getClaims(this.requestMappings, tokenRequest);
    }

    @Override
    public long tokenExpiry() {
        return this.tokenExpiry;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getClaims(List<RequestMapping> $this$getClaims, TokenRequest tokenRequest) {
        void $this$mapValuesTo$iv$iv;
        String string;
        Map map;
        Object k;
        Object object;
        void $this$mapValuesTo$iv$iv2;
        Object object2;
        Object v0;
        block9: {
            Iterable $this$firstOrNull$iv = $this$getClaims;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RequestMapping it = (RequestMapping)element$iv;
                boolean bl = false;
                if (!it.isMatch(tokenRequest)) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        if ((object2 = (RequestMapping)v0) == null || (object2 = ((RequestMapping)object2).getClaims()) == null) {
            object2 = MapsKt.emptyMap();
        }
        Object claims = object2;
        Map map2 = tokenRequest.getCustomParameters();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getCustomParameters(...)");
        Map $this$mapValues$iv = map2;
        boolean $i$f$mapValues = false;
        Map map3 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = object;
            boolean bl2 = false;
            List value = (List)entry2.getValue();
            Intrinsics.checkNotNull((Object)value);
            string = (String)CollectionsKt.first((List)value);
            map.put(k, string);
        }
        Map customParameters = destination$iv$iv;
        Map variables = Intrinsics.areEqual((Object)NimbusExtensionsKt.grantType(tokenRequest), (Object)GrantType.CLIENT_CREDENTIALS) ? MapsKt.plus((Map)customParameters, (Pair)TuplesKt.to((Object)"clientId", (Object)NimbusExtensionsKt.clientIdAsString(tokenRequest))) : customParameters;
        Object $this$mapValues$iv2 = claims;
        boolean $i$f$mapValues2 = false;
        destination$iv$iv = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            Object object3;
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map4;
            boolean bl3 = false;
            Object value = entry.getValue();
            Object v = value;
            if (v instanceof String) {
                object3 = this.replaceVariables((String)value, variables);
            } else if (v instanceof List) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void v2;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv3;
                    boolean bl4 = false;
                    collection.add(v2 instanceof String ? this.replaceVariables((String)v2, variables) : v2);
                }
                object3 = (List)destination$iv$iv3;
            } else {
                object3 = value;
            }
            string = object3;
            map.put(k, string);
        }
        return destination$iv$iv2;
    }

    private final /* synthetic */ <T> T getClaimOrNull(List<RequestMapping> $this$getClaimOrNull, TokenRequest tokenRequest, String key) {
        boolean $i$f$getClaimOrNull = false;
        Object object = this.getClaims($this$getClaimOrNull, tokenRequest).get(key);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    private final String getTypeHeader(List<RequestMapping> $this$getTypeHeader, TokenRequest tokenRequest) {
        Object object;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$getTypeHeader;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RequestMapping it = (RequestMapping)element$iv;
                boolean bl = false;
                if (!it.isMatch(tokenRequest)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (RequestMapping)v0) == null || (object = ((RequestMapping)object).getTypeHeader()) == null) {
            object = JOSEObjectType.JWT.getType();
        }
        return object;
    }

    private final String replaceVariables(String input, Map<String, String> replacements) {
        Regex pattern = new Regex("\\$\\{(\\w+)}");
        return pattern.replace((CharSequence)input, (Function1)new Function1<MatchResult, CharSequence>(replacements){
            final /* synthetic */ Map<String, String> $replacements;
            {
                this.$replacements = $replacements;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult result) {
                String replacement;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                String variableName = (String)result.getGroupValues().get(1);
                String string = replacement = this.$replacements.get(variableName);
                return string != null ? (CharSequence)string : (CharSequence)result.getValue();
            }
        });
    }

    @NotNull
    public final String component1() {
        return this.issuerId;
    }

    @NotNull
    public final List<RequestMapping> component2() {
        return this.requestMappings;
    }

    public final long component3() {
        return this.tokenExpiry;
    }

    @NotNull
    public final RequestMappingTokenCallback copy(@NotNull String issuerId, @NotNull List<RequestMapping> requestMappings, long tokenExpiry) {
        Intrinsics.checkNotNullParameter((Object)issuerId, (String)"issuerId");
        Intrinsics.checkNotNullParameter(requestMappings, (String)"requestMappings");
        return new RequestMappingTokenCallback(issuerId, requestMappings, tokenExpiry);
    }

    public static /* synthetic */ RequestMappingTokenCallback copy$default(RequestMappingTokenCallback requestMappingTokenCallback, String string, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = requestMappingTokenCallback.issuerId;
        }
        if ((n & 2) != 0) {
            list = requestMappingTokenCallback.requestMappings;
        }
        if ((n & 4) != 0) {
            l = requestMappingTokenCallback.tokenExpiry;
        }
        return requestMappingTokenCallback.copy(string, list, l);
    }

    @NotNull
    public String toString() {
        return "RequestMappingTokenCallback(issuerId=" + this.issuerId + ", requestMappings=" + this.requestMappings + ", tokenExpiry=" + this.tokenExpiry + ")";
    }

    public int hashCode() {
        int result = this.issuerId.hashCode();
        result = result * 31 + ((Object)this.requestMappings).hashCode();
        result = result * 31 + Long.hashCode(this.tokenExpiry);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingTokenCallback)) {
            return false;
        }
        RequestMappingTokenCallback requestMappingTokenCallback = (RequestMappingTokenCallback)other;
        if (!Intrinsics.areEqual((Object)this.issuerId, (Object)requestMappingTokenCallback.issuerId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.requestMappings, requestMappingTokenCallback.requestMappings)) {
            return false;
        }
        return this.tokenExpiry == requestMappingTokenCallback.tokenExpiry;
    }
}

