/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.debugger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.mock.oauth2.debugger.ClientAuthentication;
import no.nav.security.mock.oauth2.debugger.TokenRequest;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\u00020\b*\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lno/nav/security/mock/oauth2/debugger/TokenRequest;", "", "url", "Lokhttp3/HttpUrl;", "clientAuthentication", "Lno/nav/security/mock/oauth2/debugger/ClientAuthentication;", "parameters", "", "", "(Lokhttp3/HttpUrl;Lno/nav/security/mock/oauth2/debugger/ClientAuthentication;Ljava/util/Map;)V", "body", "getBody", "()Ljava/lang/String;", "headers", "Lokhttp3/Headers;", "getHeaders", "()Lokhttp3/Headers;", "getUrl", "()Lokhttp3/HttpUrl;", "toString", "toHostHeader", "includeDefaultPort", "", "toKeyValueString", "entrySeparator", "mock-oauth2-server"})
@SourceDebugExtension(value={"SMAP\nClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Client.kt\nno/nav/security/mock/oauth2/debugger/TokenRequest\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n126#2:116\n153#2,3:117\n*S KotlinDebug\n*F\n+ 1 Client.kt\nno/nav/security/mock/oauth2/debugger/TokenRequest\n*L\n57#1:116\n57#1:117,3\n*E\n"})
public final class TokenRequest {
    @NotNull
    private final HttpUrl url;
    @NotNull
    private final Headers headers;
    @NotNull
    private final String body;

    public TokenRequest(@NotNull HttpUrl url, @NotNull ClientAuthentication clientAuthentication, @NotNull Map<String, String> parameters) {
        Headers headers;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)clientAuthentication, (String)"clientAuthentication");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.url = url;
        if (WhenMappings.$EnumSwitchMapping$0[clientAuthentication.getClientAuthMethod().ordinal()] == 1) {
            String[] stringArray = new String[]{"Authorization", clientAuthentication.basic()};
            headers = Headers.Companion.of(stringArray);
        } else {
            headers = Headers.Companion.of(new String[0]);
        }
        this.headers = headers;
        this.body = clientAuthentication.getClientAuthMethod() == ClientAuthentication.Method.CLIENT_SECRET_POST ? this.toKeyValueString(parameters, "&") + "&" + clientAuthentication.form() : this.toKeyValueString(parameters, "&");
    }

    @NotNull
    public final HttpUrl getUrl() {
        return this.url;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public String toString() {
        return "POST " + this.url.encodedPath() + " HTTP/1.1\nHost: " + this.toHostHeader(this.url, true) + "\nContent-Type: application/x-www-form-urlencoded\n" + CollectionsKt.joinToString$default((Iterable)((Iterable)this.headers), (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + "\n\n" + this.body;
    }

    private final String toHostHeader(HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        Object host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), (CharSequence)":", (boolean)false, (int)2, null) ? "[" + $this$toHostHeader.host() + "]" : $this$toHostHeader.host();
        return includeDefaultPort || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme()) ? (String)host + ":" + $this$toHostHeader.port() : host;
    }

    static /* synthetic */ String toHostHeader$default(TokenRequest tokenRequest, HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return tokenRequest.toHostHeader(httpUrl, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final String toKeyValueString(Map<String, String> $this$toKeyValueString, String entrySeparator) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = $this$toKeyValueString;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toList((Iterable)((List)destination$iv$iv)), (CharSequence)entrySeparator, null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientAuthentication.Method.values().length];
            try {
                nArray[ClientAuthentication.Method.CLIENT_SECRET_BASIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

