/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.mock.oauth2.grant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.mock.oauth2.OAuth2Exception;
import no.nav.security.mock.oauth2.extensions.NimbusExtensionsKt;
import no.nav.security.mock.oauth2.grant.AuthorizationCodeHandlerKt;
import no.nav.security.mock.oauth2.grant.GrantHandler;
import no.nav.security.mock.oauth2.grant.RefreshTokenManager;
import no.nav.security.mock.oauth2.http.OAuth2HttpRequest;
import no.nav.security.mock.oauth2.http.OAuth2TokenResponse;
import no.nav.security.mock.oauth2.login.Login;
import no.nav.security.mock.oauth2.token.OAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler;", "Lno/nav/security/mock/oauth2/grant/GrantHandler;", "tokenProvider", "Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;", "refreshTokenManager", "Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;", "(Lno/nav/security/mock/oauth2/token/OAuth2TokenProvider;Lno/nav/security/mock/oauth2/grant/RefreshTokenManager;)V", "codeToAuthRequestCache", "", "Lcom/nimbusds/oauth2/sdk/AuthorizationCode;", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "codeToLoginCache", "Lno/nav/security/mock/oauth2/login/Login;", "authorizationCodeResponse", "Lcom/nimbusds/openid/connect/sdk/AuthenticationSuccessResponse;", "authenticationRequest", "login", "getLoginTokenCallbackOrDefault", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "code", "oAuth2TokenCallback", "takeAuthenticationRequestFromCache", "takeLoginFromCache", "tokenResponse", "Lno/nav/security/mock/oauth2/http/OAuth2TokenResponse;", "request", "Lno/nav/security/mock/oauth2/http/OAuth2HttpRequest;", "issuerUrl", "Lokhttp3/HttpUrl;", "LoginOAuth2TokenCallback", "mock-oauth2-server"})
public final class AuthorizationCodeHandler
implements GrantHandler {
    @NotNull
    private final OAuth2TokenProvider tokenProvider;
    @NotNull
    private final RefreshTokenManager refreshTokenManager;
    @NotNull
    private final Map<AuthorizationCode, AuthenticationRequest> codeToAuthRequestCache;
    @NotNull
    private final Map<AuthorizationCode, Login> codeToLoginCache;

    public AuthorizationCodeHandler(@NotNull OAuth2TokenProvider tokenProvider, @NotNull RefreshTokenManager refreshTokenManager) {
        Intrinsics.checkNotNullParameter((Object)tokenProvider, (String)"tokenProvider");
        Intrinsics.checkNotNullParameter((Object)refreshTokenManager, (String)"refreshTokenManager");
        this.tokenProvider = tokenProvider;
        this.refreshTokenManager = refreshTokenManager;
        this.codeToAuthRequestCache = new HashMap();
        this.codeToLoginCache = new HashMap();
    }

    @NotNull
    public final AuthenticationSuccessResponse authorizationCodeResponse(@NotNull AuthenticationRequest authenticationRequest, @Nullable Login login) {
        Intrinsics.checkNotNullParameter((Object)authenticationRequest, (String)"authenticationRequest");
        if (authenticationRequest.getResponseType().impliesCodeFlow()) {
            AuthorizationCode code = new AuthorizationCode();
            AuthorizationCodeHandlerKt.access$getLog$p().debug("issuing authorization code " + code);
            this.codeToAuthRequestCache.put(code, authenticationRequest);
            Login login2 = login;
            if (login2 != null) {
                Login login3;
                Login it = login3 = login2;
                boolean bl = false;
                AuthorizationCodeHandlerKt.access$getLog$p().debug("adding user with username " + it.getUsername() + " to cache");
                this.codeToLoginCache.put(code, login);
            }
            return new AuthenticationSuccessResponse(authenticationRequest.getRedirectionURI(), code, null, null, authenticationRequest.getState(), null, authenticationRequest.getResponseMode());
        }
        throw new OAuth2Exception(OAuth2Error.INVALID_GRANT, "hybrid og implicit flow not supported (yet).");
    }

    public static /* synthetic */ AuthenticationSuccessResponse authorizationCodeResponse$default(AuthorizationCodeHandler authorizationCodeHandler, AuthenticationRequest authenticationRequest, Login login, int n, Object object) {
        if ((n & 2) != 0) {
            login = null;
        }
        return authorizationCodeHandler.authorizationCodeResponse(authenticationRequest, login);
    }

    @Override
    @NotNull
    public OAuth2TokenResponse tokenResponse(@NotNull OAuth2HttpRequest request, @NotNull HttpUrl issuerUrl, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
        AuthenticationRequest authenticationRequest;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)issuerUrl, (String)"issuerUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
        TokenRequest tokenRequest = request.asNimbusTokenRequest();
        AuthorizationCode code = NimbusExtensionsKt.authorizationCode(tokenRequest);
        AuthorizationCodeHandlerKt.access$getLog$p().debug("issuing token for code=" + code);
        AuthenticationRequest authenticationRequest2 = authenticationRequest = this.takeAuthenticationRequestFromCache(code);
        if (authenticationRequest2 != null) {
            NimbusExtensionsKt.verifyPkce(authenticationRequest2, tokenRequest);
        }
        Scope scope = tokenRequest.getScope();
        String scope2 = scope != null ? scope.toString() : null;
        AuthenticationRequest authenticationRequest3 = authenticationRequest;
        String nonce = authenticationRequest3 != null && (authenticationRequest3 = authenticationRequest3.getNonce()) != null ? authenticationRequest3.getValue() : null;
        OAuth2TokenCallback loginTokenCallbackOrDefault = this.getLoginTokenCallbackOrDefault(code, oAuth2TokenCallback);
        SignedJWT idToken = this.tokenProvider.idToken(tokenRequest, issuerUrl, loginTokenCallbackOrDefault, nonce);
        SignedJWT accessToken = this.tokenProvider.accessToken(tokenRequest, issuerUrl, loginTokenCallbackOrDefault, nonce);
        String refreshToken = this.refreshTokenManager.refreshToken(loginTokenCallbackOrDefault, nonce);
        return new OAuth2TokenResponse("Bearer", null, idToken.serialize(), accessToken.serialize(), refreshToken, NimbusExtensionsKt.expiresIn(idToken), scope2, 2, null);
    }

    private final OAuth2TokenCallback getLoginTokenCallbackOrDefault(AuthorizationCode code, OAuth2TokenCallback oAuth2TokenCallback) {
        OAuth2TokenCallback oAuth2TokenCallback2;
        Login login = this.takeLoginFromCache(code);
        if (login != null) {
            Login it = login;
            boolean bl = false;
            oAuth2TokenCallback2 = new LoginOAuth2TokenCallback(it, oAuth2TokenCallback);
        } else {
            oAuth2TokenCallback2 = oAuth2TokenCallback;
        }
        return oAuth2TokenCallback2;
    }

    private final Login takeLoginFromCache(AuthorizationCode code) {
        return this.codeToLoginCache.remove(code);
    }

    private final AuthenticationRequest takeAuthenticationRequestFromCache(AuthorizationCode code) {
        return this.codeToAuthRequestCache.remove(code);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback;", "Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "login", "Lno/nav/security/mock/oauth2/login/Login;", "oAuth2TokenCallback", "(Lno/nav/security/mock/oauth2/login/Login;Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;)V", "getLogin", "()Lno/nav/security/mock/oauth2/login/Login;", "getOAuth2TokenCallback", "()Lno/nav/security/mock/oauth2/token/OAuth2TokenCallback;", "addClaims", "", "", "", "tokenRequest", "Lcom/nimbusds/oauth2/sdk/TokenRequest;", "audience", "", "issuerId", "subject", "tokenExpiry", "", "typeHeader", "mock-oauth2-server"})
    @SourceDebugExtension(value={"SMAP\nAuthorizationCodeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationCodeHandler.kt\nno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1869#2:137\n1870#2:151\n116#3:138\n54#3:139\n117#3:140\n61#3,8:141\n71#3:150\n1#4:149\n*S KotlinDebug\n*F\n+ 1 AuthorizationCodeHandler.kt\nno/nav/security/mock/oauth2/grant/AuthorizationCodeHandler$LoginOAuth2TokenCallback\n*L\n124#1:137\n124#1:151\n125#1:138\n125#1:139\n125#1:140\n125#1:141,8\n125#1:150\n125#1:149\n*E\n"})
    private static final class LoginOAuth2TokenCallback
    implements OAuth2TokenCallback {
        @NotNull
        private final Login login;
        @NotNull
        private final OAuth2TokenCallback oAuth2TokenCallback;

        public LoginOAuth2TokenCallback(@NotNull Login login, @NotNull OAuth2TokenCallback oAuth2TokenCallback) {
            Intrinsics.checkNotNullParameter((Object)login, (String)"login");
            Intrinsics.checkNotNullParameter((Object)oAuth2TokenCallback, (String)"oAuth2TokenCallback");
            this.login = login;
            this.oAuth2TokenCallback = oAuth2TokenCallback;
        }

        @NotNull
        public final Login getLogin() {
            return this.login;
        }

        @NotNull
        public final OAuth2TokenCallback getOAuth2TokenCallback() {
            return this.oAuth2TokenCallback;
        }

        @Override
        @NotNull
        public String issuerId() {
            return this.oAuth2TokenCallback.issuerId();
        }

        @Override
        @NotNull
        public String subject(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.login.getUsername();
        }

        @Override
        @NotNull
        public String typeHeader(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.oAuth2TokenCallback.typeHeader(tokenRequest);
        }

        @Override
        @NotNull
        public List<String> audience(@NotNull TokenRequest tokenRequest) {
            Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
            return this.oAuth2TokenCallback.audience(tokenRequest);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Map<String, Object> addClaims(@NotNull TokenRequest tokenRequest) {
            Map map;
            block6: {
                Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
                Map $this$addClaims_u24lambda_u240 = map = MapsKt.toMutableMap(this.oAuth2TokenCallback.addClaims(tokenRequest));
                boolean bl = false;
                String string = this.login.getClaims();
                if (string == null) break block6;
                String it = string;
                boolean bl2 = false;
                try {
                    void $this$forEach$iv;
                    Set set = AuthorizationCodeHandlerKt.access$getJsonMapper$p().readTree(it).properties();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
                    Iterable iterable = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$checkTypeMismatch$iv$iv;
                        String content$iv;
                        void $this$readValue$iv;
                        Map.Entry field = (Map.Entry)element$iv;
                        boolean bl3 = false;
                        Object k = field.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        ObjectMapper objectMapper = AuthorizationCodeHandlerKt.access$getJsonMapper$p();
                        Intrinsics.checkNotNullExpressionValue((Object)((JsonNode)field.getValue()).toString(), (String)"toString(...)");
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef22 = false;
                        Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<Object>(){});
                        boolean $i$f$checkTypeMismatch = false;
                        if (!($this$checkTypeMismatch$iv$iv instanceof Object)) {
                            String string2;
                            String nullability$iv$iv = "(non-null)";
                            StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                            void v4 = $this$checkTypeMismatch$iv$iv;
                            if (v4 != null) {
                                void it$iv$iv;
                                void var19_21 = v4;
                                StringBuilder stringBuilder2 = stringBuilder;
                                boolean bl4 = false;
                                string2 = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                                stringBuilder = stringBuilder2;
                            } else {
                                string2 = null;
                            }
                            String string3 = stringBuilder.append(string2).toString();
                            throw new RuntimeJsonMappingException(string3);
                        }
                        $this$addClaims_u24lambda_u240.put(k, $this$checkTypeMismatch$iv$iv);
                    }
                }
                catch (JsonProcessingException exception) {
                    AuthorizationCodeHandlerKt.access$getLog$p().warn("claims value " + it + " could not be processed as JSON, details: " + exception.getMessage());
                }
            }
            return map;
        }

        @Override
        public long tokenExpiry() {
            return this.oAuth2TokenCallback.tokenExpiry();
        }
    }
}

