/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.SocketUtils;

@Order
public class MockOAuth2ServerApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private final Logger log = LoggerFactory.getLogger(MockOAuth2ServerApplicationListener.class);
    static final String PROPERTY_PREFIX = "mock-oauth2-server";
    private static final String PORT_PROPERTY = "mock-oauth2-server.port";
    private static final String RANDOM_PORT_PROPERTY = "mock-oauth2-server.random-port";
    private static final int MIN_PORT = 10000;
    private static final int MAX_PORT = 12000;

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.log.debug("received ApplicationPreparedEvent, register random port with environment if not set.");
        this.registerPort(event);
    }

    private void registerPort(ApplicationPreparedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        Integer httpPortProperty = (Integer)environment.getProperty(PORT_PROPERTY, Integer.class);
        if (this.isRandomPort(httpPortProperty)) {
            int port = SocketUtils.findAvailableTcpPort((int)10000, (int)12000);
            MutablePropertySources propertySources = environment.getPropertySources();
            this.addPropertySource(propertySources);
            Map source = (Map)((MapPropertySource)Objects.requireNonNull(propertySources.get(PROPERTY_PREFIX))).getSource();
            source.put(PORT_PROPERTY, port);
            source.put(RANDOM_PORT_PROPERTY, true);
            this.log.debug("Registered property source for dynamic http port=" + port);
        } else {
            this.log.debug("port provided explicitly from annotation ({}), nothing to register.", (Object)httpPortProperty);
        }
    }

    private boolean isRandomPort(Integer httpPortProperty) {
        return httpPortProperty == null || httpPortProperty <= 0;
    }

    private void addPropertySource(MutablePropertySources propertySources) {
        if (!propertySources.contains(PROPERTY_PREFIX)) {
            propertySources.addFirst((PropertySource)new MapPropertySource(PROPERTY_PREFIX, new HashMap()));
        } else {
            PropertySource source = propertySources.remove(PROPERTY_PREFIX);
            assert (source != null);
            propertySources.addFirst(source);
        }
    }
}

