/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.spring.test;

import java.io.IOException;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import no.nav.security.mock.oauth2.MockOAuth2Server;
import no.nav.security.mock.oauth2.OAuth2Config;
import no.nav.security.mock.oauth2.http.Route;
import no.nav.security.mock.oauth2.token.DefaultOAuth2TokenCallback;
import no.nav.security.mock.oauth2.token.OAuth2TokenProvider;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.spring.test.MockOAuth2ServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={MockOAuth2ServerProperties.class})
public class MockOAuth2ServerAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(MockOAuth2ServerAutoConfiguration.class);
    private final MockOAuth2Server mockOAuth2Server;
    private final MockOAuth2ServerProperties properties;

    public MockOAuth2ServerAutoConfiguration(MockOAuth2ServerProperties properties) {
        this.properties = properties;
        this.mockOAuth2Server = new MockOAuth2Server(new OAuth2Config(properties.isInteractiveLogin(), new OAuth2TokenProvider(), Set.of(new DefaultOAuth2TokenCallback())), new Route[0]);
    }

    @Bean
    @Primary
    @DependsOn(value={"mockOAuth2Server"})
    ProxyAwareResourceRetriever overrideOidcResourceRetriever() {
        return new ProxyAwareResourceRetriever();
    }

    @Bean
    MockOAuth2Server mockOAuth2Server() {
        return this.mockOAuth2Server;
    }

    @PostConstruct
    void start() {
        try {
            int port = this.properties.getPort();
            if (port <= 0) {
                throw new RuntimeException("could not find mock-oauth2-server.port in environment. cannot start server.");
            }
            this.log.debug("starting mock oauth2 server on port " + port);
            this.mockOAuth2Server.start(port);
        }
        catch (IOException e) {
            this.log.error("could not register and start MockOAuth2Server");
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    void shutdown() throws IOException {
        this.log.debug("shutting down the mock oauth2 server.");
        this.mockOAuth2Server.shutdown();
    }
}

