/*
 * Decompiled with CFR 0.152.
 */
package no.nav.vault.jdbc.hikaricp;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.LogicalResponse;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.TimerTask;
import no.nav.vault.jdbc.hikaricp.VaultError;
import no.nav.vault.jdbc.hikaricp.VaultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariCPVaultUtil {
    private static final Logger logger = LoggerFactory.getLogger(HikariCPVaultUtil.class);
    private HikariDataSource ds = null;
    private final HikariConfig hikariConfig;
    private final Vault vault;
    private final String mountPath;
    private final String role;

    private HikariCPVaultUtil(HikariConfig config, Vault vault, String mountPath, String role) {
        this.hikariConfig = config;
        this.vault = vault;
        this.mountPath = mountPath;
        this.role = role;
    }

    private void setDs(HikariDataSource ds) {
        this.ds = ds;
    }

    public static HikariDataSource createHikariDataSourceWithVaultIntegration(HikariConfig config, String mountPath, String role) throws VaultError {
        VaultUtil instance = VaultUtil.getInstance();
        Vault vault = instance.getClient();
        HikariCPVaultUtil hikariCPVaultUtil = new HikariCPVaultUtil(config, vault, mountPath, role);
        try {
            RefreshResult refreshResult = hikariCPVaultUtil.refreshCredentialsAndReturnRefreshInterval();
            final class RefreshDbCredentialsTask
            extends TimerTask {
                final /* synthetic */ VaultUtil val$instance;
                final /* synthetic */ String val$role;

                RefreshDbCredentialsTask() {
                    this.val$instance = vaultUtil;
                    this.val$role = string;
                }

                @Override
                public void run() {
                    try {
                        if (HikariCPVaultUtil.this.ds != null && HikariCPVaultUtil.this.ds.isClosed()) {
                            logger.info("Datasource is closed. Stopping scheduling of RefreshDbCredentialsTask");
                            this.cancel();
                            return;
                        }
                        RefreshResult refreshResult = HikariCPVaultUtil.this.refreshCredentialsAndReturnRefreshInterval();
                        this.val$instance.getTimer().schedule((TimerTask)new RefreshDbCredentialsTask(), VaultUtil.suggestedRefreshInterval(refreshResult.leaseDuration * 1000L));
                    }
                    catch (VaultException e) {
                        if (e.getHttpStatusCode() == 403) {
                            logger.error("Vault denied permission to fetch database credentials for role \"" + this.val$role + "\"", (Throwable)e);
                        } else {
                            logger.error("Could not fetch database credentials for role \"" + this.val$role + "\"", (Throwable)e);
                        }
                        logger.warn("Waiting 5 secs before trying to get new credentials");
                        this.val$instance.getTimer().schedule((TimerTask)new RefreshDbCredentialsTask(), 5000L);
                    }
                }
            }
            instance.getTimer().schedule((TimerTask)hikariCPVaultUtil.new RefreshDbCredentialsTask(), VaultUtil.suggestedRefreshInterval(refreshResult.leaseDuration * 1000L));
        }
        catch (VaultException e) {
            throw new VaultError("Could not fetch initial database credentials for role \"" + role + "\"", e);
        }
        HikariDataSource ds = new HikariDataSource(config);
        hikariCPVaultUtil.setDs(ds);
        return ds;
    }

    private RefreshResult refreshCredentialsAndReturnRefreshInterval() throws VaultException {
        String path = this.mountPath + "/creds/" + this.role;
        logger.info("Renewing database credentials for role \"" + this.role + "\"");
        LogicalResponse response = this.vault.logical().read(path);
        String username = (String)response.getData().get("username");
        String password = (String)response.getData().get("password");
        logger.info("Got new credentials (username=" + username + ")");
        this.hikariConfig.setUsername(username);
        this.hikariConfig.setPassword(password);
        if (this.ds != null) {
            this.ds.setUsername(username);
            this.ds.setPassword(password);
            this.ds.getHikariConfigMXBean().setUsername(username);
            this.ds.getHikariConfigMXBean().setPassword(password);
            this.ds.getHikariPoolMXBean().softEvictConnections();
        }
        return new RefreshResult(response.getLeaseId(), response.getLeaseDuration());
    }

    private static final class RefreshResult {
        final String leaseId;
        final long leaseDuration;

        RefreshResult(String leaseId, long leaseDuration) {
            this.leaseId = leaseId;
            this.leaseDuration = leaseDuration;
        }
    }
}

