/*
 * Decompiled with CFR 0.152.
 */
package no.nav.vault.jdbc.hikaricp;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LookupResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import no.nav.vault.jdbc.hikaricp.VaultError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultUtil {
    private static final Logger logger = LoggerFactory.getLogger(VaultUtil.class);
    public static final String VAULT_TOKEN_PROPERTY = "VAULT_TOKEN";
    public static final String VAULT_TOKEN_PATH_PROPERTY = "VAULT_TOKEN_PATH";
    public static final int MIN_REFRESH_MARGIN = 600000;
    private static VaultUtil INSTANCE;
    private Vault vault;
    private Timer timer = new Timer("VaultScheduler", true);

    private VaultUtil() {
    }

    public static long suggestedRefreshInterval(long duration) {
        if (duration < 1200000L) {
            return duration / 2L;
        }
        return duration - 600000L;
    }

    public static VaultUtil getInstance() throws VaultError {
        if (INSTANCE == null) {
            VaultUtil util = new VaultUtil();
            util.init();
            INSTANCE = util;
        }
        return INSTANCE;
    }

    public Vault getClient() {
        return this.vault;
    }

    public Timer getTimer() {
        return this.timer;
    }

    private void init() throws VaultError {
        VaultConfig vaultConfig = null;
        try {
            vaultConfig = new VaultConfig().address(VaultUtil.getPropertyOrDefault("VAULT_ADDR", "https://vault.adeo.no")).token(VaultUtil.getVaultToken()).openTimeout(Integer.valueOf(5)).readTimeout(Integer.valueOf(30)).sslConfig(new SslConfig().build()).build();
        }
        catch (VaultException e) {
            throw new VaultError("Could not instantiate the Vault REST client", e);
        }
        this.vault = new Vault(vaultConfig, Integer.valueOf(1));
        LookupResponse lookupSelf = null;
        try {
            lookupSelf = this.vault.auth().lookupSelf();
        }
        catch (VaultException e) {
            if (e.getHttpStatusCode() == 403) {
                throw new VaultError("The application's vault token seems to be invalid", e);
            }
            throw new VaultError("Could not validate the application's vault token", e);
        }
        if (lookupSelf.isRenewable()) {
            logger.info("Starting a refresh timer on the vault token (TTL = " + lookupSelf.getTTL() + " seconds");
            final class RefreshTokenTask
            extends TimerTask {
                RefreshTokenTask() {
                }

                @Override
                public void run() {
                    try {
                        logger.info("Refreshing Vault token (old TTL = " + VaultUtil.this.vault.auth().lookupSelf().getTTL() + " seconds)");
                        AuthResponse response = VaultUtil.this.vault.auth().renewSelf();
                        logger.info("Refreshed Vault token (new TTL = " + VaultUtil.this.vault.auth().lookupSelf().getTTL() + " seconds)");
                        VaultUtil.this.timer.schedule((TimerTask)new RefreshTokenTask(), VaultUtil.suggestedRefreshInterval(response.getAuthLeaseDuration() * 1000L));
                    }
                    catch (VaultException e) {
                        logger.error("Could not refresh the Vault token", (Throwable)e);
                        logger.warn("Waiting 5 secs before trying to refresh the Vault token");
                        VaultUtil.this.timer.schedule((TimerTask)new RefreshTokenTask(), 5000L);
                    }
                }
            }
            this.timer.schedule((TimerTask)new RefreshTokenTask(), VaultUtil.suggestedRefreshInterval(lookupSelf.getTTL() * 1000L));
        } else {
            logger.warn("Vault token is not renewable");
        }
    }

    private static String getPropertyOrDefault(String propertyName, String defaultValue) {
        String result = VaultUtil.getProperty(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private static String getProperty(String propertyName) {
        return System.getProperty(propertyName, System.getenv(propertyName));
    }

    private static String getVaultToken() {
        try {
            if (VaultUtil.getProperty(VAULT_TOKEN_PROPERTY) != null && !"".equals(VaultUtil.getProperty(VAULT_TOKEN_PROPERTY))) {
                return VaultUtil.getProperty(VAULT_TOKEN_PROPERTY);
            }
            if (VaultUtil.getProperty(VAULT_TOKEN_PATH_PROPERTY) != null) {
                byte[] encoded = Files.readAllBytes(Paths.get(VaultUtil.getProperty(VAULT_TOKEN_PATH_PROPERTY), new String[0]));
                return new String(encoded, "UTF-8").trim();
            }
            if (Files.exists(Paths.get("/var/run/secrets/nais.io/vault/vault_token", new String[0]), new LinkOption[0])) {
                byte[] encoded = Files.readAllBytes(Paths.get("/var/run/secrets/nais.io/vault/vault_token", new String[0]));
                return new String(encoded, "UTF-8").trim();
            }
            throw new RuntimeException("Neither VAULT_TOKEN or VAULT_TOKEN_PATH is set");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get a vault token for authentication", e);
        }
    }
}

