/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.IntentService;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.dfu.R;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.HexInputStream;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.HexFileValidationException;
import no.nordicsemi.android.dfu.internal.exception.UnknownResponseException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

public abstract class DfuBaseService
extends IntentService {
    private static final String TAG = "DfuBaseService";
    public static final String EXTRA_DEVICE_ADDRESS = "no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS";
    public static final String EXTRA_DEVICE_NAME = "no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_NAME";
    public static final String EXTRA_DISABLE_NOTIFICATION = "no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_NOTIFICATION";
    public static final String EXTRA_RESTORE_BOND = "no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND";
    public static final String EXTRA_KEEP_BOND = "no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND";
    public static final String EXTRA_FILE_PATH = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_PATH";
    public static final String EXTRA_FILE_URI = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_URI";
    public static final String EXTRA_FILE_RES_ID = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_RES_ID";
    public static final String EXTRA_INIT_FILE_PATH = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_PATH";
    public static final String EXTRA_INIT_FILE_URI = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_URI";
    public static final String EXTRA_INIT_FILE_RES_ID = "no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_RES_ID";
    public static final String EXTRA_FILE_MIME_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_MIME_TYPE";
    public static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE_ZIP = "application/zip";
    public static final String EXTRA_FILE_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_FILE_TYPE";
    public static final int TYPE_SOFT_DEVICE = 1;
    public static final int TYPE_BOOTLOADER = 2;
    public static final int TYPE_APPLICATION = 4;
    public static final int TYPE_AUTO = 0;
    public static final String EXTRA_DATA = "no.nordicsemi.android.dfu.extra.EXTRA_DATA";
    public static final String EXTRA_PROGRESS = "no.nordicsemi.android.dfu.extra.EXTRA_PROGRESS";
    public static final String EXTRA_PART_CURRENT = "no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT";
    public static final String EXTRA_PARTS_TOTAL = "no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL";
    public static final String EXTRA_SPEED_B_PER_MS = "no.nordicsemi.android.dfu.extra.EXTRA_SPEED_B_PER_MS";
    public static final String EXTRA_AVG_SPEED_B_PER_MS = "no.nordicsemi.android.dfu.extra.EXTRA_AVG_SPEED_B_PER_MS";
    public static final String BROADCAST_PROGRESS = "no.nordicsemi.android.dfu.broadcast.BROADCAST_PROGRESS";
    public static final int PROGRESS_CONNECTING = -1;
    public static final int PROGRESS_STARTING = -2;
    public static final int PROGRESS_ENABLING_DFU_MODE = -3;
    public static final int PROGRESS_VALIDATING = -4;
    public static final int PROGRESS_DISCONNECTING = -5;
    public static final int PROGRESS_COMPLETED = -6;
    public static final int PROGRESS_ABORTED = -7;
    public static final String BROADCAST_ERROR = "no.nordicsemi.android.dfu.broadcast.BROADCAST_ERROR";
    public static final String EXTRA_ERROR_TYPE = "no.nordicsemi.android.dfu.extra.EXTRA_ERROR_TYPE";
    public static final int ERROR_TYPE_OTHER = 0;
    public static final int ERROR_TYPE_COMMUNICATION_STATE = 1;
    public static final int ERROR_TYPE_COMMUNICATION = 2;
    public static final int ERROR_TYPE_DFU_REMOTE = 3;
    public static final int ERROR_MASK = 4096;
    public static final int ERROR_DEVICE_DISCONNECTED = 4096;
    public static final int ERROR_FILE_NOT_FOUND = 4097;
    public static final int ERROR_FILE_ERROR = 4098;
    public static final int ERROR_FILE_INVALID = 4099;
    public static final int ERROR_FILE_IO_EXCEPTION = 4100;
    public static final int ERROR_SERVICE_DISCOVERY_NOT_STARTED = 4101;
    public static final int ERROR_SERVICE_NOT_FOUND = 4102;
    public static final int ERROR_CHARACTERISTICS_NOT_FOUND = 4103;
    public static final int ERROR_INVALID_RESPONSE = 4104;
    public static final int ERROR_FILE_TYPE_UNSUPPORTED = 4105;
    public static final int ERROR_BLUETOOTH_DISABLED = 4106;
    public static final int ERROR_INIT_PACKET_REQUIRED = 4107;
    public static final int ERROR_FILE_SIZE_INVALID = 4108;
    public static final int ERROR_REMOTE_MASK = 8192;
    public static final int ERROR_CONNECTION_MASK = 16384;
    public static final int ERROR_CONNECTION_STATE_MASK = 32768;
    public static final String BROADCAST_LOG = "no.nordicsemi.android.dfu.broadcast.BROADCAST_LOG";
    public static final String EXTRA_LOG_MESSAGE = "no.nordicsemi.android.dfu.extra.EXTRA_LOG_INFO";
    public static final String EXTRA_LOG_LEVEL = "no.nordicsemi.android.dfu.extra.EXTRA_LOG_LEVEL";
    public static final int LOG_LEVEL_DEBUG = 0;
    public static final int LOG_LEVEL_VERBOSE = 1;
    public static final int LOG_LEVEL_INFO = 5;
    public static final int LOG_LEVEL_APPLICATION = 10;
    public static final int LOG_LEVEL_WARNING = 15;
    public static final int LOG_LEVEL_ERROR = 20;
    public static final String BROADCAST_ACTION = "no.nordicsemi.android.dfu.broadcast.BROADCAST_ACTION";
    public static final String EXTRA_ACTION = "no.nordicsemi.android.dfu.extra.EXTRA_ACTION";
    public static final int ACTION_PAUSE = 0;
    public static final int ACTION_RESUME = 1;
    public static final int ACTION_ABORT = 2;
    public static final int DFU_STATUS_SUCCESS = 1;
    public static final int DFU_STATUS_INVALID_STATE = 2;
    public static final int DFU_STATUS_NOT_SUPPORTED = 3;
    public static final int DFU_STATUS_DATA_SIZE_EXCEEDS_LIMIT = 4;
    public static final int DFU_STATUS_CRC_ERROR = 5;
    public static final int DFU_STATUS_OPERATION_FAILED = 6;
    private static final int OP_CODE_START_DFU_KEY = 1;
    private static final int OP_CODE_INIT_DFU_PARAMS_KEY = 2;
    private static final int OP_CODE_RECEIVE_FIRMWARE_IMAGE_KEY = 3;
    private static final int OP_CODE_VALIDATE_KEY = 4;
    private static final int OP_CODE_ACTIVATE_AND_RESET_KEY = 5;
    private static final int OP_CODE_RESET_KEY = 6;
    private static final int OP_CODE_PACKET_RECEIPT_NOTIF_REQ_KEY = 8;
    private static final int OP_CODE_RESPONSE_CODE_KEY = 16;
    private static final int OP_CODE_PACKET_RECEIPT_NOTIF_KEY = 17;
    private static final byte[] OP_CODE_START_DFU = new byte[]{1, 0};
    private static final byte[] OP_CODE_INIT_DFU_PARAMS_START = new byte[]{2, 0};
    private static final byte[] OP_CODE_INIT_DFU_PARAMS_COMPLETE = new byte[]{2, 1};
    private static final byte[] OP_CODE_RECEIVE_FIRMWARE_IMAGE = new byte[]{3};
    private static final byte[] OP_CODE_VALIDATE = new byte[]{4};
    private static final byte[] OP_CODE_ACTIVATE_AND_RESET = new byte[]{5};
    private static final byte[] OP_CODE_RESET = new byte[]{6};
    private static final byte[] OP_CODE_PACKET_RECEIPT_NOTIF_REQ = new byte[]{8, 0, 0};
    private static final UUID GENERIC_ATTRIBUTE_SERVICE_UUID = new UUID(0x180100001000L, -9223371485494954757L);
    private static final UUID SERVICE_CHANGED_UUID = new UUID(46200963207168L, -9223371485494954757L);
    private static final UUID DFU_SERVICE_UUID = new UUID(23296205844446L, 1523193452336828707L);
    private static final UUID DFU_CONTROL_POINT_UUID = new UUID(23300500811742L, 1523193452336828707L);
    private static final UUID DFU_PACKET_UUID = new UUID(23304795779038L, 1523193452336828707L);
    private static final UUID DFU_VERSION = new UUID(23313385713630L, 1523193452336828707L);
    private static final UUID CLIENT_CHARACTERISTIC_CONFIG = new UUID(45088566677504L, -9223371485494954757L);
    public static final int NOTIFICATION_ID = 283;
    private static final int NOTIFICATIONS = 1;
    private static final int INDICATIONS = 2;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int MAX_PACKET_SIZE = 20;
    private final byte[] mBuffer = new byte[20];
    private final Object mLock = new Object();
    private BluetoothAdapter mBluetoothAdapter;
    private InputStream mInputStream;
    private String mDeviceAddress;
    private String mDeviceName;
    private boolean mDisableNotification;
    private int mConnectionState;
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_CONNECTING = -1;
    private static final int STATE_CONNECTED = -2;
    private static final int STATE_CONNECTED_AND_READY = -3;
    private static final int STATE_DISCONNECTING = -4;
    private static final int STATE_CLOSED = -5;
    private int mError;
    private boolean mNotificationsEnabled;
    private boolean mServiceChangedIndicationsEnabled;
    private int mPacketsBeforeNotification = 10;
    private int mImageSizeInBytes;
    private int mBytesSent;
    private int mBytesConfirmed;
    private int mPacketsSentSinceNotification;
    private int mLastBytesSent;
    private int mPartCurrent;
    private int mPartsTotal;
    private int mFileType;
    private long mLastProgressTime;
    private long mStartTime;
    private boolean mResetRequestSent;
    private boolean mImageSizeSent;
    private boolean mInitPacketSent;
    private boolean mRequestCompleted;
    private boolean mRemoteErrorOccurred;
    private boolean mPaused;
    private boolean mAborted;
    private byte[] mReceivedData = null;
    private final BroadcastReceiver mConnectionStateBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (!device.getAddress().equals(DfuBaseService.this.mDeviceAddress)) {
                return;
            }
            String action = intent.getAction();
            DfuBaseService.this.logi("Action received: " + action);
            DfuBaseService.this.mConnectionState = 0;
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }
    };
    private final BroadcastReceiver mDfuActionReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            int action = intent.getIntExtra(DfuBaseService.EXTRA_ACTION, 0);
            switch (action) {
                case 0: {
                    DfuBaseService.this.mPaused = true;
                    break;
                }
                case 1: {
                    DfuBaseService.this.mPaused = false;
                    Object object = DfuBaseService.this.mLock;
                    synchronized (object) {
                        DfuBaseService.this.mLock.notifyAll();
                        break;
                    }
                }
                case 2: {
                    DfuBaseService.this.mPaused = false;
                    DfuBaseService.this.mAborted = true;
                    Object object = DfuBaseService.this.mLock;
                    synchronized (object) {
                        DfuBaseService.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mBondStateBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (!device.getAddress().equals(DfuBaseService.this.mDeviceAddress)) {
                return;
            }
            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            if (bondState == 11) {
                return;
            }
            DfuBaseService.this.mRequestCompleted = true;
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }
    };
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (status == 0) {
                if (newState == 2) {
                    DfuBaseService.this.logi("Connected to GATT server");
                    DfuBaseService.this.mConnectionState = -2;
                    if (gatt.getDevice().getBondState() == 12) {
                        try {
                            4 var4_4 = this;
                            synchronized (var4_4) {
                                DfuBaseService.this.logd("Waiting 1600 ms for a possible Service Changed indication...");
                                DfuBaseService.this.sendLogBroadcast(0, "wait(1600)");
                                ((Object)((Object)this)).wait(1600L);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    DfuBaseService.this.sendLogBroadcast(0, "gatt.discoverServices()");
                    boolean success = gatt.discoverServices();
                    DfuBaseService.this.logi("Attempting to start service discovery... " + (success ? "succeed" : "failed"));
                    if (success) return;
                    DfuBaseService.this.mError = 4101;
                } else if (newState == 0) {
                    DfuBaseService.this.logi("Disconnected from GATT server");
                    DfuBaseService.this.mPaused = false;
                    DfuBaseService.this.mConnectionState = 0;
                }
            } else {
                DfuBaseService.this.loge("Connection state change error: " + status + " newState: " + newState);
                if (newState == 0) {
                    DfuBaseService.this.mConnectionState = 0;
                }
                DfuBaseService.this.mPaused = false;
                DfuBaseService.this.mError = 0x8000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                DfuBaseService.this.logi("Services discovered");
                DfuBaseService.this.mConnectionState = -3;
            } else {
                DfuBaseService.this.loge("Service discovery error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(descriptor.getUuid()) && SERVICE_CHANGED_UUID.equals(descriptor.getCharacteristic().getUuid())) {
                    DfuBaseService.this.mServiceChangedIndicationsEnabled = descriptor.getValue()[0] == 2;
                    DfuBaseService.this.mRequestCompleted = true;
                }
            } else {
                DfuBaseService.this.loge("Descriptor read error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(descriptor.getUuid())) {
                    if (SERVICE_CHANGED_UUID.equals(descriptor.getCharacteristic().getUuid())) {
                        DfuBaseService.this.mServiceChangedIndicationsEnabled = descriptor.getValue()[0] == 2;
                    } else {
                        DfuBaseService.this.mNotificationsEnabled = descriptor.getValue()[0] == 1;
                    }
                }
            } else {
                DfuBaseService.this.loge("Descriptor write error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                if (DFU_PACKET_UUID.equals(characteristic.getUuid())) {
                    if (DfuBaseService.this.mImageSizeSent && DfuBaseService.this.mInitPacketSent) {
                        boolean lastPacketTransferred;
                        DfuBaseService.this.mBytesSent += characteristic.getValue().length;
                        DfuBaseService.this.mPacketsSentSinceNotification++;
                        boolean notificationExpected = DfuBaseService.this.mPacketsBeforeNotification > 0 && DfuBaseService.this.mPacketsSentSinceNotification == DfuBaseService.this.mPacketsBeforeNotification;
                        boolean bl = lastPacketTransferred = DfuBaseService.this.mBytesSent == DfuBaseService.this.mImageSizeInBytes;
                        if (notificationExpected || lastPacketTransferred) {
                            return;
                        }
                        try {
                            DfuBaseService.this.waitIfPaused();
                            if (DfuBaseService.this.mAborted || DfuBaseService.this.mError != 0 || DfuBaseService.this.mRemoteErrorOccurred || DfuBaseService.this.mResetRequestSent) {
                                Object object = DfuBaseService.this.mLock;
                                synchronized (object) {
                                    DfuBaseService.this.sendLogBroadcast(15, "Upload terminated");
                                    DfuBaseService.this.mLock.notifyAll();
                                    return;
                                }
                            }
                            byte[] buffer = DfuBaseService.this.mBuffer;
                            int size = DfuBaseService.this.mInputStream.read(buffer);
                            DfuBaseService.this.writePacket(gatt, characteristic, buffer, size);
                            DfuBaseService.this.updateProgressNotification();
                            return;
                        }
                        catch (HexFileValidationException e) {
                            DfuBaseService.this.loge("Invalid HEX file");
                            DfuBaseService.this.mError = 4099;
                        }
                        catch (IOException e) {
                            DfuBaseService.this.loge("Error while reading the input stream", e);
                            DfuBaseService.this.mError = 4100;
                        }
                    } else if (!DfuBaseService.this.mImageSizeSent) {
                        DfuBaseService.this.sendLogBroadcast(5, "Data written to " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                        DfuBaseService.this.mImageSizeSent = true;
                    } else {
                        DfuBaseService.this.sendLogBroadcast(5, "Data written to " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                        DfuBaseService.this.mInitPacketSent = true;
                    }
                } else {
                    DfuBaseService.this.sendLogBroadcast(5, "Data written to " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                    DfuBaseService.this.mRequestCompleted = true;
                }
            } else if (DfuBaseService.this.mResetRequestSent) {
                DfuBaseService.this.mRequestCompleted = true;
            } else {
                DfuBaseService.this.loge("Characteristic write error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                DfuBaseService.this.sendLogBroadcast(5, "Read Response received from " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                DfuBaseService.access$3002(DfuBaseService.this, characteristic.getValue());
                DfuBaseService.this.mRequestCompleted = true;
            } else {
                DfuBaseService.this.loge("Characteristic read error: " + status);
                DfuBaseService.this.mError = 0x4000 | status;
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            int responseType = characteristic.getIntValue(17, 0);
            switch (responseType) {
                case 17: {
                    BluetoothGattCharacteristic packetCharacteristic = gatt.getService(DFU_SERVICE_UUID).getCharacteristic(DFU_PACKET_UUID);
                    try {
                        DfuBaseService.this.mBytesConfirmed = characteristic.getIntValue(20, 1);
                        DfuBaseService.this.mPacketsSentSinceNotification = 0;
                        DfuBaseService.this.waitIfPaused();
                        if (!(DfuBaseService.this.mAborted || DfuBaseService.this.mError != 0 || DfuBaseService.this.mRemoteErrorOccurred || DfuBaseService.this.mResetRequestSent)) {
                            byte[] buffer = DfuBaseService.this.mBuffer;
                            int size = DfuBaseService.this.mInputStream.read(buffer);
                            DfuBaseService.this.writePacket(gatt, packetCharacteristic, buffer, size);
                            DfuBaseService.this.updateProgressNotification();
                            return;
                        }
                        DfuBaseService.this.sendLogBroadcast(15, "Upload terminated");
                    }
                    catch (HexFileValidationException e) {
                        DfuBaseService.this.loge("Invalid HEX file");
                        DfuBaseService.this.mError = 4099;
                    }
                    catch (IOException e) {
                        DfuBaseService.this.loge("Error while reading the input stream", e);
                        DfuBaseService.this.mError = 4100;
                    }
                    break;
                }
                default: {
                    if (DfuBaseService.this.mRemoteErrorOccurred) break;
                    int status = characteristic.getIntValue(17, 2);
                    if (status != 1) {
                        DfuBaseService.this.mRemoteErrorOccurred = true;
                    }
                    DfuBaseService.this.sendLogBroadcast(5, "Notification received from " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                    DfuBaseService.access$3002(DfuBaseService.this, characteristic.getValue());
                }
            }
            Object object = DfuBaseService.this.mLock;
            synchronized (object) {
                DfuBaseService.this.mLock.notifyAll();
            }
        }

        private String parse(BluetoothGattCharacteristic characteristic) {
            byte[] data = characteristic.getValue();
            if (data == null) {
                return "";
            }
            int length = data.length;
            if (length == 0) {
                return "";
            }
            char[] out = new char[length * 3 - 1];
            for (int j = 0; j < length; ++j) {
                int v = data[j] & 0xFF;
                out[j * 3] = HEX_ARRAY[v >>> 4];
                out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
                if (j == length - 1) continue;
                out[j * 3 + 2] = 45;
            }
            return new String(out);
        }
    };
    private int mLastProgress = -1;

    public DfuBaseService() {
        super(TAG);
    }

    private static IntentFilter makeDfuActionIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BROADCAST_ACTION);
        return intentFilter;
    }

    public void onCreate() {
        super.onCreate();
        this.initialize();
        LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
        IntentFilter actionFilter = DfuBaseService.makeDfuActionIntentFilter();
        manager.registerReceiver(this.mDfuActionReceiver, actionFilter);
        this.registerReceiver(this.mDfuActionReceiver, actionFilter);
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.registerReceiver(this.mConnectionStateBroadcastReceiver, filter);
        IntentFilter bondFilter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.registerReceiver(this.mBondStateBroadcastReceiver, bondFilter);
    }

    public void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager manager = LocalBroadcastManager.getInstance((Context)this);
        manager.unregisterReceiver(this.mDfuActionReceiver);
        this.unregisterReceiver(this.mDfuActionReceiver);
        this.unregisterReceiver(this.mConnectionStateBroadcastReceiver);
        this.unregisterReceiver(this.mBondStateBroadcastReceiver);
    }

    /*
     * Exception decompiling
     */
    protected void onHandleIntent(Intent intent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setNumberOfPackets(byte[] data, int value) {
        data[1] = (byte)(value & 0xFF);
        data[2] = (byte)(value >> 8 & 0xFF);
    }

    private InputStream openInputStream(String filePath, String mimeType, int mbrSize, int types) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream((InputStream)is, mbrSize, types);
        }
        if (filePath.toLowerCase(Locale.US).endsWith("hex")) {
            return new HexInputStream(is, mbrSize);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream openInputStream(Uri stream, String mimeType, int mbrSize, int types) throws IOException {
        InputStream is = this.getContentResolver().openInputStream(stream);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream(is, mbrSize, types);
        }
        String[] projection = new String[]{"_display_name"};
        try (Cursor cursor = this.getContentResolver().query(stream, projection, null, null, null);){
            String fileName;
            if (cursor.moveToNext() && (fileName = cursor.getString(0)).toLowerCase(Locale.US).endsWith("hex")) {
                HexInputStream hexInputStream = new HexInputStream(is, mbrSize);
                return hexInputStream;
            }
        }
        return is;
    }

    private InputStream openInputStream(int resId, String mimeType, int mbrSize, int types) throws IOException {
        InputStream is = this.getResources().openRawResource(resId);
        if (MIME_TYPE_ZIP.equals(mimeType)) {
            return new ArchiveInputStream(is, mbrSize, types);
        }
        is.mark(2);
        int firstByte = is.read();
        is.reset();
        if (firstByte == 58) {
            return new HexInputStream(is, mbrSize);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BluetoothGatt connect(String address) {
        if (!this.mBluetoothAdapter.isEnabled()) {
            return null;
        }
        this.mConnectionState = -1;
        this.logi("Connecting to the device...");
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(address);
        this.sendLogBroadcast(0, "gatt = device.connectGatt(autoConnect = false)");
        BluetoothGatt gatt = device.connectGatt((Context)this, false, this.mGattCallback);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while ((this.mConnectionState == -1 || this.mConnectionState == -2) && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        return gatt;
    }

    private void terminateConnection(BluetoothGatt gatt, int error) {
        if (this.mConnectionState != 0) {
            this.disconnect(gatt);
        }
        this.refreshDeviceCache(gatt, false);
        this.close(gatt);
        this.updateProgressNotification(error);
    }

    private void disconnect(BluetoothGatt gatt) {
        if (this.mConnectionState == 0) {
            return;
        }
        this.sendLogBroadcast(1, "Disconnecting...");
        this.updateProgressNotification(-5);
        this.mConnectionState = -4;
        this.logi("Disconnecting from the device...");
        this.sendLogBroadcast(0, "gatt.disconnect()");
        gatt.disconnect();
        this.waitUntilDisconnected();
        this.sendLogBroadcast(5, "Disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDisconnected() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mConnectionState != 0 && this.mError == 0) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
    }

    private void close(BluetoothGatt gatt) {
        this.logi("Cleaning up...");
        this.sendLogBroadcast(0, "gatt.close()");
        gatt.close();
        this.mConnectionState = -5;
    }

    private void refreshDeviceCache(BluetoothGatt gatt, boolean force) {
        if (force || gatt.getDevice().getBondState() == 10) {
            this.sendLogBroadcast(0, "gatt.refresh() (hidden)");
            try {
                Method refresh = gatt.getClass().getMethod("refresh", new Class[0]);
                if (refresh != null) {
                    boolean success = (Boolean)refresh.invoke((Object)gatt, new Object[0]);
                    this.logi("Refreshing result: " + success);
                }
            }
            catch (Exception e) {
                this.loge("An exception occurred while refreshing device", e);
                this.sendLogBroadcast(15, "Refreshing failed");
            }
        }
    }

    private int getStatusCode(byte[] response, int request) throws UnknownResponseException {
        if (response == null || response.length != 3 || response[0] != 16 || response[1] != request || response[2] < 1 || response[2] > 6) {
            throw new UnknownResponseException("Invalid response received", response, request);
        }
        return response[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersion(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to read version number", this.mConnectionState);
        }
        if (characteristic == null) {
            return 0;
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.logi("Reading DFU version number...");
        this.sendLogBroadcast(1, "Reading DFU version number...");
        gatt.readCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to read version number", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to read version number", this.mConnectionState);
        }
        return characteristic.getIntValue(18, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCCCD(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int type) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        String debugString;
        String string2 = debugString = type == 1 ? "notifications" : "indications";
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state", this.mConnectionState);
        }
        this.mReceivedData = null;
        this.mError = 0;
        if (type == 1 && this.mNotificationsEnabled || type == 2 && this.mServiceChangedIndicationsEnabled) {
            return;
        }
        this.logi("Enabling " + debugString + "...");
        this.sendLogBroadcast(1, "Enabling " + debugString + " for " + characteristic.getUuid());
        gatt.setCharacteristicNotification(characteristic, true);
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        descriptor.setValue(type == 1 ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        this.sendLogBroadcast(0, "gatt.writeDescriptor(" + descriptor.getUuid() + (type == 1 ? ", value=0x01-00)" : ", value=0x02-00)"));
        gatt.writeDescriptor(descriptor);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while ((type == 1 && !this.mNotificationsEnabled || type == 2 && !this.mServiceChangedIndicationsEnabled) && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to set " + debugString + " state", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state", this.mConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServiceChangedCCCDEnabled(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD", this.mConnectionState);
        }
        if (characteristic == null) {
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        if (descriptor == null) {
            return false;
        }
        this.mRequestCompleted = false;
        this.mError = 0;
        this.logi("Reading Service Changed CCCD value...");
        this.sendLogBroadcast(1, "Reading Service Changed CCCD value...");
        gatt.readDescriptor(descriptor);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to read Service Changed CCCD", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD", this.mConnectionState);
        }
        return this.mServiceChangedIndicationsEnabled;
    }

    private void writeOpCode(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        boolean reset = value[0] == 6 || value[0] == 5;
        this.writeOpCode(gatt, characteristic, value, reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOpCode(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value, boolean reset) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        this.mRequestCompleted = false;
        this.mResetRequestSent = reset;
        characteristic.setValue(value);
        this.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        gatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (!this.mResetRequestSent && this.mError != 0) {
            throw new DfuException("Unable to write Op Code " + value[0], this.mError);
        }
        if (!this.mResetRequestSent && this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to write Op Code " + value[0], this.mConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageSize(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int imageSize) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        this.mImageSizeSent = false;
        characteristic.setWriteType(1);
        characteristic.setValue(new byte[4]);
        characteristic.setValue(imageSize, 20, 0);
        this.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        gatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mImageSizeSent && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Image Size", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to write Image Size", this.mConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageSize(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int softDeviceImageSize, int bootloaderImageSize, int appImageSize) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        this.mImageSizeSent = false;
        characteristic.setWriteType(1);
        characteristic.setValue(new byte[12]);
        characteristic.setValue(softDeviceImageSize, 20, 0);
        characteristic.setValue(bootloaderImageSize, 20, 4);
        characteristic.setValue(appImageSize, 20, 8);
        this.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        gatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mImageSizeSent && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Image Sizes", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to write Image Sizes", this.mConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInitPacket(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] buffer, int size) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        byte[] locBuffer = buffer;
        if (buffer.length != size) {
            locBuffer = new byte[size];
            System.arraycopy(buffer, 0, locBuffer, 0, size);
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.mInitPacketSent = false;
        characteristic.setWriteType(1);
        characteristic.setValue(locBuffer);
        this.logi("Sending init packet (Value = " + this.parse(locBuffer) + ")");
        this.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        gatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mInitPacketSent && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Init DFU Parameters", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to write Init DFU Parameters", this.mConnectionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] uploadFirmwareImage(BluetoothGatt gatt, BluetoothGattCharacteristic packetCharacteristic, InputStream inputStream) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        byte[] buffer = this.mBuffer;
        try {
            int size = inputStream.read(buffer);
            this.sendLogBroadcast(1, "Sending firmware to characteristic " + packetCharacteristic.getUuid() + "...");
            this.writePacket(gatt, packetCharacteristic, buffer, size);
        }
        catch (HexFileValidationException e) {
            throw new DfuException("HEX file not valid", 4099);
        }
        catch (IOException e) {
            throw new DfuException("Error while reading file", 4100);
        }
        try {
            Object e = this.mLock;
            synchronized (e) {
                while (this.mReceivedData == null && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Uploading Firmware Image failed", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Uploading Firmware Image failed: device disconnected", this.mConnectionState);
        }
        return this.mReceivedData;
    }

    private void writePacket(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] buffer, int size) {
        byte[] locBuffer = buffer;
        if (buffer.length != size) {
            locBuffer = new byte[size];
            System.arraycopy(buffer, 0, locBuffer, 0, size);
        }
        characteristic.setValue(locBuffer);
        gatt.writeCharacteristic(characteristic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfPaused() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                while (this.mPaused) {
                    this.mLock.wait();
                }
            }
            catch (InterruptedException e) {
                this.loge("Sleeping interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private boolean createBond(BluetoothDevice device) {
        boolean result;
        if (device.getBondState() == 12) {
            return true;
        }
        this.mRequestCompleted = false;
        this.sendLogBroadcast(1, "Starting pairing...");
        if (Build.VERSION.SDK_INT >= 19) {
            this.sendLogBroadcast(0, "gatt.getDevice().createBond()");
            result = device.createBond();
        } else {
            result = this.createBondApi18(device);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && !this.mAborted) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        return result;
    }

    private boolean createBondApi18(BluetoothDevice device) {
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            if (createBond != null) {
                this.sendLogBroadcast(0, "gatt.getDevice().createBond() (hidden)");
                return (Boolean)createBond.invoke((Object)device, new Object[0]);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while creating bond", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBond(BluetoothDevice device) {
        if (device.getBondState() == 10) {
            return true;
        }
        this.sendLogBroadcast(1, "Removing bond information...");
        boolean result = false;
        try {
            Method removeBond = device.getClass().getMethod("removeBond", new Class[0]);
            if (removeBond != null) {
                this.mRequestCompleted = false;
                this.sendLogBroadcast(0, "gatt.getDevice().removeBond() (hidden)");
                result = (Boolean)removeBond.invoke((Object)device, new Object[0]);
                try {
                    Object object = this.mLock;
                    synchronized (object) {
                        while (!this.mRequestCompleted && !this.mAborted) {
                            this.mLock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.loge("Sleeping interrupted", e);
                }
            }
            result = true;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while removing bond information", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readNotificationResponse() throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mError = 0;
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mReceivedData == null && this.mConnectionState == -3 && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Op Code", this.mError);
        }
        if (this.mConnectionState != -3) {
            throw new DeviceDisconnectedException("Unable to write Op Code", this.mConnectionState);
        }
        return this.mReceivedData;
    }

    private void updateProgressNotification() {
        int progress = (int)(100.0f * (float)this.mBytesSent / (float)this.mImageSizeInBytes);
        if (this.mLastProgress == progress) {
            return;
        }
        this.mLastProgress = progress;
        this.updateProgressNotification(progress);
    }

    private void updateProgressNotification(int progress) {
        if (progress < 4096) {
            this.sendProgressBroadcast(progress);
        } else {
            this.sendErrorBroadcast(progress);
        }
        if (this.mDisableNotification) {
            return;
        }
        String deviceAddress = this.mDeviceAddress;
        String deviceName = this.mDeviceName != null ? this.mDeviceName : this.getString(R.string.dfu_unknown_name);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this).setSmallIcon(0x1080088).setOnlyAlertOnce(true);
        builder.setColor(-7829368);
        switch (progress) {
            case -1: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_connecting)).setContentText((CharSequence)this.getString(R.string.dfu_status_connecting_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -2: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_starting)).setContentText((CharSequence)this.getString(R.string.dfu_status_starting_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -3: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_switching_to_dfu)).setContentText((CharSequence)this.getString(R.string.dfu_status_switching_to_dfu_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -4: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_validating)).setContentText((CharSequence)this.getString(R.string.dfu_status_validating_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -5: {
                builder.setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.dfu_status_disconnecting)).setContentText((CharSequence)this.getString(R.string.dfu_status_disconnecting_msg, new Object[]{deviceName})).setProgress(100, 0, true);
                break;
            }
            case -6: {
                builder.setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_completed)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_completed_msg)).setAutoCancel(true).setColor(-16730086);
                break;
            }
            case -7: {
                builder.setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_aborted)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_aborted_msg)).setAutoCancel(true);
                break;
            }
            default: {
                if (progress >= 4096) {
                    builder.setOngoing(false).setContentTitle((CharSequence)this.getString(R.string.dfu_status_error)).setSmallIcon(17301641).setContentText((CharSequence)this.getString(R.string.dfu_status_error_msg)).setAutoCancel(true).setColor(-65536);
                    break;
                }
                String title = this.mPartsTotal == 1 ? this.getString(R.string.dfu_status_uploading) : this.getString(R.string.dfu_status_uploading_part, new Object[]{this.mPartCurrent, this.mPartsTotal});
                String text = (this.mFileType & 4) > 0 ? this.getString(R.string.dfu_status_uploading_msg, new Object[]{deviceName}) : this.getString(R.string.dfu_status_uploading_components_msg, new Object[]{deviceName});
                builder.setOngoing(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setProgress(100, progress, false);
            }
        }
        Intent intent = new Intent((Context)this, this.getNotificationTarget());
        intent.addFlags(0x10000000);
        intent.putExtra(EXTRA_DEVICE_ADDRESS, deviceAddress);
        intent.putExtra(EXTRA_DEVICE_NAME, deviceName);
        intent.putExtra(EXTRA_PROGRESS, progress);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        builder.setContentIntent(pendingIntent);
        if (progress != -7 && progress != -6 && progress < 4096) {
            Intent abortIntent = new Intent(BROADCAST_ACTION);
            abortIntent.putExtra(EXTRA_ACTION, 2);
            PendingIntent pendingAbortIntent = PendingIntent.getBroadcast((Context)this, (int)1, (Intent)abortIntent, (int)0x8000000);
            builder.addAction(R.drawable.ic_action_notify_cancel, (CharSequence)this.getString(R.string.dfu_action_abort), pendingAbortIntent);
        }
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.notify(283, builder.build());
    }

    protected abstract Class<? extends Activity> getNotificationTarget();

    private void sendProgressBroadcast(int progress) {
        long now = SystemClock.elapsedRealtime();
        float speed = now - this.mLastProgressTime != 0L ? (float)(this.mBytesSent - this.mLastBytesSent) / (float)(now - this.mLastProgressTime) : 0.0f;
        float avgSpeed = now - this.mStartTime != 0L ? (float)this.mBytesSent / (float)(now - this.mStartTime) : 0.0f;
        this.mLastProgressTime = now;
        this.mLastBytesSent = this.mBytesSent;
        Intent broadcast = new Intent(BROADCAST_PROGRESS);
        broadcast.putExtra(EXTRA_DATA, progress);
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        broadcast.putExtra(EXTRA_PART_CURRENT, this.mPartCurrent);
        broadcast.putExtra(EXTRA_PARTS_TOTAL, this.mPartsTotal);
        broadcast.putExtra(EXTRA_SPEED_B_PER_MS, speed);
        broadcast.putExtra(EXTRA_AVG_SPEED_B_PER_MS, avgSpeed);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    private void sendErrorBroadcast(int error) {
        Intent broadcast = new Intent(BROADCAST_ERROR);
        if ((error & 0x4000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error & 0xFFFFBFFF);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 2);
        } else if ((error & 0x8000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error & 0xFFFF7FFF);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 1);
        } else if ((error & 0x2000) > 0) {
            broadcast.putExtra(EXTRA_DATA, error);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 3);
        } else {
            broadcast.putExtra(EXTRA_DATA, error);
            broadcast.putExtra(EXTRA_ERROR_TYPE, 0);
        }
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    private void sendLogBroadcast(int level, String message) {
        String fullMessage = "[DFU] " + message;
        Intent broadcast = new Intent(BROADCAST_LOG);
        broadcast.putExtra(EXTRA_LOG_MESSAGE, fullMessage);
        broadcast.putExtra(EXTRA_LOG_LEVEL, level);
        broadcast.putExtra(EXTRA_DEVICE_ADDRESS, this.mDeviceAddress);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(broadcast);
    }

    private boolean initialize() {
        BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            this.loge("Unable to initialize BluetoothManager.");
            return false;
        }
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            this.loge("Unable to obtain a BluetoothAdapter.");
            return false;
        }
        return true;
    }

    private void loge(String message) {
        Log.e((String)TAG, (String)message);
    }

    private void loge(String message, Throwable e) {
        Log.e((String)TAG, (String)message, (Throwable)e);
    }

    private void logw(String message) {
    }

    private void logi(String message) {
    }

    private void logd(String message) {
    }

    private String parse(byte[] data) {
        if (data == null) {
            return "";
        }
        int length = data.length;
        if (length == 0) {
            return "";
        }
        char[] out = new char[length * 3 - 1];
        for (int j = 0; j < length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return new String(out);
    }

    static /* synthetic */ byte[] access$3002(DfuBaseService x0, byte[] x1) {
        x0.mReceivedData = x1;
        return x1;
    }
}

