/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import java.util.HashMap;
import java.util.Map;
import no.nordicsemi.android.dfu.DfuLogListener;
import no.nordicsemi.android.dfu.DfuProgressListener;
import no.nordicsemi.android.error.GattError;

public class DfuServiceListenerHelper {
    private static LogBroadcastReceiver mLogBroadcastReceiver;
    private static ProgressBroadcastsReceiver mProgressBroadcastReceiver;

    public static void registerProgressListener(Context context, DfuProgressListener listener) {
        if (mProgressBroadcastReceiver == null) {
            mProgressBroadcastReceiver = new ProgressBroadcastsReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_PROGRESS");
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_ERROR");
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)mProgressBroadcastReceiver, filter);
        }
        DfuServiceListenerHelper.mProgressBroadcastReceiver.setProgressListener(listener);
    }

    public static void registerProgressListener(Context context, DfuProgressListener listener, String deviceAddress) {
        if (mProgressBroadcastReceiver == null) {
            mProgressBroadcastReceiver = new ProgressBroadcastsReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_PROGRESS");
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_ERROR");
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)mProgressBroadcastReceiver, filter);
        }
        DfuServiceListenerHelper.mProgressBroadcastReceiver.setProgressListener(deviceAddress, listener);
    }

    public static void unregisterProgressListener(Context context, DfuProgressListener listener) {
        boolean empty;
        if (mProgressBroadcastReceiver != null && (empty = DfuServiceListenerHelper.mProgressBroadcastReceiver.removeProgressListener(listener))) {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)mProgressBroadcastReceiver);
            mProgressBroadcastReceiver = null;
        }
    }

    public static void registerLogListener(Context context, DfuLogListener listener) {
        if (mLogBroadcastReceiver == null) {
            mLogBroadcastReceiver = new LogBroadcastReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_LOG");
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)mLogBroadcastReceiver, filter);
        }
        DfuServiceListenerHelper.mLogBroadcastReceiver.setLogListener(listener);
    }

    public static void registerLogListener(Context context, DfuLogListener listener, String deviceAddress) {
        if (mLogBroadcastReceiver == null) {
            mLogBroadcastReceiver = new LogBroadcastReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("no.nordicsemi.android.dfu.broadcast.BROADCAST_LOG");
            LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)mLogBroadcastReceiver, filter);
        }
        DfuServiceListenerHelper.mLogBroadcastReceiver.setLogListener(deviceAddress, listener);
    }

    public static void unregisterLogListener(Context context, DfuLogListener listener) {
        boolean empty;
        if (mLogBroadcastReceiver != null && (empty = DfuServiceListenerHelper.mLogBroadcastReceiver.removeLogListener(listener))) {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)mLogBroadcastReceiver);
            mLogBroadcastReceiver = null;
        }
    }

    private static String getIncrementedAddress(String deviceAddress) {
        String firstBytes = deviceAddress.substring(0, 15);
        String lastByte = deviceAddress.substring(15);
        String lastByteIncremented = String.format("%02X", Integer.valueOf(lastByte, 16) + 1 & 0xFF);
        return firstBytes + lastByteIncremented;
    }

    private static class ProgressBroadcastsReceiver
    extends BroadcastReceiver {
        private DfuProgressListener mGlobalProgressListener;
        private Map<String, DfuProgressListener> mListeners = new HashMap<String, DfuProgressListener>();

        private ProgressBroadcastsReceiver() {
        }

        private void setProgressListener(DfuProgressListener globalProgressListener) {
            this.mGlobalProgressListener = globalProgressListener;
        }

        private void setProgressListener(String deviceAddress, DfuProgressListener listener) {
            this.mListeners.put(deviceAddress, listener);
            this.mListeners.put(DfuServiceListenerHelper.getIncrementedAddress(deviceAddress), listener);
        }

        private boolean removeProgressListener(DfuProgressListener listener) {
            if (this.mGlobalProgressListener == listener) {
                this.mGlobalProgressListener = null;
            }
            for (Map.Entry<String, DfuProgressListener> entry : this.mListeners.entrySet()) {
                if (entry.getValue() != listener) continue;
                this.mListeners.remove(entry.getKey());
                break;
            }
            for (Map.Entry<String, DfuProgressListener> entry : this.mListeners.entrySet()) {
                if (entry.getValue() != listener) continue;
                this.mListeners.remove(entry.getKey());
                break;
            }
            return this.mGlobalProgressListener == null && this.mListeners.isEmpty();
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            String address = intent.getStringExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS");
            DfuProgressListener globalListener = this.mGlobalProgressListener;
            DfuProgressListener deviceListener = this.mListeners.get(address);
            if (globalListener == null && deviceListener == null) {
                return;
            }
            block4 : switch (action = intent.getAction()) {
                case "no.nordicsemi.android.dfu.broadcast.BROADCAST_PROGRESS": {
                    int progress = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_DATA", 0);
                    float speed = intent.getFloatExtra("no.nordicsemi.android.dfu.extra.EXTRA_SPEED_B_PER_MS", 0.0f);
                    float avgSpeed = intent.getFloatExtra("no.nordicsemi.android.dfu.extra.EXTRA_AVG_SPEED_B_PER_MS", 0.0f);
                    int currentPart = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT", 0);
                    int partsTotal = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL", 0);
                    switch (progress) {
                        case -1: {
                            if (globalListener != null) {
                                globalListener.onDeviceConnecting(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onDeviceConnecting(address);
                            break block4;
                        }
                        case -2: {
                            if (globalListener != null) {
                                globalListener.onDeviceConnected(address);
                                globalListener.onDfuProcessStarting(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onDeviceConnected(address);
                            deviceListener.onDfuProcessStarting(address);
                            break block4;
                        }
                        case -3: {
                            if (globalListener != null) {
                                globalListener.onEnablingDfuMode(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onEnablingDfuMode(address);
                            break block4;
                        }
                        case -4: {
                            if (globalListener != null) {
                                globalListener.onFirmwareValidating(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onFirmwareValidating(address);
                            break block4;
                        }
                        case -5: {
                            if (globalListener != null) {
                                globalListener.onDeviceDisconnecting(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onDeviceDisconnecting(address);
                            break block4;
                        }
                        case -6: {
                            if (globalListener != null) {
                                globalListener.onDeviceDisconnected(address);
                                globalListener.onDfuCompleted(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onDeviceDisconnected(address);
                            deviceListener.onDfuCompleted(address);
                            break block4;
                        }
                        case -7: {
                            if (globalListener != null) {
                                globalListener.onDeviceDisconnected(address);
                                globalListener.onDfuAborted(address);
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onDeviceDisconnected(address);
                            deviceListener.onDfuAborted(address);
                            break block4;
                        }
                    }
                    if (progress == 0) {
                        if (globalListener != null) {
                            globalListener.onDfuProcessStarted(address);
                        }
                        if (deviceListener != null) {
                            deviceListener.onDfuProcessStarted(address);
                        }
                    }
                    if (globalListener != null) {
                        globalListener.onProgressChanged(address, progress, speed, avgSpeed, currentPart, partsTotal);
                    }
                    if (deviceListener == null) break;
                    deviceListener.onProgressChanged(address, progress, speed, avgSpeed, currentPart, partsTotal);
                    break;
                }
                case "no.nordicsemi.android.dfu.broadcast.BROADCAST_ERROR": {
                    int error = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_DATA", 0);
                    int errorType = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_ERROR_TYPE", 0);
                    if (globalListener != null) {
                        globalListener.onDeviceDisconnected(address);
                    }
                    if (deviceListener != null) {
                        deviceListener.onDeviceDisconnected(address);
                    }
                    switch (errorType) {
                        case 1: {
                            if (globalListener != null) {
                                globalListener.onError(address, error, errorType, GattError.parseConnectionError(error));
                            }
                            if (deviceListener == null) break block4;
                            deviceListener.onError(address, error, errorType, GattError.parseConnectionError(error));
                            break block4;
                        }
                    }
                    if (globalListener != null) {
                        globalListener.onError(address, error, errorType, GattError.parse(error));
                    }
                    if (deviceListener == null) break;
                    deviceListener.onError(address, error, errorType, GattError.parse(error));
                }
            }
        }
    }

    private static class LogBroadcastReceiver
    extends BroadcastReceiver {
        private DfuLogListener mGlobalLogListener;
        private Map<String, DfuLogListener> mListeners = new HashMap<String, DfuLogListener>();

        private LogBroadcastReceiver() {
        }

        private void setLogListener(DfuLogListener globalLogListener) {
            this.mGlobalLogListener = globalLogListener;
        }

        private void setLogListener(String deviceAddress, DfuLogListener listener) {
            this.mListeners.put(deviceAddress, listener);
            this.mListeners.put(DfuServiceListenerHelper.getIncrementedAddress(deviceAddress), listener);
        }

        private boolean removeLogListener(DfuLogListener listener) {
            if (this.mGlobalLogListener == listener) {
                this.mGlobalLogListener = null;
            }
            for (Map.Entry<String, DfuLogListener> entry : this.mListeners.entrySet()) {
                if (entry.getValue() != listener) continue;
                this.mListeners.remove(entry.getKey());
                break;
            }
            for (Map.Entry<String, DfuLogListener> entry : this.mListeners.entrySet()) {
                if (entry.getValue() != listener) continue;
                this.mListeners.remove(entry.getKey());
                break;
            }
            return this.mGlobalLogListener == null && this.mListeners.isEmpty();
        }

        public void onReceive(Context context, Intent intent) {
            String address = intent.getStringExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS");
            DfuLogListener globalListener = this.mGlobalLogListener;
            DfuLogListener deviceListener = this.mListeners.get(address);
            if (globalListener == null && deviceListener == null) {
                return;
            }
            int level = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_LOG_LEVEL", 0);
            String message = intent.getStringExtra("no.nordicsemi.android.dfu.extra.EXTRA_LOG_INFO");
            if (globalListener != null) {
                globalListener.onLogEvent(address, level, message);
            }
            if (deviceListener != null) {
                deviceListener.onLogEvent(address, level, message);
            }
        }
    }
}

