/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import no.nordicsemi.android.dfu.internal.HexInputStream;
import no.nordicsemi.android.dfu.internal.manifest.FileInfo;
import no.nordicsemi.android.dfu.internal.manifest.Manifest;
import no.nordicsemi.android.dfu.internal.manifest.ManifestFile;
import no.nordicsemi.android.dfu.internal.manifest.SoftDeviceBootloaderFileInfo;

public class ArchiveInputStream
extends ZipInputStream {
    private static final String MANIFEST = "manifest.json";
    private static final String SOFTDEVICE_HEX = "softdevice.hex";
    private static final String SOFTDEVICE_BIN = "softdevice.bin";
    private static final String BOOTLOADER_HEX = "bootloader.hex";
    private static final String BOOTLOADER_BIN = "bootloader.bin";
    private static final String APPLICATION_HEX = "application.hex";
    private static final String APPLICATION_BIN = "application.bin";
    private static final String SYSTEM_INIT = "system.dat";
    private static final String APPLICATION_INIT = "application.dat";
    private Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private Manifest manifest;
    private byte[] applicationBytes;
    private byte[] softDeviceBytes;
    private byte[] bootloaderBytes;
    private byte[] softDeviceAndBootloaderBytes;
    private byte[] systemInitBytes;
    private byte[] applicationInitBytes;
    private byte[] currentSource;
    private int bytesReadFromCurrentSource = 0;
    private int softDeviceSize;
    private int bootloaderSize;
    private int applicationSize;
    private int bytesRead = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveInputStream(InputStream stream, int mbrSize, int types) throws IOException {
        super(stream);
        try {
            this.parseZip(mbrSize);
            if (this.manifest != null) {
                boolean valid = false;
                if (this.manifest.getApplicationInfo() != null && (types == 0 || (types & 4) > 0)) {
                    FileInfo application = this.manifest.getApplicationInfo();
                    this.applicationBytes = this.entries.get(application.getBinFileName());
                    this.applicationInitBytes = this.entries.get(application.getDatFileName());
                    if (this.applicationBytes == null) {
                        throw new IOException("Application file " + application.getBinFileName() + " not found.");
                    }
                    this.applicationSize = this.applicationBytes.length;
                    this.currentSource = this.applicationBytes;
                    valid = true;
                }
                if (this.manifest.getBootloaderInfo() != null && (types == 0 || (types & 2) > 0)) {
                    if (this.systemInitBytes != null) {
                        throw new IOException("Manifest: softdevice and bootloader specified. Use softdevice_bootloader instead.");
                    }
                    FileInfo bootloader = this.manifest.getBootloaderInfo();
                    this.bootloaderBytes = this.entries.get(bootloader.getBinFileName());
                    this.systemInitBytes = this.entries.get(bootloader.getDatFileName());
                    if (this.bootloaderBytes == null) {
                        throw new IOException("Bootloader file " + bootloader.getBinFileName() + " not found.");
                    }
                    this.bootloaderSize = this.bootloaderBytes.length;
                    this.currentSource = this.bootloaderBytes;
                    valid = true;
                }
                if (this.manifest.getSoftdeviceInfo() != null && (types == 0 || (types & 1) > 0)) {
                    FileInfo softdevice = this.manifest.getSoftdeviceInfo();
                    this.softDeviceBytes = this.entries.get(softdevice.getBinFileName());
                    this.systemInitBytes = this.entries.get(softdevice.getDatFileName());
                    if (this.softDeviceBytes == null) {
                        throw new IOException("SoftDevice file " + softdevice.getBinFileName() + " not found.");
                    }
                    this.softDeviceSize = this.softDeviceBytes.length;
                    this.currentSource = this.softDeviceBytes;
                    valid = true;
                }
                if (this.manifest.getSoftdeviceBootloaderInfo() != null && (types == 0 || (types & 1) > 0 && (types & 2) > 0)) {
                    if (this.systemInitBytes != null) {
                        throw new IOException("Manifest: The softdevice_bootloader may not be used together with softdevice or bootloader.");
                    }
                    SoftDeviceBootloaderFileInfo system = this.manifest.getSoftdeviceBootloaderInfo();
                    this.softDeviceAndBootloaderBytes = this.entries.get(system.getBinFileName());
                    this.systemInitBytes = this.entries.get(system.getDatFileName());
                    if (this.softDeviceAndBootloaderBytes == null) {
                        throw new IOException("File " + system.getBinFileName() + " not found.");
                    }
                    this.softDeviceSize = system.getSoftdeviceSize();
                    this.bootloaderSize = system.getBootloaderSize();
                    this.currentSource = this.softDeviceAndBootloaderBytes;
                    valid = true;
                }
                if (!valid) {
                    throw new IOException("Manifest file must specify at least one file.");
                }
            } else {
                boolean valid = false;
                if (types == 0 || (types & 4) > 0) {
                    this.applicationBytes = this.entries.get(APPLICATION_HEX);
                    if (this.applicationBytes == null) {
                        this.applicationBytes = this.entries.get(APPLICATION_BIN);
                    }
                    if (this.applicationBytes != null) {
                        this.applicationSize = this.applicationBytes.length;
                        this.applicationInitBytes = this.entries.get(APPLICATION_INIT);
                        this.currentSource = this.applicationBytes;
                        valid = true;
                    }
                }
                if (types == 0 || (types & 2) > 0) {
                    this.bootloaderBytes = this.entries.get(BOOTLOADER_HEX);
                    if (this.bootloaderBytes == null) {
                        this.bootloaderBytes = this.entries.get(BOOTLOADER_BIN);
                    }
                    if (this.bootloaderBytes != null) {
                        this.bootloaderSize = this.bootloaderBytes.length;
                        this.systemInitBytes = this.entries.get(SYSTEM_INIT);
                        this.currentSource = this.bootloaderBytes;
                        valid = true;
                    }
                }
                if (types == 0 || (types & 1) > 0) {
                    this.softDeviceBytes = this.entries.get(SOFTDEVICE_HEX);
                    if (this.softDeviceBytes == null) {
                        this.softDeviceBytes = this.entries.get(SOFTDEVICE_BIN);
                    }
                    if (this.softDeviceBytes != null) {
                        this.softDeviceSize = this.softDeviceBytes.length;
                        this.systemInitBytes = this.entries.get(SYSTEM_INIT);
                        this.currentSource = this.softDeviceBytes;
                        valid = true;
                    }
                }
                if (!valid) {
                    throw new IOException("The ZIP file must contain an Application, a Soft Device and/or a Bootloader.");
                }
            }
        }
        finally {
            super.close();
        }
    }

    private void parseZip(int mbrSize) throws IOException {
        ZipEntry ze;
        byte[] buffer = new byte[1024];
        String manifestData = null;
        while ((ze = this.getNextEntry()) != null) {
            int count;
            String filename = ze.getName();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = super.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
            byte[] source = baos.toByteArray();
            if (filename.toLowerCase(Locale.US).endsWith("hex")) {
                HexInputStream is = new HexInputStream(source, mbrSize);
                source = new byte[is.available()];
                is.read(source);
                is.close();
            }
            if (MANIFEST.equals(filename)) {
                manifestData = new String(source, "UTF-8");
                continue;
            }
            this.entries.put(filename, source);
        }
        if (manifestData != null) {
            ManifestFile manifestFile = (ManifestFile)new Gson().fromJson(manifestData, ManifestFile.class);
            this.manifest = manifestFile.getManifest();
        }
    }

    @Override
    public void close() throws IOException {
        this.softDeviceBytes = null;
        this.bootloaderBytes = null;
        this.softDeviceBytes = null;
        this.softDeviceAndBootloaderBytes = null;
        this.applicationSize = 0;
        this.bootloaderSize = 0;
        this.softDeviceSize = 0;
        this.currentSource = null;
        this.bytesReadFromCurrentSource = 0;
        this.bytesRead = 0;
        super.close();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int maxSize = this.currentSource.length - this.bytesReadFromCurrentSource;
        int size = buffer.length <= maxSize ? buffer.length : maxSize;
        System.arraycopy(this.currentSource, this.bytesReadFromCurrentSource, buffer, 0, size);
        this.bytesReadFromCurrentSource += size;
        if (buffer.length > size) {
            if (this.startNextFile() == null) {
                this.bytesRead += size;
                return size;
            }
            maxSize = this.currentSource.length;
            int nextSize = buffer.length - size <= maxSize ? buffer.length - size : maxSize;
            System.arraycopy(this.currentSource, 0, buffer, size, nextSize);
            this.bytesReadFromCurrentSource += nextSize;
            size += nextSize;
        }
        this.bytesRead += size;
        return size;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public int getContentType() {
        byte b = 0;
        if (this.softDeviceSize > 0) {
            b = (byte)(b | 1);
        }
        if (this.bootloaderSize > 0) {
            b = (byte)(b | 2);
        }
        if (this.applicationSize > 0) {
            b = (byte)(b | 4);
        }
        return b;
    }

    public int setContentType(int type) {
        if (this.bytesRead > 0) {
            throw new UnsupportedOperationException("Content type must not be change after reading content");
        }
        int t = this.getContentType() & type;
        if ((t & 1) == 0) {
            this.softDeviceBytes = null;
            if (this.softDeviceAndBootloaderBytes != null) {
                this.softDeviceAndBootloaderBytes = null;
                this.bootloaderSize = 0;
            }
            this.softDeviceSize = 0;
        }
        if ((t & 2) == 0) {
            this.bootloaderBytes = null;
            if (this.softDeviceAndBootloaderBytes != null) {
                this.softDeviceAndBootloaderBytes = null;
                this.softDeviceSize = 0;
            }
            this.bootloaderSize = 0;
        }
        if ((t & 4) == 0) {
            this.applicationBytes = null;
            this.applicationSize = 0;
        }
        return t;
    }

    private byte[] startNextFile() {
        byte[] ret;
        if (this.currentSource == this.softDeviceBytes && this.bootloaderBytes != null) {
            this.currentSource = this.bootloaderBytes;
            ret = this.bootloaderBytes;
        } else if (this.currentSource != this.applicationBytes && this.applicationBytes != null) {
            this.currentSource = this.applicationBytes;
            ret = this.applicationBytes;
        } else {
            this.currentSource = null;
            ret = null;
        }
        this.bytesReadFromCurrentSource = 0;
        return ret;
    }

    @Override
    public int available() {
        return this.softDeviceSize + this.bootloaderSize + this.applicationSize - this.bytesRead;
    }

    public int softDeviceImageSize() {
        return this.softDeviceSize;
    }

    public int bootloaderImageSize() {
        return this.bootloaderSize;
    }

    public int applicationImageSize() {
        return this.applicationSize;
    }

    public byte[] getSystemInit() {
        return this.systemInitBytes;
    }

    public byte[] getApplicationInit() {
        return this.applicationInitBytes;
    }
}

