/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import no.nordicsemi.android.dfu.internal.exception.HexFileValidationException;

public class HexInputStream
extends FilterInputStream {
    private final int LINE_LENGTH = 128;
    private final byte[] localBuf = new byte[128];
    private int localPos = 128;
    private int pos;
    private int size = this.localBuf.length;
    private int lastAddress = 0;
    private int available;
    private int bytesRead;
    private final int MBRSize;

    public HexInputStream(InputStream in, int mbrSize) throws HexFileValidationException, IOException {
        super(new BufferedInputStream(in));
        this.MBRSize = mbrSize;
        this.available = this.calculateBinSize(mbrSize);
    }

    public HexInputStream(byte[] data, int mbrSize) throws HexFileValidationException, IOException {
        super(new ByteArrayInputStream(data));
        this.MBRSize = mbrSize;
        this.available = this.calculateBinSize(mbrSize);
    }

    private int calculateBinSize(int mbrSize) throws IOException {
        int binSize = 0;
        InputStream in = this.in;
        in.mark(in.available());
        int lastBaseAddress = 0;
        try {
            int b = in.read();
            while (true) {
                this.checkComma(b);
                int lineSize = this.readByte(in);
                int offset = this.readAddress(in);
                int type = this.readByte(in);
                switch (type) {
                    case 1: {
                        int n = binSize;
                        return n;
                    }
                    case 4: {
                        int newULBA = this.readAddress(in);
                        if (binSize > 0 && newULBA != (lastBaseAddress >> 16) + 1) {
                            int n = binSize;
                            return n;
                        }
                        lastBaseAddress = newULBA << 16;
                        in.skip(2L);
                        break;
                    }
                    case 2: {
                        int newSBA = this.readAddress(in) << 4;
                        if (binSize > 0 && newSBA >> 16 != (lastBaseAddress >> 16) + 1) {
                            int n = binSize;
                            return n;
                        }
                        lastBaseAddress = newSBA;
                        in.skip(2L);
                        break;
                    }
                    case 0: {
                        int lastAddress = lastBaseAddress + offset;
                        if (lastAddress >= mbrSize) {
                            binSize += lineSize;
                        }
                    }
                    default: {
                        in.skip(lineSize * 2 + 2);
                    }
                }
                while ((b = in.read()) == 10 || b == 13) {
                }
            }
        }
        finally {
            in.reset();
        }
    }

    @Override
    public int available() {
        return this.available - this.bytesRead;
    }

    public int readPacket(byte[] buffer) throws HexFileValidationException, IOException {
        int i = 0;
        while (i < buffer.length) {
            if (this.localPos < this.size) {
                buffer[i++] = this.localBuf[this.localPos++];
                continue;
            }
            this.size = this.readLine();
            this.bytesRead += this.size;
            if (this.size != 0) continue;
            break;
        }
        return i;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Please, use readPacket() method instead");
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.readPacket(buffer);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        throw new UnsupportedOperationException("Please, use readPacket() method instead");
    }

    public int sizeInBytes() {
        return this.available;
    }

    public int sizeInPackets(int packetSize) throws IOException {
        int sizeInBytes = this.sizeInBytes();
        return sizeInBytes / packetSize + (sizeInBytes % packetSize > 0 ? 1 : 0);
    }

    private int readLine() throws IOException {
        int lineSize;
        int b;
        if (this.pos == -1) {
            return 0;
        }
        InputStream in = this.in;
        while (true) {
            b = in.read();
            ++this.pos;
            if (b == 10 || b == 13) continue;
            this.checkComma(b);
            lineSize = this.readByte(in);
            this.pos += 2;
            int offset = this.readAddress(in);
            this.pos += 4;
            int type = this.readByte(in);
            this.pos += 2;
            switch (type) {
                case 0: {
                    if (this.lastAddress + offset >= this.MBRSize) break;
                    type = -1;
                    this.pos = (int)((long)this.pos + in.skip(lineSize * 2 + 2));
                    break;
                }
                case 1: {
                    this.pos = -1;
                    return 0;
                }
                case 2: {
                    int address = this.readAddress(in) << 4;
                    this.pos += 4;
                    if (this.bytesRead > 0 && address >> 16 != (this.lastAddress >> 16) + 1) {
                        return 0;
                    }
                    this.lastAddress = address;
                    this.pos = (int)((long)this.pos + in.skip(2L));
                    break;
                }
                case 4: {
                    int address = this.readAddress(in);
                    this.pos += 4;
                    if (this.bytesRead > 0 && address != (this.lastAddress >> 16) + 1) {
                        return 0;
                    }
                    this.lastAddress = address << 16;
                    this.pos = (int)((long)this.pos + in.skip(2L));
                    break;
                }
                default: {
                    this.pos = (int)((long)this.pos + in.skip(lineSize * 2 + 2));
                }
            }
            if (type == 0) break;
        }
        for (int i = 0; i < this.localBuf.length && i < lineSize; ++i) {
            b = this.readByte(in);
            this.pos += 2;
            this.localBuf[i] = (byte)b;
        }
        this.pos = (int)((long)this.pos + in.skip(2L));
        this.localPos = 0;
        return lineSize;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.pos = 0;
        this.bytesRead = 0;
        this.localPos = 0;
    }

    private void checkComma(int comma) throws HexFileValidationException {
        if (comma != 58) {
            throw new HexFileValidationException("Not a HEX file");
        }
    }

    private int readByte(InputStream in) throws IOException {
        int first = this.asciiToInt(in.read());
        int second = this.asciiToInt(in.read());
        return first << 4 | second;
    }

    private int readAddress(InputStream in) throws IOException {
        return this.readByte(in) << 8 | this.readByte(in);
    }

    private int asciiToInt(int ascii) {
        if (ascii >= 65) {
            return ascii - 55;
        }
        if (ascii >= 48) {
            return ascii - 48;
        }
        return -1;
    }
}

