/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal.exception;

public class UnknownResponseException
extends Exception {
    private static final long serialVersionUID = -8716125467309979289L;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] mResponse;
    private final int mExpectedOpCode;

    public UnknownResponseException(String message, byte[] response, int expectedOpCode) {
        super(message);
        this.mResponse = response != null ? response : new byte[]{};
        this.mExpectedOpCode = expectedOpCode;
    }

    @Override
    public String getMessage() {
        return String.format("%s (response: %s, expected: 0x10%02X..)", super.getMessage(), UnknownResponseException.bytesToHex(this.mResponse, 0, this.mResponse.length), this.mExpectedOpCode);
    }

    public static String bytesToHex(byte[] bytes, int start, int length) {
        if (bytes == null || bytes.length <= start || length <= 0) {
            return "";
        }
        int maxLength = Math.min(length, bytes.length - start);
        char[] hexChars = new char[maxLength * 2];
        for (int j = 0; j < maxLength; ++j) {
            int v = bytes[start + j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return "0x" + new String(hexChars);
    }
}

