/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.UUID;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.DfuProgressInfo;
import no.nordicsemi.android.dfu.DfuService;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

abstract class BaseDfuImpl
implements DfuService {
    private static final String TAG = "DfuImpl";
    protected static final UUID GENERIC_ATTRIBUTE_SERVICE_UUID = new UUID(0x180100001000L, -9223371485494954757L);
    protected static final UUID SERVICE_CHANGED_UUID = new UUID(46200963207168L, -9223371485494954757L);
    protected static final UUID CLIENT_CHARACTERISTIC_CONFIG = new UUID(45088566677504L, -9223371485494954757L);
    protected static final int NOTIFICATIONS = 1;
    protected static final int INDICATIONS = 2;
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    protected static final int MAX_PACKET_SIZE = 20;
    protected final Object mLock = new Object();
    protected InputStream mFirmwareStream;
    protected InputStream mInitPacketStream;
    protected BluetoothGatt mGatt;
    protected int mFileType;
    protected boolean mPaused;
    protected boolean mAborted;
    protected boolean mConnected;
    protected boolean mRequestCompleted;
    protected boolean mResetRequestSent;
    protected int mError;
    protected byte[] mReceivedData = null;
    protected final byte[] mBuffer = new byte[20];
    protected DfuBaseService mService;
    protected DfuProgressInfo mProgressInfo;
    protected int mImageSizeInBytes;
    protected int mInitPacketSizeInBytes;

    BaseDfuImpl(Intent intent, DfuBaseService service) {
        this.mService = service;
        this.mConnected = true;
    }

    @Override
    public void release() {
        this.mService = null;
    }

    @Override
    public void pause() {
        this.mPaused = true;
    }

    @Override
    public void resume() {
        this.mPaused = false;
        this.notifyLock();
    }

    @Override
    public void abort() {
        this.mPaused = false;
        this.mAborted = true;
        this.notifyLock();
    }

    @Override
    public void onBondStateChanged(int state) {
        this.mRequestCompleted = true;
        this.notifyLock();
    }

    @Override
    public boolean initialize(Intent intent, BluetoothGatt gatt, int fileType, InputStream firmwareStream, InputStream initPacketStream) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        BluetoothGattCharacteristic serviceChangedCharacteristic;
        BluetoothGattService genericAttributeService;
        int size;
        this.mGatt = gatt;
        this.mFileType = fileType;
        this.mFirmwareStream = firmwareStream;
        this.mInitPacketStream = initPacketStream;
        int currentPart = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PART_CURRENT", 1);
        int totalParts = intent.getIntExtra("no.nordicsemi.android.dfu.extra.EXTRA_PARTS_TOTAL", 1);
        if (fileType > 4) {
            this.logw("DFU target does not support (SD/BL)+App update, splitting into 2 parts");
            this.mService.sendLogBroadcast(15, "Sending system components");
            this.mFileType &= 0xFFFFFFFB;
            totalParts = 2;
            ArchiveInputStream zhis = (ArchiveInputStream)this.mFirmwareStream;
            zhis.setContentType(this.mFileType);
        }
        if (currentPart == 2) {
            this.mService.sendLogBroadcast(15, "Sending application");
        }
        try {
            size = initPacketStream.available();
        }
        catch (Exception e) {
            size = 0;
        }
        this.mInitPacketSizeInBytes = size;
        try {
            size = firmwareStream.available();
        }
        catch (Exception e) {
            size = 0;
        }
        this.mImageSizeInBytes = size;
        this.mProgressInfo = this.mService.mProgressInfo.init(size, currentPart, totalParts);
        if (Build.VERSION.SDK_INT < 23 && gatt.getDevice().getBondState() == 12 && (genericAttributeService = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID)) != null && (serviceChangedCharacteristic = genericAttributeService.getCharacteristic(SERVICE_CHANGED_UUID)) != null) {
            boolean serviceChangedIndicationsEnabled = this.isServiceChangedCCCDEnabled();
            if (!serviceChangedIndicationsEnabled) {
                this.enableCCCD(serviceChangedCharacteristic, 2);
                this.mService.sendLogBroadcast(10, "Service Changed indications enabled");
                boolean keepBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", false);
                if (keepBond && (this.mFileType & 1) == 0) {
                    this.mService.sendLogBroadcast(1, "Restarting service...");
                    this.mService.disconnect(gatt);
                    this.mService.close(gatt);
                    this.logi("Restarting service");
                    this.mService.sendLogBroadcast(1, "Restarting service...");
                    Intent newIntent = new Intent();
                    newIntent.fillIn(intent, 24);
                    this.mService.startService(newIntent);
                    return false;
                }
            } else {
                this.mService.sendLogBroadcast(10, "Service Changed indications enabled");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLock() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitIfPaused() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
    }

    protected abstract BaseBluetoothGattCallback getGattCallback();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableCCCD(BluetoothGattCharacteristic characteristic, int type) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        boolean cccdEnabled;
        String debugString;
        BluetoothGatt gatt = this.mGatt;
        String string2 = debugString = type == 1 ? "notifications" : "indications";
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state: device disconnected");
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mReceivedData = null;
        this.mError = 0;
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        boolean bl = cccdEnabled = descriptor.getValue() != null && descriptor.getValue().length == 2 && descriptor.getValue()[0] > 0 && descriptor.getValue()[1] == 0;
        if (cccdEnabled) {
            return;
        }
        this.logi("Enabling " + debugString + "...");
        this.mService.sendLogBroadcast(1, "Enabling " + debugString + " for " + characteristic.getUuid());
        this.mService.sendLogBroadcast(0, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
        gatt.setCharacteristicNotification(characteristic, true);
        descriptor.setValue(type == 1 ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        this.mService.sendLogBroadcast(0, "gatt.writeDescriptor(" + descriptor.getUuid() + (type == 1 ? ", value=0x01-00)" : ", value=0x02-00)"));
        gatt.writeDescriptor(descriptor);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!cccdEnabled && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                    cccdEnabled = descriptor.getValue() != null && descriptor.getValue().length == 2 && descriptor.getValue()[0] > 0 && descriptor.getValue()[1] == 0;
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to set " + debugString + " state", this.mError);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to set " + debugString + " state: device disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServiceChangedCCCDEnabled() throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD: device disconnected");
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        BluetoothGatt gatt = this.mGatt;
        BluetoothGattService genericAttributeService = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID);
        if (genericAttributeService == null) {
            return false;
        }
        BluetoothGattCharacteristic serviceChangedCharacteristic = genericAttributeService.getCharacteristic(SERVICE_CHANGED_UUID);
        if (serviceChangedCharacteristic == null) {
            return false;
        }
        BluetoothGattDescriptor descriptor = serviceChangedCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG);
        if (descriptor == null) {
            return false;
        }
        this.mRequestCompleted = false;
        this.mError = 0;
        this.logi("Reading Service Changed CCCD value...");
        this.mService.sendLogBroadcast(1, "Reading Service Changed CCCD value...");
        this.mService.sendLogBroadcast(0, "gatt.readDescriptor(" + descriptor.getUuid() + ")");
        gatt.readDescriptor(descriptor);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to read Service Changed CCCD", this.mError);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read Service Changed CCCD: device disconnected");
        }
        return descriptor.getValue() != null && descriptor.getValue().length == 2 && descriptor.getValue()[0] == BluetoothGattDescriptor.ENABLE_INDICATION_VALUE[0] && descriptor.getValue()[1] == BluetoothGattDescriptor.ENABLE_INDICATION_VALUE[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOpCode(BluetoothGattCharacteristic characteristic, byte[] value, boolean reset) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.mRequestCompleted = false;
        this.mResetRequestSent = reset;
        characteristic.setWriteType(2);
        characteristic.setValue(value);
        this.mService.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        this.mGatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && this.mConnected && this.mError == 0 || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (!this.mResetRequestSent && this.mError != 0) {
            throw new DfuException("Unable to write Op Code " + value[0], this.mError);
        }
        if (!this.mResetRequestSent && !this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Op Code " + value[0] + ": device disconnected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    protected boolean createBond() {
        boolean result;
        BluetoothDevice device = this.mGatt.getDevice();
        if (device.getBondState() == 12) {
            return true;
        }
        this.mRequestCompleted = false;
        this.mService.sendLogBroadcast(1, "Starting pairing...");
        if (Build.VERSION.SDK_INT >= 19) {
            this.mService.sendLogBroadcast(0, "gatt.getDevice().createBond()");
            result = device.createBond();
        } else {
            result = this.createBondApi18(device);
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (!this.mRequestCompleted && !this.mAborted) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        return result;
    }

    private boolean createBondApi18(BluetoothDevice device) {
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            if (createBond != null) {
                this.mService.sendLogBroadcast(0, "gatt.getDevice().createBond() (hidden)");
                return (Boolean)createBond.invoke((Object)device, new Object[0]);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while creating bond", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBond() {
        BluetoothDevice device = this.mGatt.getDevice();
        if (device.getBondState() == 10) {
            return true;
        }
        this.mService.sendLogBroadcast(1, "Removing bond information...");
        boolean result = false;
        try {
            Method removeBond = device.getClass().getMethod("removeBond", new Class[0]);
            if (removeBond != null) {
                this.mRequestCompleted = false;
                this.mService.sendLogBroadcast(0, "gatt.getDevice().removeBond() (hidden)");
                result = (Boolean)removeBond.invoke((Object)device, new Object[0]);
                try {
                    Object object = this.mLock;
                    synchronized (object) {
                        while (!this.mRequestCompleted && !this.mAborted) {
                            this.mLock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.loge("Sleeping interrupted", e);
                }
            }
            result = true;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while removing bond information", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readNotificationResponse() throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mReceivedData == null && this.mConnected && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Op Code", this.mError);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Op Code: device disconnected");
        }
        return this.mReceivedData;
    }

    protected String parse(byte[] data) {
        if (data == null) {
            return "";
        }
        int length = data.length;
        if (length == 0) {
            return "";
        }
        char[] out = new char[length * 3 - 1];
        for (int j = 0; j < length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return new String(out);
    }

    void loge(String message) {
        Log.e((String)TAG, (String)message);
    }

    void loge(String message, Throwable e) {
        Log.e((String)TAG, (String)message, (Throwable)e);
    }

    void logw(String message) {
        if (DfuBaseService.DEBUG) {
            Log.w((String)TAG, (String)message);
        }
    }

    void logi(String message) {
        if (DfuBaseService.DEBUG) {
            Log.i((String)TAG, (String)message);
        }
    }

    protected class BaseBluetoothGattCallback
    extends BluetoothGattCallback {
        protected BaseBluetoothGattCallback() {
        }

        public void onDisconnected() {
            BaseDfuImpl.this.mConnected = false;
            BaseDfuImpl.this.notifyLock();
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                BaseDfuImpl.this.mService.sendLogBroadcast(5, "Read Response received from " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                BaseDfuImpl.this.mReceivedData = characteristic.getValue();
                BaseDfuImpl.this.mRequestCompleted = true;
            } else {
                BaseDfuImpl.this.loge("Characteristic read error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(descriptor.getUuid())) {
                    BaseDfuImpl.this.mService.sendLogBroadcast(5, "Read Response received from descr." + descriptor.getCharacteristic().getUuid() + ", value (0x): " + this.parse(descriptor));
                    if (SERVICE_CHANGED_UUID.equals(descriptor.getCharacteristic().getUuid())) {
                        BaseDfuImpl.this.mRequestCompleted = true;
                    } else {
                        BaseDfuImpl.this.loge("Unknown descriptor read");
                    }
                }
            } else {
                BaseDfuImpl.this.loge("Descriptor read error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                if (CLIENT_CHARACTERISTIC_CONFIG.equals(descriptor.getUuid())) {
                    BaseDfuImpl.this.mService.sendLogBroadcast(5, "Data written to descr." + descriptor.getCharacteristic().getUuid() + ", value (0x): " + this.parse(descriptor));
                    if (SERVICE_CHANGED_UUID.equals(descriptor.getCharacteristic().getUuid())) {
                        BaseDfuImpl.this.mService.sendLogBroadcast(1, "Indications enabled for " + descriptor.getCharacteristic().getUuid());
                    } else {
                        BaseDfuImpl.this.mService.sendLogBroadcast(1, "Notifications enabled for " + descriptor.getCharacteristic().getUuid());
                    }
                }
            } else {
                BaseDfuImpl.this.loge("Descriptor write error: " + status);
                BaseDfuImpl.this.mError = 0x4000 | status;
            }
            BaseDfuImpl.this.notifyLock();
        }

        protected String parse(BluetoothGattCharacteristic characteristic) {
            return this.parse(characteristic.getValue());
        }

        protected String parse(BluetoothGattDescriptor descriptor) {
            return this.parse(descriptor.getValue());
        }

        private String parse(byte[] data) {
            if (data == null) {
                return "";
            }
            int length = data.length;
            if (length == 0) {
                return "";
            }
            char[] out = new char[length * 3 - 1];
            for (int j = 0; j < length; ++j) {
                int v = data[j] & 0xFF;
                out[j * 3] = HEX_ARRAY[v >>> 4];
                out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
                if (j == length - 1) continue;
                out[j * 3 + 2] = 45;
            }
            return new String(out);
        }
    }
}

