/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import java.io.Serializable;
import java.security.InvalidParameterException;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.DfuServiceController;

public class DfuServiceInitiator {
    public static final int DEFAULT_PRN_VALUE = 12;
    private final String deviceAddress;
    private String deviceName;
    private boolean disableNotification;
    private Uri fileUri;
    private String filePath;
    private int fileResId;
    private Uri initFileUri;
    private String initFilePath;
    private int initFileResId;
    private String mimeType;
    private int fileType = -1;
    private boolean keepBond;
    private boolean forceDfu = false;
    private boolean enableUnsafeExperimentalButtonlessDfu = false;
    private Boolean packetReceiptNotificationsEnabled;
    private int numberOfPackets = 12;

    public DfuServiceInitiator(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public DfuServiceInitiator setDeviceName(String name) {
        this.deviceName = name;
        return this;
    }

    public DfuServiceInitiator setDisableNotification(boolean disableNotification) {
        this.disableNotification = disableNotification;
        return this;
    }

    public DfuServiceInitiator setKeepBond(boolean keepBond) {
        this.keepBond = keepBond;
        return this;
    }

    public DfuServiceInitiator setPacketsReceiptNotificationsEnabled(boolean enabled) {
        this.packetReceiptNotificationsEnabled = enabled;
        return this;
    }

    public DfuServiceInitiator setPacketsReceiptNotificationsValue(int number) {
        this.numberOfPackets = number > 0 ? number : 12;
        return this;
    }

    public DfuServiceInitiator setForceDfu(boolean force) {
        this.forceDfu = force;
        return this;
    }

    public DfuServiceInitiator setUnsafeExperimentalButtonlessServiceInSecureDfuEnabled(boolean enable) {
        this.enableUnsafeExperimentalButtonlessDfu = enable;
        return this;
    }

    public DfuServiceInitiator setZip(Uri uri) {
        return this.init(uri, null, 0, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(String path) {
        return this.init(null, path, 0, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(int rawResId) {
        return this.init(null, null, rawResId, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(Uri uri, String path) {
        return this.init(uri, path, 0, 0, "application/zip");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, Uri uri) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(uri, null, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, String path) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(null, path, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, Uri uri, String path) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(uri, path, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, int rawResId) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(null, null, rawResId, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(Uri initFileUri) {
        return this.init(initFileUri, null, 0);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(String initFilePath) {
        return this.init(null, initFilePath, 0);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(int initFileResId) {
        return this.init(null, null, initFileResId);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(Uri initFileUri, String initFilePath) {
        return this.init(initFileUri, initFilePath, 0);
    }

    public DfuServiceController start(Context context, Class<? extends DfuBaseService> service) {
        if (this.fileType == -1) {
            throw new UnsupportedOperationException("You must specify the firmware file before starting the service");
        }
        Intent intent = new Intent(context, service);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS", this.deviceAddress);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_NAME", this.deviceName);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_NOTIFICATION", this.disableNotification);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MIME_TYPE", this.mimeType);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_TYPE", this.fileType);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_URI", (Parcelable)this.fileUri);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_PATH", this.filePath);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_RES_ID", this.fileResId);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_URI", (Parcelable)this.initFileUri);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_PATH", this.initFilePath);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_RES_ID", this.initFileResId);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", this.keepBond);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FORCE_DFU", this.forceDfu);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU", this.enableUnsafeExperimentalButtonlessDfu);
        if (this.packetReceiptNotificationsEnabled != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_ENABLED", (Serializable)this.packetReceiptNotificationsEnabled);
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_VALUE", this.numberOfPackets);
        }
        context.startService(intent);
        return new DfuServiceController(context);
    }

    private DfuServiceInitiator init(Uri initFileUri, String initFilePath, int initFileResId) {
        if ("application/zip".equals(this.mimeType)) {
            throw new InvalidParameterException("Init file must be located inside the ZIP");
        }
        this.initFileUri = initFileUri;
        this.initFilePath = initFilePath;
        this.initFileResId = initFileResId;
        return this;
    }

    private DfuServiceInitiator init(Uri fileUri, String filePath, int fileResId, int fileType, String mimeType) {
        this.fileUri = fileUri;
        this.filePath = filePath;
        this.fileResId = fileResId;
        this.fileType = fileType;
        this.mimeType = mimeType;
        if ("application/zip".equals(mimeType)) {
            this.initFileUri = null;
            this.initFilePath = null;
            this.initFileResId = 0;
        }
        return this;
    }
}

