/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.ExperimentalButtonlessDfuImpl;
import no.nordicsemi.android.dfu.LegacyDfuImpl;
import no.nordicsemi.android.dfu.SecureDfuImpl;

class DfuServiceProvider {
    DfuServiceProvider() {
    }

    static BaseDfuImpl getDfuImpl(Intent intent, DfuBaseService service, BluetoothGatt gatt) {
        BluetoothGattService experimentalButtonlessDfuService;
        BluetoothGattService secureService = gatt.getService(SecureDfuImpl.DFU_SERVICE_UUID);
        if (secureService != null) {
            return new SecureDfuImpl(intent, service);
        }
        BluetoothGattService legacyService = gatt.getService(LegacyDfuImpl.DFU_SERVICE_UUID);
        if (legacyService != null) {
            return new LegacyDfuImpl(intent, service);
        }
        boolean enableUnsafeExperimentalButtonlessDfuService = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU", false);
        if (enableUnsafeExperimentalButtonlessDfuService && (experimentalButtonlessDfuService = gatt.getService(ExperimentalButtonlessDfuImpl.EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID)) != null) {
            return new ExperimentalButtonlessDfuImpl(intent, service);
        }
        return null;
    }
}

