/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import java.util.UUID;
import no.nordicsemi.android.dfu.BaseDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.RemoteDfuException;
import no.nordicsemi.android.dfu.internal.exception.UnknownResponseException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;
import no.nordicsemi.android.dfu.internal.scanner.BootloaderScannerFactory;

public class ExperimentalButtonlessDfuImpl
extends BaseDfuImpl {
    protected static final UUID EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID = new UUID(-8196551313441075360L, -6937650605005804976L);
    private static final int DFU_STATUS_SUCCESS = 1;
    private static final int ERROR_OP_CODE_NOT_SUPPORTED = 2;
    private static final int ERROR_OPERATION_FAILED = 4;
    private static final int OP_CODE_ENTER_BOOTLOADER_KEY = 1;
    private static final int OP_CODE_RESPONSE_CODE_KEY = 32;
    private static final byte[] OP_CODE_ENTER_BOOTLOADER = new byte[]{1};
    private BluetoothGattCharacteristic mButtonlessDfuCharacteristic;
    private final ButtonlessBluetoothCallback mBluetoothCallback = new ButtonlessBluetoothCallback();

    ExperimentalButtonlessDfuImpl(Intent intent, DfuBaseService service) {
        super(intent, service);
    }

    @Override
    protected BaseDfuImpl.BaseBluetoothGattCallback getGattCallback() {
        return this.mBluetoothCallback;
    }

    @Override
    public boolean hasRequiredService(BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID);
        return dfuService != null;
    }

    @Override
    public boolean hasRequiredCharacteristics(BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID);
        this.mButtonlessDfuCharacteristic = dfuService.getCharacteristic(EXPERIMENTAL_BUTTONLESS_DFU_SERVICE_UUID);
        return this.mButtonlessDfuCharacteristic != null;
    }

    @Override
    public void performDfu(Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.mProgressInfo.setProgress(-2);
        this.mService.waitFor(1000);
        BluetoothGatt gatt = this.mGatt;
        this.logw("Experimental buttonless service found");
        this.mService.sendLogBroadcast(15, "Application with buttonless update found");
        this.mService.sendLogBroadcast(1, "Jumping to the DFU Bootloader...");
        this.enableCCCD(this.mButtonlessDfuCharacteristic, 1);
        this.mService.sendLogBroadcast(10, "Notifications enabled");
        this.mService.waitFor(1000);
        try {
            byte[] response;
            this.mProgressInfo.setProgress(-3);
            this.logi("Sending Enter Bootloader (Op Code = 1)");
            this.writeOpCode(this.mButtonlessDfuCharacteristic, OP_CODE_ENTER_BOOTLOADER, true);
            this.mService.sendLogBroadcast(10, "Enter bootloader sent (Op Code = 1)");
            try {
                response = this.readNotificationResponse();
            }
            catch (DeviceDisconnectedException e) {
                response = this.mReceivedData;
            }
            if (response != null) {
                int status = this.getStatusCode(response, 1);
                this.logi("Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                if (status != 1) {
                    throw new RemoteDfuException("Device returned error after sending Enter Bootloader", status);
                }
                this.mService.waitUntilDisconnected();
            } else {
                this.logi("Device disconnected before receiving notification");
            }
            this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
            this.finalize(intent, true);
        }
        catch (UnknownResponseException e) {
            int error = 4104;
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, e.getMessage());
            this.mService.terminateConnection(gatt, 4104);
        }
        catch (RemoteDfuException e) {
            int error = 0x2000 | e.getErrorNumber();
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, String.format("Remote DFU error: %s", ExperimentalButtonlessDfuImpl.parse(error)));
            this.mService.terminateConnection(gatt, error);
        }
    }

    protected void finalize(Intent intent, boolean forceRefresh) {
        boolean restoreBond;
        boolean keepBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", false);
        this.mService.refreshDeviceCache(this.mGatt, forceRefresh || !keepBond);
        this.mService.close(this.mGatt);
        if (this.mGatt.getDevice().getBondState() == 12 && ((restoreBond = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND", false)) || !keepBond || (this.mFileType & 1) > 0)) {
            this.removeBond();
            this.mService.waitFor(2000);
        }
        this.mService.sendLogBroadcast(1, "Scanning for the DFU Bootloader...");
        String newAddress = BootloaderScannerFactory.getScanner().searchFor(this.mGatt.getDevice().getAddress());
        if (newAddress != null) {
            this.mService.sendLogBroadcast(5, "DFU Bootloader found with address " + newAddress);
        } else {
            this.mService.sendLogBroadcast(5, "DFU Bootloader not found. Trying the same address...");
        }
        this.logi("Starting service that will upload application");
        Intent newIntent = new Intent();
        newIntent.fillIn(intent, 24);
        if (newAddress != null) {
            newIntent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS", newAddress);
        }
        this.mService.startService(newIntent);
    }

    private int getStatusCode(byte[] response, int request) throws UnknownResponseException {
        if (response == null || response.length < 3 || response[0] != 32 || response[1] != request || response[2] != 1 && response[2] != 2 && response[2] != 3 && response[2] != 4 && response[2] != 5 && response[2] != 7 && response[2] != 10 && response[2] != 11) {
            throw new UnknownResponseException("Invalid response received", response, 32, request);
        }
        return response[2];
    }

    private static String parse(int error) {
        switch (error & 0xFFFFDFFF) {
            case 2: {
                return "REMOTE DFU OP CODE NOT SUPPORTED";
            }
            case 4: {
                return "REMOTE DFU OPERATION FAILED";
            }
        }
        return "UNKNOWN (" + error + ")";
    }

    protected class ButtonlessBluetoothCallback
    extends BaseDfuImpl.BaseBluetoothGattCallback {
        protected ButtonlessBluetoothCallback() {
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            ExperimentalButtonlessDfuImpl.this.mService.sendLogBroadcast(5, "Notification received from " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
            ExperimentalButtonlessDfuImpl.this.mReceivedData = characteristic.getValue();
            ExperimentalButtonlessDfuImpl.this.notifyLock();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            ExperimentalButtonlessDfuImpl.this.mRequestCompleted = true;
            ExperimentalButtonlessDfuImpl.this.notifyLock();
        }
    }
}

