/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import no.nordicsemi.android.dfu.internal.HexInputStream;
import no.nordicsemi.android.dfu.internal.manifest.FileInfo;
import no.nordicsemi.android.dfu.internal.manifest.Manifest;
import no.nordicsemi.android.dfu.internal.manifest.ManifestFile;
import no.nordicsemi.android.dfu.internal.manifest.SoftDeviceBootloaderFileInfo;

public class ArchiveInputStream
extends InputStream {
    private static final String TAG = "DfuArchiveInputStream";
    private static final String MANIFEST = "manifest.json";
    private static final String SOFTDEVICE_HEX = "softdevice.hex";
    private static final String SOFTDEVICE_BIN = "softdevice.bin";
    private static final String BOOTLOADER_HEX = "bootloader.hex";
    private static final String BOOTLOADER_BIN = "bootloader.bin";
    private static final String APPLICATION_HEX = "application.hex";
    private static final String APPLICATION_BIN = "application.bin";
    private static final String SYSTEM_INIT = "system.dat";
    private static final String APPLICATION_INIT = "application.dat";
    private final ZipInputStream zipInputStream;
    private Map<String, byte[]> entries;
    private Manifest manifest;
    private CRC32 crc32;
    private byte[] applicationBytes;
    private byte[] softDeviceBytes;
    private byte[] bootloaderBytes;
    private byte[] softDeviceAndBootloaderBytes;
    private byte[] systemInitBytes;
    private byte[] applicationInitBytes;
    private byte[] currentSource;
    private int type;
    private int bytesReadFromCurrentSource;
    private int softDeviceSize;
    private int bootloaderSize;
    private int applicationSize;
    private int bytesRead;
    private byte[] markedSource;
    private int bytesReadFromMarkedSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveInputStream(InputStream stream, int mbrSize, int types) throws IOException {
        this.zipInputStream = new ZipInputStream(stream);
        this.crc32 = new CRC32();
        this.entries = new HashMap<String, byte[]>();
        this.bytesRead = 0;
        this.bytesReadFromCurrentSource = 0;
        try {
            this.parseZip(mbrSize);
            if (this.manifest != null) {
                boolean valid = false;
                if (this.manifest.getApplicationInfo() != null && (types == 0 || (types & 4) > 0)) {
                    FileInfo application = this.manifest.getApplicationInfo();
                    this.applicationBytes = this.entries.get(application.getBinFileName());
                    this.applicationInitBytes = this.entries.get(application.getDatFileName());
                    if (this.applicationBytes == null) {
                        throw new IOException("Application file " + application.getBinFileName() + " not found.");
                    }
                    this.applicationSize = this.applicationBytes.length;
                    this.currentSource = this.applicationBytes;
                    valid = true;
                }
                if (this.manifest.getBootloaderInfo() != null && (types == 0 || (types & 2) > 0)) {
                    if (this.systemInitBytes != null) {
                        throw new IOException("Manifest: softdevice and bootloader specified. Use softdevice_bootloader instead.");
                    }
                    FileInfo bootloader = this.manifest.getBootloaderInfo();
                    this.bootloaderBytes = this.entries.get(bootloader.getBinFileName());
                    this.systemInitBytes = this.entries.get(bootloader.getDatFileName());
                    if (this.bootloaderBytes == null) {
                        throw new IOException("Bootloader file " + bootloader.getBinFileName() + " not found.");
                    }
                    this.bootloaderSize = this.bootloaderBytes.length;
                    this.currentSource = this.bootloaderBytes;
                    valid = true;
                }
                if (this.manifest.getSoftdeviceInfo() != null && (types == 0 || (types & 1) > 0)) {
                    FileInfo softdevice = this.manifest.getSoftdeviceInfo();
                    this.softDeviceBytes = this.entries.get(softdevice.getBinFileName());
                    this.systemInitBytes = this.entries.get(softdevice.getDatFileName());
                    if (this.softDeviceBytes == null) {
                        throw new IOException("SoftDevice file " + softdevice.getBinFileName() + " not found.");
                    }
                    this.softDeviceSize = this.softDeviceBytes.length;
                    this.currentSource = this.softDeviceBytes;
                    valid = true;
                }
                if (this.manifest.getSoftdeviceBootloaderInfo() != null && (types == 0 || (types & 1) > 0 && (types & 2) > 0)) {
                    if (this.systemInitBytes != null) {
                        throw new IOException("Manifest: The softdevice_bootloader may not be used together with softdevice or bootloader.");
                    }
                    SoftDeviceBootloaderFileInfo system = this.manifest.getSoftdeviceBootloaderInfo();
                    this.softDeviceAndBootloaderBytes = this.entries.get(system.getBinFileName());
                    this.systemInitBytes = this.entries.get(system.getDatFileName());
                    if (this.softDeviceAndBootloaderBytes == null) {
                        throw new IOException("File " + system.getBinFileName() + " not found.");
                    }
                    this.softDeviceSize = system.getSoftdeviceSize();
                    this.bootloaderSize = system.getBootloaderSize();
                    this.currentSource = this.softDeviceAndBootloaderBytes;
                    valid = true;
                }
                if (!valid) {
                    throw new IOException("Manifest file must specify at least one file.");
                }
            } else {
                boolean valid = false;
                if (types == 0 || (types & 4) > 0) {
                    this.applicationBytes = this.entries.get(APPLICATION_HEX);
                    if (this.applicationBytes == null) {
                        this.applicationBytes = this.entries.get(APPLICATION_BIN);
                    }
                    if (this.applicationBytes != null) {
                        this.applicationSize = this.applicationBytes.length;
                        this.applicationInitBytes = this.entries.get(APPLICATION_INIT);
                        this.currentSource = this.applicationBytes;
                        valid = true;
                    }
                }
                if (types == 0 || (types & 2) > 0) {
                    this.bootloaderBytes = this.entries.get(BOOTLOADER_HEX);
                    if (this.bootloaderBytes == null) {
                        this.bootloaderBytes = this.entries.get(BOOTLOADER_BIN);
                    }
                    if (this.bootloaderBytes != null) {
                        this.bootloaderSize = this.bootloaderBytes.length;
                        this.systemInitBytes = this.entries.get(SYSTEM_INIT);
                        this.currentSource = this.bootloaderBytes;
                        valid = true;
                    }
                }
                if (types == 0 || (types & 1) > 0) {
                    this.softDeviceBytes = this.entries.get(SOFTDEVICE_HEX);
                    if (this.softDeviceBytes == null) {
                        this.softDeviceBytes = this.entries.get(SOFTDEVICE_BIN);
                    }
                    if (this.softDeviceBytes != null) {
                        this.softDeviceSize = this.softDeviceBytes.length;
                        this.systemInitBytes = this.entries.get(SYSTEM_INIT);
                        this.currentSource = this.softDeviceBytes;
                        valid = true;
                    }
                }
                if (!valid) {
                    throw new IOException("The ZIP file must contain an Application, a Soft Device and/or a Bootloader.");
                }
            }
            this.mark(0);
        }
        finally {
            this.type = this.getContentType();
            this.zipInputStream.close();
        }
    }

    private void parseZip(int mbrSize) throws IOException {
        ZipEntry ze;
        byte[] buffer = new byte[1024];
        String manifestData = null;
        while ((ze = this.zipInputStream.getNextEntry()) != null) {
            int count;
            String filename = ze.getName();
            if (ze.isDirectory()) {
                Log.w((String)TAG, (String)("A directory found in the ZIP: " + filename + "!"));
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = this.zipInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
            byte[] source = baos.toByteArray();
            if (filename.toLowerCase(Locale.US).endsWith("hex")) {
                HexInputStream is = new HexInputStream(source, mbrSize);
                source = new byte[is.available()];
                is.read(source);
                is.close();
            }
            if (MANIFEST.equals(filename)) {
                manifestData = new String(source, "UTF-8");
                continue;
            }
            this.entries.put(filename, source);
        }
        if (this.entries.isEmpty()) {
            throw new FileNotFoundException("No files found in the ZIP. Check if the URI provided is valid and the ZIP contains required files on root level, not in a directory.");
        }
        if (manifestData != null) {
            ManifestFile manifestFile = (ManifestFile)new Gson().fromJson(manifestData, ManifestFile.class);
            this.manifest = manifestFile.getManifest();
            if (this.manifest == null) {
                Log.w((String)TAG, (String)"Manifest failed to be parsed. Did you add \n-keep class no.nordicsemi.android.dfu.** { *; }\nto your proguard rules?");
            }
        } else {
            Log.w((String)TAG, (String)"Manifest not found in the ZIP. It is recommended to use a distribution file created with: https://github.com/NordicSemiconductor/pc-nrfutil/ (for Legacy DFU use version 0.5.x)");
        }
    }

    @Override
    public void close() throws IOException {
        this.softDeviceBytes = null;
        this.bootloaderBytes = null;
        this.applicationBytes = null;
        this.softDeviceAndBootloaderBytes = null;
        this.applicationSize = 0;
        this.bootloaderSize = 0;
        this.softDeviceSize = 0;
        this.currentSource = null;
        this.bytesReadFromCurrentSource = 0;
        this.bytesRead = 0;
        this.zipInputStream.close();
    }

    @Override
    public long skip(long n) {
        return 0L;
    }

    @Override
    public int read() {
        byte[] buffer = new byte[1];
        if (this.read(buffer) == -1) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(@NonNull byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@NonNull byte[] buffer, int offset, int length) {
        int size = this.rawRead(buffer, offset, length);
        if (length > size && this.startNextFile() != null) {
            return size + this.rawRead(buffer, offset + size, length - size);
        }
        return size;
    }

    private int rawRead(@NonNull byte[] buffer, int offset, int length) {
        int maxSize = this.currentSource.length - this.bytesReadFromCurrentSource;
        int size = length <= maxSize ? length : maxSize;
        System.arraycopy(this.currentSource, this.bytesReadFromCurrentSource, buffer, offset, size);
        this.bytesReadFromCurrentSource += size;
        this.bytesRead += size;
        this.crc32.update(buffer, offset, size);
        return size;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markedSource = this.currentSource;
        this.bytesReadFromMarkedSource = this.bytesReadFromCurrentSource;
    }

    @Override
    public void reset() {
        this.currentSource = this.markedSource;
        this.bytesRead = this.bytesReadFromCurrentSource = this.bytesReadFromMarkedSource;
        this.crc32.reset();
        if (this.currentSource == this.bootloaderBytes && this.softDeviceBytes != null) {
            this.crc32.update(this.softDeviceBytes);
            this.bytesRead += this.softDeviceSize;
        }
        this.crc32.update(this.currentSource, 0, this.bytesReadFromCurrentSource);
    }

    public void fullReset() {
        if (this.softDeviceBytes != null && this.bootloaderBytes != null && this.currentSource == this.bootloaderBytes) {
            this.currentSource = this.softDeviceBytes;
        }
        this.bytesReadFromCurrentSource = 0;
        this.mark(0);
        this.reset();
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public long getCrc32() {
        return this.crc32.getValue();
    }

    public int getContentType() {
        this.type = 0;
        if (this.softDeviceAndBootloaderBytes != null) {
            this.type |= 3;
        }
        if (this.softDeviceSize > 0) {
            this.type |= 1;
        }
        if (this.bootloaderSize > 0) {
            this.type |= 2;
        }
        if (this.applicationSize > 0) {
            this.type |= 4;
        }
        return this.type;
    }

    public int setContentType(int type) {
        this.type = type;
        if ((type & 4) > 0 && this.applicationBytes == null) {
            this.type &= 0xFFFFFFFB;
        }
        if ((type & 3) == 3) {
            if (this.softDeviceBytes == null && this.softDeviceAndBootloaderBytes == null) {
                this.type &= 0xFFFFFFFE;
            }
            if (this.bootloaderBytes == null && this.softDeviceAndBootloaderBytes == null) {
                this.type &= 0xFFFFFFFE;
            }
        } else if (this.softDeviceAndBootloaderBytes != null) {
            this.type &= 0xFFFFFFFC;
        }
        if ((type & 3) > 0 && this.softDeviceAndBootloaderBytes != null) {
            this.currentSource = this.softDeviceAndBootloaderBytes;
        } else if ((type & 1) > 0) {
            this.currentSource = this.softDeviceBytes;
        } else if ((type & 2) > 0) {
            this.currentSource = this.bootloaderBytes;
        } else if ((type & 4) > 0) {
            this.currentSource = this.applicationBytes;
        }
        this.bytesReadFromCurrentSource = 0;
        this.mark(0);
        this.reset();
        return this.type;
    }

    private byte[] startNextFile() {
        byte[] ret;
        if (this.currentSource == this.softDeviceBytes && this.bootloaderBytes != null && (this.type & 2) > 0) {
            this.currentSource = this.bootloaderBytes;
            ret = this.bootloaderBytes;
        } else if (this.currentSource != this.applicationBytes && this.applicationBytes != null && (this.type & 4) > 0) {
            this.currentSource = this.applicationBytes;
            ret = this.applicationBytes;
        } else {
            this.currentSource = null;
            ret = null;
        }
        this.bytesReadFromCurrentSource = 0;
        return ret;
    }

    @Override
    public int available() {
        if (this.softDeviceAndBootloaderBytes != null && this.softDeviceSize == 0 && this.bootloaderSize == 0 && (this.type & 3) > 0) {
            return this.softDeviceAndBootloaderBytes.length + this.applicationImageSize() - this.bytesRead;
        }
        return this.softDeviceImageSize() + this.bootloaderImageSize() + this.applicationImageSize() - this.bytesRead;
    }

    public int softDeviceImageSize() {
        return (this.type & 1) > 0 ? this.softDeviceSize : 0;
    }

    public int bootloaderImageSize() {
        return (this.type & 2) > 0 ? this.bootloaderSize : 0;
    }

    public int applicationImageSize() {
        return (this.type & 4) > 0 ? this.applicationSize : 0;
    }

    public byte[] getSystemInit() {
        return this.systemInitBytes;
    }

    public byte[] getApplicationInit() {
        return this.applicationInitBytes;
    }

    public boolean isSecureDfuRequired() {
        return this.manifest != null && this.manifest.isSecureDfuRequired();
    }
}

