/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.dfu.BaseCustomDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.internal.ArchiveInputStream;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.RemoteDfuException;
import no.nordicsemi.android.dfu.internal.exception.UnknownResponseException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;
import no.nordicsemi.android.error.LegacyDfuError;

class LegacyDfuImpl
extends BaseCustomDfuImpl {
    static final UUID DEFAULT_DFU_SERVICE_UUID = new UUID(23296205844446L, 1523193452336828707L);
    static final UUID DEFAULT_DFU_CONTROL_POINT_UUID = new UUID(23300500811742L, 1523193452336828707L);
    static final UUID DEFAULT_DFU_PACKET_UUID = new UUID(23304795779038L, 1523193452336828707L);
    static final UUID DEFAULT_DFU_VERSION_UUID = new UUID(23313385713630L, 1523193452336828707L);
    static UUID DFU_SERVICE_UUID = DEFAULT_DFU_SERVICE_UUID;
    static UUID DFU_CONTROL_POINT_UUID = DEFAULT_DFU_CONTROL_POINT_UUID;
    static UUID DFU_PACKET_UUID = DEFAULT_DFU_PACKET_UUID;
    static UUID DFU_VERSION_UUID = DEFAULT_DFU_VERSION_UUID;
    private static final int DFU_STATUS_SUCCESS = 1;
    private static final int OP_CODE_START_DFU_KEY = 1;
    private static final int OP_CODE_INIT_DFU_PARAMS_KEY = 2;
    private static final int OP_CODE_RECEIVE_FIRMWARE_IMAGE_KEY = 3;
    private static final int OP_CODE_VALIDATE_KEY = 4;
    private static final int OP_CODE_ACTIVATE_AND_RESET_KEY = 5;
    private static final int OP_CODE_RESET_KEY = 6;
    private static final int OP_CODE_PACKET_RECEIPT_NOTIF_REQ_KEY = 8;
    private static final int OP_CODE_RESPONSE_CODE_KEY = 16;
    private static final int OP_CODE_PACKET_RECEIPT_NOTIF_KEY = 17;
    private static final byte[] OP_CODE_START_DFU = new byte[]{1, 0};
    private static final byte[] OP_CODE_START_DFU_V1 = new byte[]{1};
    private static final byte[] OP_CODE_INIT_DFU_PARAMS = new byte[]{2};
    private static final byte[] OP_CODE_INIT_DFU_PARAMS_START = new byte[]{2, 0};
    private static final byte[] OP_CODE_INIT_DFU_PARAMS_COMPLETE = new byte[]{2, 1};
    private static final byte[] OP_CODE_RECEIVE_FIRMWARE_IMAGE = new byte[]{3};
    private static final byte[] OP_CODE_VALIDATE = new byte[]{4};
    private static final byte[] OP_CODE_ACTIVATE_AND_RESET = new byte[]{5};
    private static final byte[] OP_CODE_RESET = new byte[]{6};
    private static final byte[] OP_CODE_PACKET_RECEIPT_NOTIF_REQ = new byte[]{8, 0, 0};
    private BluetoothGattCharacteristic mControlPointCharacteristic;
    private BluetoothGattCharacteristic mPacketCharacteristic;
    private boolean mImageSizeInProgress;
    private final LegacyBluetoothCallback mBluetoothCallback = new LegacyBluetoothCallback();

    LegacyDfuImpl(@NonNull Intent intent, @NonNull DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public boolean isClientCompatible(@NonNull Intent intent, @NonNull BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(DFU_SERVICE_UUID);
        if (dfuService == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = dfuService.getCharacteristic(DFU_CONTROL_POINT_UUID);
        if (characteristic == null || characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG) == null) {
            return false;
        }
        this.mControlPointCharacteristic = characteristic;
        this.mPacketCharacteristic = dfuService.getCharacteristic(DFU_PACKET_UUID);
        return this.mPacketCharacteristic != null;
    }

    @Override
    public BaseCustomDfuImpl.BaseCustomBluetoothCallback getGattCallback() {
        return this.mBluetoothCallback;
    }

    @Override
    protected UUID getControlPointCharacteristicUUID() {
        return DFU_CONTROL_POINT_UUID;
    }

    @Override
    protected UUID getPacketCharacteristicUUID() {
        return DFU_PACKET_UUID;
    }

    @Override
    protected UUID getDfuServiceUUID() {
        return DFU_SERVICE_UUID;
    }

    @Override
    public void performDfu(@NonNull Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.logw("Legacy DFU bootloader found");
        this.mProgressInfo.setProgress(-2);
        this.mService.waitFor(1000L);
        BluetoothGatt gatt = this.mGatt;
        BluetoothGattCharacteristic versionCharacteristic = gatt.getService(DFU_SERVICE_UUID).getCharacteristic(DFU_VERSION_UUID);
        int version = this.readVersion(versionCharacteristic);
        if (version >= 5 && this.mInitPacketStream == null) {
            this.logw("Init packet not set for the DFU Bootloader version " + version);
            this.mService.sendLogBroadcast(20, "The Init packet is required by this version DFU Bootloader");
            this.mService.terminateConnection(gatt, 4107);
            return;
        }
        try {
            int numberOfPacketsBeforeNotification;
            int status;
            byte[] response;
            boolean extendedInitPacketSupported;
            block30: {
                int appImageSize;
                this.enableCCCD(this.mControlPointCharacteristic, 1);
                this.mService.sendLogBroadcast(10, "Notifications enabled");
                this.mService.waitFor(1000L);
                int fileType = this.mFileType;
                int softDeviceImageSize = (fileType & 1) > 0 ? this.mImageSizeInBytes : 0;
                int bootloaderImageSize = (fileType & 2) > 0 ? this.mImageSizeInBytes : 0;
                int n = appImageSize = (fileType & 4) > 0 ? this.mImageSizeInBytes : 0;
                if (this.mFirmwareStream instanceof ArchiveInputStream) {
                    ArchiveInputStream zhis = (ArchiveInputStream)this.mFirmwareStream;
                    if (zhis.isSecureDfuRequired()) {
                        this.loge("Secure DFU is required to upload selected firmware");
                        this.mService.sendLogBroadcast(20, "The device does not support given firmware.");
                        this.logi("Sending Reset command (Op Code = 6)");
                        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RESET);
                        this.mService.sendLogBroadcast(10, "Reset request sent");
                        this.mService.terminateConnection(gatt, 4099);
                        return;
                    }
                    softDeviceImageSize = zhis.softDeviceImageSize();
                    bootloaderImageSize = zhis.bootloaderImageSize();
                    appImageSize = zhis.applicationImageSize();
                }
                extendedInitPacketSupported = true;
                try {
                    LegacyDfuImpl.OP_CODE_START_DFU[1] = (byte)fileType;
                    this.logi("Sending Start DFU command (Op Code = 1, Upload Mode = " + fileType + ")");
                    this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_START_DFU);
                    this.mService.sendLogBroadcast(10, "DFU Start sent (Op Code = 1, Upload Mode = " + fileType + ")");
                    this.logi("Sending image size array to DFU Packet (" + softDeviceImageSize + "b, " + bootloaderImageSize + "b, " + appImageSize + "b)");
                    this.writeImageSize(this.mPacketCharacteristic, softDeviceImageSize, bootloaderImageSize, appImageSize);
                    this.mService.sendLogBroadcast(10, "Firmware image size sent (" + softDeviceImageSize + "b, " + bootloaderImageSize + "b, " + appImageSize + "b)");
                    response = this.readNotificationResponse();
                    status = this.getStatusCode(response, 1);
                    this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + " Status = " + status + ")");
                    if (status == 2) {
                        this.resetAndRestart(gatt, intent);
                        return;
                    }
                    if (status != 1) {
                        throw new RemoteDfuException("Starting DFU failed", status);
                    }
                }
                catch (RemoteDfuException e) {
                    try {
                        if (e.getErrorNumber() != 3) {
                            throw e;
                        }
                        if ((fileType & 4) > 0 && (fileType & 3) > 0) {
                            this.mRemoteErrorOccurred = false;
                            this.logw("DFU target does not support (SD/BL)+App update");
                            this.mService.sendLogBroadcast(15, "DFU target does not support (SD/BL)+App update");
                            this.mFileType = fileType &= 0xFFFFFFFB;
                            LegacyDfuImpl.OP_CODE_START_DFU[1] = (byte)fileType;
                            this.mProgressInfo.setTotalPart(2);
                            ArchiveInputStream zhis = (ArchiveInputStream)this.mFirmwareStream;
                            zhis.setContentType(fileType);
                            appImageSize = 0;
                            this.mService.sendLogBroadcast(1, "Sending only SD/BL");
                            this.logi("Resending Start DFU command (Op Code = 1, Upload Mode = " + fileType + ")");
                            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_START_DFU);
                            this.mService.sendLogBroadcast(10, "DFU Start sent (Op Code = 1, Upload Mode = " + fileType + ")");
                            this.logi("Sending image size array to DFU Packet: [" + softDeviceImageSize + "b, " + bootloaderImageSize + "b, " + appImageSize + "b]");
                            this.writeImageSize(this.mPacketCharacteristic, softDeviceImageSize, bootloaderImageSize, appImageSize);
                            this.mService.sendLogBroadcast(10, "Firmware image size sent [" + softDeviceImageSize + "b, " + bootloaderImageSize + "b, " + appImageSize + "b]");
                            response = this.readNotificationResponse();
                            status = this.getStatusCode(response, 1);
                            this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + " Status = " + status + ")");
                            if (status == 2) {
                                this.resetAndRestart(gatt, intent);
                                return;
                            }
                            if (status != 1) {
                                throw new RemoteDfuException("Starting DFU failed", status);
                            }
                        }
                        throw e;
                    }
                    catch (RemoteDfuException e1) {
                        if (e1.getErrorNumber() != 3) {
                            throw e1;
                        }
                        if (fileType == 4) {
                            this.mRemoteErrorOccurred = false;
                            extendedInitPacketSupported = false;
                            this.logw("DFU target does not support DFU v.2");
                            this.mService.sendLogBroadcast(15, "DFU target does not support DFU v.2");
                            this.mService.sendLogBroadcast(1, "Switching to DFU v.1");
                            this.logi("Resending Start DFU command (Op Code = 1)");
                            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_START_DFU_V1);
                            this.mService.sendLogBroadcast(10, "DFU Start sent (Op Code = 1)");
                            this.logi("Sending application image size to DFU Packet: " + this.mImageSizeInBytes + " bytes");
                            this.writeImageSize(this.mPacketCharacteristic, this.mImageSizeInBytes);
                            this.mService.sendLogBroadcast(10, "Firmware image size sent (" + this.mImageSizeInBytes + " bytes)");
                            response = this.readNotificationResponse();
                            status = this.getStatusCode(response, 1);
                            this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                            if (status == 2) {
                                this.resetAndRestart(gatt, intent);
                                return;
                            }
                            if (status != 1) {
                                throw new RemoteDfuException("Starting DFU failed", status);
                            }
                            break block30;
                        }
                        throw e1;
                    }
                }
            }
            if (this.mInitPacketStream != null) {
                this.mService.sendLogBroadcast(10, "Writing Initialize DFU Parameters...");
                if (extendedInitPacketSupported) {
                    this.logi("Sending the Initialize DFU Parameters START (Op Code = 2, Value = 0)");
                    this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_INIT_DFU_PARAMS_START);
                    this.logi("Sending " + this.mInitPacketSizeInBytes + " bytes of init packet");
                    this.writeInitData(this.mPacketCharacteristic, null);
                    this.logi("Sending the Initialize DFU Parameters COMPLETE (Op Code = 2, Value = 1)");
                    this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_INIT_DFU_PARAMS_COMPLETE);
                    this.mService.sendLogBroadcast(10, "Initialize DFU Parameters completed");
                } else {
                    this.logi("Sending the Initialize DFU Parameters (Op Code = 2)");
                    this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_INIT_DFU_PARAMS);
                    this.logi("Sending " + this.mInitPacketSizeInBytes + " bytes of init packet");
                    this.writeInitData(this.mPacketCharacteristic, null);
                }
                response = this.readNotificationResponse();
                status = this.getStatusCode(response, 2);
                this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
                if (status != 1) {
                    throw new RemoteDfuException("Device returned error after sending init packet", status);
                }
            }
            int n = numberOfPacketsBeforeNotification = extendedInitPacketSupported || this.mPacketsBeforeNotification > 0 && this.mPacketsBeforeNotification <= 10 ? this.mPacketsBeforeNotification : 10;
            if (numberOfPacketsBeforeNotification > 0) {
                this.mPacketsBeforeNotification = numberOfPacketsBeforeNotification;
                this.logi("Sending the number of packets before notifications (Op Code = 8, Value = " + numberOfPacketsBeforeNotification + ")");
                this.setNumberOfPackets(OP_CODE_PACKET_RECEIPT_NOTIF_REQ, numberOfPacketsBeforeNotification);
                this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_PACKET_RECEIPT_NOTIF_REQ);
                this.mService.sendLogBroadcast(10, "Packet Receipt Notif Req (Op Code = 8) sent (Value = " + numberOfPacketsBeforeNotification + ")");
            }
            this.logi("Sending Receive Firmware Image request (Op Code = 3)");
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RECEIVE_FIRMWARE_IMAGE);
            this.mService.sendLogBroadcast(10, "Receive Firmware Image request sent");
            long startTime = SystemClock.elapsedRealtime();
            this.mProgressInfo.setBytesSent(0);
            try {
                this.logi("Uploading firmware...");
                this.mService.sendLogBroadcast(10, "Uploading firmware...");
                this.uploadFirmwareImage(this.mPacketCharacteristic);
            }
            catch (DeviceDisconnectedException e) {
                this.loge("Disconnected while sending data");
                throw e;
            }
            long endTime = SystemClock.elapsedRealtime();
            response = this.readNotificationResponse();
            status = this.getStatusCode(response, 3);
            this.logi("Response received (Op Code = " + response[0] + ", Req Op Code = " + response[1] + ", Status = " + response[2] + ")");
            this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
            if (status != 1) {
                throw new RemoteDfuException("Device returned error after sending file", status);
            }
            this.logi("Transfer of " + this.mProgressInfo.getBytesSent() + " bytes has taken " + (endTime - startTime) + " ms");
            this.mService.sendLogBroadcast(10, "Upload completed in " + (endTime - startTime) + " ms");
            this.logi("Sending Validate request (Op Code = 4)");
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_VALIDATE);
            this.mService.sendLogBroadcast(10, "Validate request sent");
            response = this.readNotificationResponse();
            status = this.getStatusCode(response, 4);
            this.logi("Response received (Op Code = " + response[0] + ", Req Op Code = " + response[1] + ", Status = " + response[2] + ")");
            this.mService.sendLogBroadcast(10, "Response received (Op Code = " + response[1] + ", Status = " + status + ")");
            if (status != 1) {
                throw new RemoteDfuException("Device returned validation error", status);
            }
            this.mProgressInfo.setProgress(-5);
            this.logi("Sending Activate and Reset request (Op Code = 5)");
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_ACTIVATE_AND_RESET);
            this.mService.sendLogBroadcast(10, "Activate and Reset request sent");
            this.mService.waitUntilDisconnected();
            this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
            this.finalize(intent, version == 5);
        }
        catch (UploadAbortedException e) {
            this.logi("Sending Reset command (Op Code = 6)");
            this.mAborted = false;
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RESET);
            this.mService.sendLogBroadcast(10, "Reset request sent");
            throw e;
        }
        catch (UnknownResponseException e) {
            int error = 4104;
            this.loge(e.getMessage());
            this.mService.sendLogBroadcast(20, e.getMessage());
            this.logi("Sending Reset command (Op Code = 6)");
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RESET);
            this.mService.sendLogBroadcast(10, "Reset request sent");
            this.mService.terminateConnection(gatt, 4104);
        }
        catch (RemoteDfuException e) {
            int error = 0x100 | e.getErrorNumber();
            this.loge(e.getMessage() + ": " + LegacyDfuError.parse(error));
            this.mService.sendLogBroadcast(20, String.format(Locale.US, "Remote DFU error: %s", LegacyDfuError.parse(error)));
            this.logi("Sending Reset command (Op Code = 6)");
            this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RESET);
            this.mService.sendLogBroadcast(10, "Reset request sent");
            this.mService.terminateConnection(gatt, error | 0x2000);
        }
    }

    private void setNumberOfPackets(@NonNull byte[] data, int value) {
        data[1] = (byte)(value & 0xFF);
        data[2] = (byte)(value >> 8 & 0xFF);
    }

    private int getStatusCode(@Nullable byte[] response, int request) throws UnknownResponseException {
        if (response == null || response.length != 3 || response[0] != 16 || response[1] != request || response[2] < 1 || response[2] > 6) {
            throw new UnknownResponseException("Invalid response received", response, 16, request);
        }
        return response[2];
    }

    private int readVersion(@Nullable BluetoothGattCharacteristic characteristic) {
        return characteristic != null ? characteristic.getIntValue(18, 0) : 0;
    }

    private void writeOpCode(@NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        boolean reset = value[0] == 6 || value[0] == 5;
        this.writeOpCode(characteristic, value, reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageSize(@NonNull BluetoothGattCharacteristic characteristic, int imageSize) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        this.mImageSizeInProgress = true;
        characteristic.setWriteType(1);
        characteristic.setValue(new byte[4]);
        characteristic.setValue(imageSize, 20, 0);
        this.mService.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        this.mGatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mImageSizeInProgress && this.mConnected && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Image Size: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Image Size", this.mError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageSize(@NonNull BluetoothGattCharacteristic characteristic, int softDeviceImageSize, int bootloaderImageSize, int appImageSize) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        this.mReceivedData = null;
        this.mError = 0;
        this.mImageSizeInProgress = true;
        characteristic.setWriteType(1);
        characteristic.setValue(new byte[12]);
        characteristic.setValue(softDeviceImageSize, 20, 0);
        characteristic.setValue(bootloaderImageSize, 20, 4);
        characteristic.setValue(appImageSize, 20, 8);
        this.mService.sendLogBroadcast(1, "Writing to characteristic " + characteristic.getUuid());
        this.mService.sendLogBroadcast(0, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        this.mGatt.writeCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while (this.mImageSizeInProgress && this.mConnected && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to write Image Sizes: device disconnected");
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to write Image Sizes", this.mError);
        }
    }

    private void resetAndRestart(@NonNull BluetoothGatt gatt, @NonNull Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.mService.sendLogBroadcast(15, "Last upload interrupted. Restarting device...");
        this.mProgressInfo.setProgress(-5);
        this.logi("Sending Reset command (Op Code = 6)");
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_RESET);
        this.mService.sendLogBroadcast(10, "Reset request sent");
        this.mService.waitUntilDisconnected();
        this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
        BluetoothGattService gas = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID);
        boolean hasServiceChanged = gas != null && gas.getCharacteristic(SERVICE_CHANGED_UUID) != null;
        this.mService.refreshDeviceCache(gatt, !hasServiceChanged);
        this.mService.close(gatt);
        this.logi("Restarting the service");
        Intent newIntent = new Intent();
        newIntent.fillIn(intent, 24);
        this.restartService(newIntent, false);
    }

    protected class LegacyBluetoothCallback
    extends BaseCustomDfuImpl.BaseCustomBluetoothCallback {
        protected LegacyBluetoothCallback() {
            super(LegacyDfuImpl.this);
        }

        @Override
        protected void onPacketCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (LegacyDfuImpl.this.mImageSizeInProgress) {
                LegacyDfuImpl.this.mService.sendLogBroadcast(5, "Data written to " + characteristic.getUuid() + ", value (0x): " + this.parse(characteristic));
                LegacyDfuImpl.this.mImageSizeInProgress = false;
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            int responseType = characteristic.getIntValue(17, 0);
            switch (responseType) {
                case 17: {
                    LegacyDfuImpl.this.mProgressInfo.setBytesReceived(characteristic.getIntValue(20, 1));
                    this.handlePacketReceiptNotification(gatt, characteristic);
                    break;
                }
                default: {
                    if (LegacyDfuImpl.this.mRemoteErrorOccurred) break;
                    int status = characteristic.getIntValue(17, 2);
                    if (status != 1) {
                        LegacyDfuImpl.this.mRemoteErrorOccurred = true;
                    }
                    this.handleNotification(gatt, characteristic);
                }
            }
            LegacyDfuImpl.this.notifyLock();
        }
    }
}

