/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelUuid;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.annotation.RequiresApi;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.UUID;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.DfuServiceController;
import no.nordicsemi.android.dfu.R;

public final class DfuServiceInitiator {
    public static final int DEFAULT_PRN_VALUE = 12;
    public static final int DEFAULT_MBR_SIZE = 4096;
    public static final int SCOPE_SYSTEM_COMPONENTS = 1;
    public static final int SCOPE_APPLICATION = 2;
    private final String deviceAddress;
    private String deviceName;
    private boolean disableNotification = false;
    private boolean startAsForegroundService = true;
    private Uri fileUri;
    private String filePath;
    private int fileResId;
    private Uri initFileUri;
    private String initFilePath;
    private int initFileResId;
    private String mimeType;
    private int fileType = -1;
    private boolean keepBond;
    private boolean restoreBond;
    private boolean forceDfu = false;
    private boolean enableUnsafeExperimentalButtonlessDfu = false;
    private boolean disableResume = false;
    private int numberOfRetries = 0;
    private int mbrSize = 4096;
    private long dataObjectDelay = 0L;
    private Boolean packetReceiptNotificationsEnabled;
    private int numberOfPackets = 12;
    private int mtu = 517;
    private int currentMtu = 23;
    private Parcelable[] legacyDfuUuids;
    private Parcelable[] secureDfuUuids;
    private Parcelable[] experimentalButtonlessDfuUuids;
    private Parcelable[] buttonlessDfuWithoutBondSharingUuids;
    private Parcelable[] buttonlessDfuWithBondSharingUuids;

    public DfuServiceInitiator(@NonNull String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public DfuServiceInitiator setDeviceName(@Nullable String name) {
        this.deviceName = name;
        return this;
    }

    public DfuServiceInitiator setDisableNotification(boolean disableNotification) {
        this.disableNotification = disableNotification;
        return this;
    }

    public DfuServiceInitiator setForeground(boolean foreground) {
        this.startAsForegroundService = foreground;
        return this;
    }

    public DfuServiceInitiator setKeepBond(boolean keepBond) {
        this.keepBond = keepBond;
        return this;
    }

    public DfuServiceInitiator setRestoreBond(boolean restoreBond) {
        this.restoreBond = restoreBond;
        return this;
    }

    public DfuServiceInitiator setPrepareDataObjectDelay(long delay) {
        this.dataObjectDelay = delay;
        return this;
    }

    public DfuServiceInitiator setPacketsReceiptNotificationsEnabled(boolean enabled) {
        this.packetReceiptNotificationsEnabled = enabled;
        return this;
    }

    public DfuServiceInitiator setPacketsReceiptNotificationsValue(@IntRange(from=0L) int number) {
        this.numberOfPackets = number > 0 ? number : 12;
        return this;
    }

    public DfuServiceInitiator setForceDfu(boolean force) {
        this.forceDfu = force;
        return this;
    }

    public DfuServiceInitiator disableResume() {
        this.disableResume = true;
        return this;
    }

    public DfuServiceInitiator setNumberOfRetries(@IntRange(from=0L) int max) {
        this.numberOfRetries = max;
        return this;
    }

    public DfuServiceInitiator setMtu(@IntRange(from=23L, to=517L) int mtu) {
        this.mtu = mtu;
        return this;
    }

    public DfuServiceInitiator setCurrentMtu(@IntRange(from=23L, to=517L) int mtu) {
        this.currentMtu = mtu;
        return this;
    }

    public DfuServiceInitiator disableMtuRequest() {
        this.mtu = 0;
        return this;
    }

    public DfuServiceInitiator setScope(int scope) {
        if (!"application/zip".equals(this.mimeType)) {
            throw new UnsupportedOperationException("Scope can be set only for a ZIP file");
        }
        if (scope == 2) {
            this.fileType = 4;
        } else if (scope == 1) {
            this.fileType = 3;
        } else if (scope == 3) {
            this.fileType = 0;
        } else {
            throw new UnsupportedOperationException("Unknown scope");
        }
        return this;
    }

    public DfuServiceInitiator setMbrSize(@IntRange(from=0L) int mbrSize) {
        this.mbrSize = mbrSize;
        return this;
    }

    public DfuServiceInitiator setUnsafeExperimentalButtonlessServiceInSecureDfuEnabled(boolean enable) {
        this.enableUnsafeExperimentalButtonlessDfu = enable;
        return this;
    }

    public DfuServiceInitiator setCustomUuidsForLegacyDfu(@Nullable UUID dfuServiceUuid, @Nullable UUID dfuControlPointUuid, @Nullable UUID dfuPacketUuid, @Nullable UUID dfuVersionUuid) {
        ParcelUuid[] uuids = new ParcelUuid[]{dfuServiceUuid != null ? new ParcelUuid(dfuServiceUuid) : null, dfuControlPointUuid != null ? new ParcelUuid(dfuControlPointUuid) : null, dfuPacketUuid != null ? new ParcelUuid(dfuPacketUuid) : null, dfuVersionUuid != null ? new ParcelUuid(dfuVersionUuid) : null};
        this.legacyDfuUuids = uuids;
        return this;
    }

    public DfuServiceInitiator setCustomUuidsForSecureDfu(@Nullable UUID dfuServiceUuid, @Nullable UUID dfuControlPointUuid, @Nullable UUID dfuPacketUuid) {
        ParcelUuid[] uuids = new ParcelUuid[]{dfuServiceUuid != null ? new ParcelUuid(dfuServiceUuid) : null, dfuControlPointUuid != null ? new ParcelUuid(dfuControlPointUuid) : null, dfuPacketUuid != null ? new ParcelUuid(dfuPacketUuid) : null};
        this.secureDfuUuids = uuids;
        return this;
    }

    public DfuServiceInitiator setCustomUuidsForExperimentalButtonlessDfu(@Nullable UUID buttonlessDfuServiceUuid, @Nullable UUID buttonlessDfuControlPointUuid) {
        ParcelUuid[] uuids = new ParcelUuid[]{buttonlessDfuServiceUuid != null ? new ParcelUuid(buttonlessDfuServiceUuid) : null, buttonlessDfuControlPointUuid != null ? new ParcelUuid(buttonlessDfuControlPointUuid) : null};
        this.experimentalButtonlessDfuUuids = uuids;
        return this;
    }

    public DfuServiceInitiator setCustomUuidsForButtonlessDfuWithBondSharing(@Nullable UUID buttonlessDfuServiceUuid, @Nullable UUID buttonlessDfuControlPointUuid) {
        ParcelUuid[] uuids = new ParcelUuid[]{buttonlessDfuServiceUuid != null ? new ParcelUuid(buttonlessDfuServiceUuid) : null, buttonlessDfuControlPointUuid != null ? new ParcelUuid(buttonlessDfuControlPointUuid) : null};
        this.buttonlessDfuWithBondSharingUuids = uuids;
        return this;
    }

    public DfuServiceInitiator setCustomUuidsForButtonlessDfuWithoutBondSharing(@Nullable UUID buttonlessDfuServiceUuid, @Nullable UUID buttonlessDfuControlPointUuid) {
        ParcelUuid[] uuids = new ParcelUuid[]{buttonlessDfuServiceUuid != null ? new ParcelUuid(buttonlessDfuServiceUuid) : null, buttonlessDfuControlPointUuid != null ? new ParcelUuid(buttonlessDfuControlPointUuid) : null};
        this.buttonlessDfuWithoutBondSharingUuids = uuids;
        return this;
    }

    public DfuServiceInitiator setZip(@NonNull Uri uri) {
        return this.init(uri, null, 0, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(@NonNull String path) {
        return this.init(null, path, 0, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(@RawRes int rawResId) {
        return this.init(null, null, rawResId, 0, "application/zip");
    }

    public DfuServiceInitiator setZip(@Nullable Uri uri, @Nullable String path) {
        return this.init(uri, path, 0, 0, "application/zip");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, @NonNull Uri uri) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(uri, null, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, @NonNull String path) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(null, path, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, @Nullable Uri uri, @Nullable String path) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(uri, path, 0, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setBinOrHex(int fileType, @RawRes int rawResId) {
        if (fileType == 0) {
            throw new UnsupportedOperationException("You must specify the file type");
        }
        return this.init(null, null, rawResId, fileType, "application/octet-stream");
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(@NonNull Uri initFileUri) {
        return this.init(initFileUri, null, 0);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(@Nullable String initFilePath) {
        return this.init(null, initFilePath, 0);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(@RawRes int initFileResId) {
        return this.init(null, null, initFileResId);
    }

    @Deprecated
    public DfuServiceInitiator setInitFile(@Nullable Uri initFileUri, @Nullable String initFilePath) {
        return this.init(initFileUri, initFilePath, 0);
    }

    public DfuServiceController start(@NonNull Context context, @NonNull Class<? extends DfuBaseService> service) {
        if (this.fileType == -1) {
            throw new UnsupportedOperationException("You must specify the firmware file before starting the service");
        }
        Intent intent = new Intent(context, service);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_ADDRESS", this.deviceAddress);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DEVICE_NAME", this.deviceName);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_NOTIFICATION", this.disableNotification);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FOREGROUND_SERVICE", this.startAsForegroundService);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MIME_TYPE", this.mimeType);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_TYPE", this.fileType);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_URI", (Parcelable)this.fileUri);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_PATH", this.filePath);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FILE_RES_ID", this.fileResId);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_URI", (Parcelable)this.initFileUri);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_PATH", this.initFilePath);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_INIT_FILE_RES_ID", this.initFileResId);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", this.keepBond);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND", this.restoreBond);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_FORCE_DFU", this.forceDfu);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DISABLE_RESUME", this.disableResume);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MAX_DFU_ATTEMPTS", this.numberOfRetries);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MBR_SIZE", this.mbrSize);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_DATA_OBJECT_DELAY", this.dataObjectDelay);
        if (this.mtu > 0) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_MTU", this.mtu);
        }
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CURRENT_MTU", this.currentMtu);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_UNSAFE_EXPERIMENTAL_BUTTONLESS_DFU", this.enableUnsafeExperimentalButtonlessDfu);
        if (this.packetReceiptNotificationsEnabled != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_ENABLED", (Serializable)this.packetReceiptNotificationsEnabled);
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_PRN_VALUE", this.numberOfPackets);
        }
        if (this.legacyDfuUuids != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_LEGACY_DFU", this.legacyDfuUuids);
        }
        if (this.secureDfuUuids != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_SECURE_DFU", this.secureDfuUuids);
        }
        if (this.experimentalButtonlessDfuUuids != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_EXPERIMENTAL_BUTTONLESS_DFU", this.experimentalButtonlessDfuUuids);
        }
        if (this.buttonlessDfuWithoutBondSharingUuids != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITHOUT_BOND_SHARING", this.buttonlessDfuWithoutBondSharingUuids);
        }
        if (this.buttonlessDfuWithBondSharingUuids != null) {
            intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_CUSTOM_UUIDS_FOR_BUTTONLESS_DFU_WITH_BOND_SHARING", this.buttonlessDfuWithBondSharingUuids);
        }
        if (Build.VERSION.SDK_INT >= 26 && this.startAsForegroundService) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
        return new DfuServiceController(context);
    }

    private DfuServiceInitiator init(@Nullable Uri initFileUri, @Nullable String initFilePath, @RawRes int initFileResId) {
        if ("application/zip".equals(this.mimeType)) {
            throw new InvalidParameterException("Init file must be located inside the ZIP");
        }
        this.initFileUri = initFileUri;
        this.initFilePath = initFilePath;
        this.initFileResId = initFileResId;
        return this;
    }

    private DfuServiceInitiator init(@Nullable Uri fileUri, @Nullable String filePath, @RawRes int fileResId, int fileType, @NonNull String mimeType) {
        this.fileUri = fileUri;
        this.filePath = filePath;
        this.fileResId = fileResId;
        this.fileType = fileType;
        this.mimeType = mimeType;
        if ("application/zip".equals(mimeType)) {
            this.initFileUri = null;
            this.initFilePath = null;
            this.initFileResId = 0;
        }
        return this;
    }

    @RequiresApi(api=26)
    public static void createDfuNotificationChannel(@NonNull Context context) {
        NotificationChannel channel = new NotificationChannel("dfu", (CharSequence)context.getString(R.string.dfu_channel_name), 2);
        channel.setDescription(context.getString(R.string.dfu_channel_description));
        channel.setShowBadge(false);
        channel.setLockscreenVisibility(1);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.createNotificationChannel(channel);
        }
    }
}

