/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import java.util.UUID;
import no.nordicsemi.android.dfu.ButtonlessDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.SecureDfuImpl;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

class ButtonlessDfuWithBondSharingImpl
extends ButtonlessDfuImpl {
    protected static final UUID DEFAULT_BUTTONLESS_DFU_SERVICE_UUID = SecureDfuImpl.DEFAULT_DFU_SERVICE_UUID;
    protected static final UUID DEFAULT_BUTTONLESS_DFU_UUID = new UUID(-8157989228746813600L, -6937650605005804976L);
    protected static UUID BUTTONLESS_DFU_SERVICE_UUID = DEFAULT_BUTTONLESS_DFU_SERVICE_UUID;
    protected static UUID BUTTONLESS_DFU_UUID = DEFAULT_BUTTONLESS_DFU_UUID;
    private BluetoothGattCharacteristic mButtonlessDfuCharacteristic;

    ButtonlessDfuWithBondSharingImpl(Intent intent, DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public boolean isClientCompatible(Intent intent, BluetoothGatt gatt) {
        BluetoothGattService dfuService = gatt.getService(BUTTONLESS_DFU_SERVICE_UUID);
        if (dfuService == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = dfuService.getCharacteristic(BUTTONLESS_DFU_UUID);
        if (characteristic == null || characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG) == null) {
            return false;
        }
        this.mButtonlessDfuCharacteristic = characteristic;
        return true;
    }

    @Override
    protected int getResponseType() {
        return 2;
    }

    @Override
    protected BluetoothGattCharacteristic getButtonlessDfuCharacteristic() {
        return this.mButtonlessDfuCharacteristic;
    }

    @Override
    protected boolean shouldScanForBootloader() {
        return false;
    }

    @Override
    public void performDfu(Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.logi("Buttonless service with bond sharing found -> SDK 14 or newer");
        if (!this.isBonded()) {
            this.logw("Device is not paired, cancelling DFU");
            this.mService.sendLogBroadcast(15, "Device is not bonded");
            this.mService.terminateConnection(this.mGatt, 4110);
            return;
        }
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_KEEP_BOND", true);
        intent.putExtra("no.nordicsemi.android.dfu.extra.EXTRA_RESTORE_BOND", false);
        super.performDfu(intent);
    }
}

