/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.os.SystemClock;
import android.support.annotation.NonNull;

class DfuProgressInfo {
    private final ProgressListener mListener;
    private int progress;
    private int bytesSent;
    private int initialBytesSent;
    private int lastBytesSent;
    private int bytesReceived;
    private int imageSizeInBytes;
    private int maxObjectSizeInBytes;
    private int currentPart;
    private int totalParts;
    private long timeStart;
    private long lastProgressTime;

    DfuProgressInfo(@NonNull ProgressListener listener) {
        this.mListener = listener;
    }

    DfuProgressInfo init(int imageSizeInBytes, int currentPart, int totalParts) {
        this.imageSizeInBytes = imageSizeInBytes;
        this.maxObjectSizeInBytes = Integer.MAX_VALUE;
        this.currentPart = currentPart;
        this.totalParts = totalParts;
        return this;
    }

    DfuProgressInfo setTotalPart(int totalParts) {
        this.totalParts = totalParts;
        return this;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.mListener.updateProgressNotification();
    }

    void setBytesSent(int bytesSent) {
        if (this.timeStart == 0L) {
            this.timeStart = SystemClock.elapsedRealtime();
            this.initialBytesSent = bytesSent;
        }
        this.bytesSent = bytesSent;
        this.progress = (int)(100.0f * (float)bytesSent / (float)this.imageSizeInBytes);
        this.mListener.updateProgressNotification();
    }

    void addBytesSent(int increment) {
        this.setBytesSent(this.bytesSent + increment);
    }

    void setBytesReceived(int bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    void setMaxObjectSizeInBytes(int bytes) {
        this.maxObjectSizeInBytes = bytes;
    }

    boolean isComplete() {
        return this.bytesSent == this.imageSizeInBytes;
    }

    boolean isObjectComplete() {
        return this.bytesSent % this.maxObjectSizeInBytes == 0;
    }

    int getAvailableObjectSizeIsBytes() {
        int remainingBytes = this.imageSizeInBytes - this.bytesSent;
        int remainingChunk = this.maxObjectSizeInBytes - this.bytesSent % this.maxObjectSizeInBytes;
        return Math.min(remainingBytes, remainingChunk);
    }

    int getProgress() {
        return this.progress;
    }

    int getBytesSent() {
        return this.bytesSent;
    }

    int getBytesReceived() {
        return this.bytesReceived;
    }

    int getImageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    float getSpeed() {
        long now = SystemClock.elapsedRealtime();
        float speed = now - this.timeStart != 0L ? (float)(this.bytesSent - this.lastBytesSent) / (float)(now - this.lastProgressTime) : 0.0f;
        this.lastProgressTime = now;
        this.lastBytesSent = this.bytesSent;
        return speed;
    }

    float getAverageSpeed() {
        long now = SystemClock.elapsedRealtime();
        return now - this.timeStart != 0L ? (float)(this.bytesSent - this.initialBytesSent) / (float)(now - this.timeStart) : 0.0f;
    }

    int getCurrentPart() {
        return this.currentPart;
    }

    int getTotalParts() {
        return this.totalParts;
    }

    boolean isLastPart() {
        return this.currentPart == this.totalParts;
    }

    static interface ProgressListener {
        public void updateProgressNotification();
    }
}

