/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.dfu;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.UUID;
import no.nordicsemi.android.dfu.BaseButtonlessDfuImpl;
import no.nordicsemi.android.dfu.DfuBaseService;
import no.nordicsemi.android.dfu.LegacyDfuImpl;
import no.nordicsemi.android.dfu.internal.exception.DeviceDisconnectedException;
import no.nordicsemi.android.dfu.internal.exception.DfuException;
import no.nordicsemi.android.dfu.internal.exception.UploadAbortedException;

class LegacyButtonlessDfuImpl
extends BaseButtonlessDfuImpl {
    protected static UUID DFU_SERVICE_UUID = LegacyDfuImpl.DEFAULT_DFU_SERVICE_UUID;
    protected static UUID DFU_CONTROL_POINT_UUID = LegacyDfuImpl.DEFAULT_DFU_CONTROL_POINT_UUID;
    protected static UUID DFU_VERSION_UUID = LegacyDfuImpl.DEFAULT_DFU_VERSION_UUID;
    private static final byte[] OP_CODE_ENTER_BOOTLOADER = new byte[]{1, 4};
    private BluetoothGattCharacteristic mControlPointCharacteristic;
    private int mVersion;

    LegacyButtonlessDfuImpl(Intent intent, DfuBaseService service) {
        super(intent, service);
    }

    @Override
    public boolean isClientCompatible(Intent intent, BluetoothGatt gatt) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        boolean moreServicesFound;
        BluetoothGattService dfuService = gatt.getService(DFU_SERVICE_UUID);
        if (dfuService == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristic = dfuService.getCharacteristic(DFU_CONTROL_POINT_UUID);
        if (characteristic == null || characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG) == null) {
            return false;
        }
        this.mControlPointCharacteristic = characteristic;
        this.mProgressInfo.setProgress(-2);
        this.mService.waitFor(1000);
        int version = 0;
        BluetoothGattCharacteristic versionCharacteristic = dfuService.getCharacteristic(DFU_VERSION_UUID);
        if (versionCharacteristic != null) {
            version = this.mVersion = this.readVersion(gatt, versionCharacteristic);
            int minor = version & 0xF;
            int major = version >> 8;
            this.logi("Version number read: " + major + "." + minor + " -> " + this.getVersionFeatures(version));
            this.mService.sendLogBroadcast(10, "Version number read: " + major + "." + minor);
        } else {
            this.logi("No DFU Version characteristic found -> " + this.getVersionFeatures(version));
            this.mService.sendLogBroadcast(10, "DFU Version characteristic not found");
        }
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mService);
        boolean assumeDfuMode = preferences.getBoolean("settings_assume_dfu_mode", false);
        if (intent.hasExtra("no.nordicsemi.android.dfu.extra.EXTRA_FORCE_DFU")) {
            assumeDfuMode = intent.getBooleanExtra("no.nordicsemi.android.dfu.extra.EXTRA_FORCE_DFU", false);
        }
        boolean bl = moreServicesFound = gatt.getServices().size() > 3;
        if (version == 0 && moreServicesFound) {
            this.logi("Additional services found -> Bootloader from SDK 6.1. Updating SD and BL supported, extended init packet not supported");
        }
        return version == 1 || !assumeDfuMode && version == 0 && moreServicesFound;
    }

    @Override
    public void performDfu(Intent intent) throws DfuException, DeviceDisconnectedException, UploadAbortedException {
        this.logw("Application with legacy buttonless update found");
        this.mService.sendLogBroadcast(15, "Application with buttonless update found");
        this.mService.sendLogBroadcast(1, "Jumping to the DFU Bootloader...");
        this.enableCCCD(this.mControlPointCharacteristic, 1);
        this.mService.sendLogBroadcast(10, "Notifications enabled");
        this.mService.waitFor(1000);
        this.mProgressInfo.setProgress(-3);
        this.logi("Sending Start DFU command (Op Code = 1, Upload Mode = 4)");
        this.writeOpCode(this.mControlPointCharacteristic, OP_CODE_ENTER_BOOTLOADER, true);
        this.mService.sendLogBroadcast(10, "Jump to bootloader sent (Op Code = 1, Upload Mode = 4)");
        this.mService.waitUntilDisconnected();
        this.mService.sendLogBroadcast(5, "Disconnected by the remote device");
        BluetoothGatt gatt = this.mGatt;
        BluetoothGattService gas = gatt.getService(GENERIC_ATTRIBUTE_SERVICE_UUID);
        boolean hasServiceChanged = gas != null && gas.getCharacteristic(SERVICE_CHANGED_UUID) != null;
        this.mService.refreshDeviceCache(gatt, !hasServiceChanged);
        this.mService.close(gatt);
        this.logi("Starting service that will connect to the DFU bootloader");
        Intent newIntent = new Intent();
        newIntent.fillIn(intent, 24);
        this.restartService(newIntent, this.mVersion == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersion(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) throws DeviceDisconnectedException, DfuException, UploadAbortedException {
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read version number: device disconnected");
        }
        if (this.mAborted) {
            throw new UploadAbortedException();
        }
        if (characteristic == null) {
            return 0;
        }
        this.mReceivedData = null;
        this.mError = 0;
        this.logi("Reading DFU version number...");
        this.mService.sendLogBroadcast(1, "Reading DFU version number...");
        characteristic.setValue((byte[])null);
        this.mService.sendLogBroadcast(0, "gatt.readCharacteristic(" + characteristic.getUuid() + ")");
        gatt.readCharacteristic(characteristic);
        try {
            Object object = this.mLock;
            synchronized (object) {
                while ((!this.mRequestCompleted || characteristic.getValue() == null) && this.mConnected && this.mError == 0 && !this.mAborted || this.mPaused) {
                    this.mRequestCompleted = false;
                    this.mLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            this.loge("Sleeping interrupted", e);
        }
        if (this.mError != 0) {
            throw new DfuException("Unable to read version number", this.mError);
        }
        if (!this.mConnected) {
            throw new DeviceDisconnectedException("Unable to read version number: device disconnected");
        }
        return characteristic.getIntValue(18, 0);
    }

    private String getVersionFeatures(int version) {
        switch (version) {
            case 0: {
                return "Bootloader from SDK 6.1 or older";
            }
            case 1: {
                return "Application with Legacy buttonless update from SDK 7.0 or newer";
            }
            case 5: {
                return "Bootloader from SDK 7.0 or newer. No bond sharing";
            }
            case 6: {
                return "Bootloader from SDK 8.0 or newer. Bond sharing supported";
            }
            case 7: {
                return "Bootloader from SDK 8.0 or newer. SHA-256 used instead of CRC-16 in the Init Packet";
            }
            case 8: {
                return "Bootloader from SDK 9.0 or newer. Signature supported";
            }
        }
        return "Unknown version";
    }
}

